function [ beta_lambda_vec ] = get_beta_lambda_vec( param, analysis, excess_returns, factors, c_fac )
% We vectorize beta_lambda such that the rows are first transposed and then
% vertically concatenated. This vector-valued function returns N*K function
% values evaluated at param. It is used for the delta method to compute the
% vc-matrix of beta_lambda.

beta_lambda=get_beta_lambda( param, analysis, excess_returns, factors, c_fac );

beta_lambda_vec=reshape(beta_lambda',[numel(beta_lambda),1]);
end

