function [ Avar_g_T,Avar_param ] = var_GMM( param, analysis, excess_returns, factors, factor_type, c_fac, mim_proj_var, mim_base_assets )
% Procedure uses GMM estimates (param) to compute an estimate of the
% asymptotic VC matrices of estimates and g_T (sample moment conditions
% evaluated at the GMM estimates

g_T = get_g_T( param, analysis, excess_returns, factors, factor_type, c_fac, mim_proj_var, mim_base_assets );

    % sample moment conditions

ahat=get_a_T( param, excess_returns, analysis, factors, factor_type, c_fac, mim_base_assets);
    % number of parameters x number of moment conditions

func=@(param)get_g_T( param, analysis, excess_returns, factors, factor_type, c_fac, mim_proj_var, mim_base_assets );    

[dhat,~]=jacobianest(func,param);
    % number of moment conditions x number of parameters (g_T from get_g_T
    % function)

Shat=S_estimate( param, analysis, excess_returns, factors, factor_type, c_fac, mim_proj_var, mim_base_assets );
    % number of moment conditions x number of moment conditions
    % S_estimate function still needs to be written

    % variance-covariance matrix of g_T
Avar_g_T=(eye(size(dhat,1))-dhat/(ahat*dhat)*ahat)*Shat*(eye(size(dhat,1))-dhat/(ahat*dhat)*ahat)';
%Avar_g_T=(eye(size(dhat,1))-dhat*inv(ahat*dhat)*ahat)*Shat*(eye(size(dhat,1))-dhat*inv(ahat*dhat)*ahat)';

    % variance-covraiance matrix of the parameters
Avar_param=(ahat*dhat)\(ahat*Shat*ahat')*(inv(ahat*dhat))';
%Avar_param=inv(ahat*dhat)*ahat*Shat*ahat'*(inv(ahat*dhat))';

end

