/*
 * Decompiled with CFR 0.152.
 */
package efault;

import efault.Config;
import efault.ErrorStreamDumper;
import efault.Main;
import genomic.Gene;
import genomic.NCRNA;
import genomic.NCRNATranscript;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import rfam.RfamTest;
import sidd.SIDDProfileReader;
import term.Terminator;

public class NCRNAPlotter {
    private File plotDataFile;
    private File rScriptFile;
    private boolean asPdf;
    private int numOfCols;

    public NCRNAPlotter(boolean asPdf) {
        this.asPdf = asPdf;
        this.plotDataFile = new File(String.valueOf(Main.genomeDir.getAbsolutePath()) + "/plotData.out");
        this.rScriptFile = new File(String.valueOf(Main.genomeDir.getAbsolutePath()) + "/plotScript.R");
        this.plotDataFile.deleteOnExit();
        this.rScriptFile.deleteOnExit();
    }

    public void plotNCRNAs(String[] IDs) throws Exception {
        this.writePlotDataFile(IDs);
        this.writeRScript();
        this.runR();
    }

    private void runR() throws Exception {
        ProcessBuilder rBuilder = new ProcessBuilder("R", "--no-save", "-f", this.rScriptFile.getAbsolutePath());
        Process r = rBuilder.start();
        ErrorStreamDumper d1 = new ErrorStreamDumper(r.getInputStream());
        ErrorStreamDumper d2 = new ErrorStreamDumper(r.getErrorStream());
        d1.run();
        d2.run();
        r.waitFor();
        d1.join();
        d2.join();
    }

    private void writePlotDataFile(String[] IDs) throws Exception {
        HashSet<String> IDset = new HashSet<String>();
        if (IDs == null) {
            for (NCRNA nc : Main.ncRNAs) {
                IDset.add(nc.getID().toLowerCase(Locale.ENGLISH));
            }
        } else {
            String[] stringArray = IDs;
            int n = IDs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                IDset.add(s.toLowerCase(Locale.ENGLISH));
                ++n2;
            }
        }
        int contextRange = Config.getInt("plotFlankingRegionSize");
        SIDDProfileReader siddReader = new SIDDProfileReader(Main.siddProfileFile.getAbsolutePath(), Main.genome.getLength());
        siddReader.readProfile();
        double[] Gx = siddReader.getGx();
        BufferedWriter w = new BufferedWriter(new FileWriter(this.plotDataFile));
        Iterator<NCRNA> ncrnaIt = Main.ncRNAs.iterator();
        StringBuffer titleString = new StringBuffer();
        while (ncrnaIt.hasNext()) {
            NCRNA currNCRNA = ncrnaIt.next();
            if (!IDset.contains(currNCRNA.getID().toLowerCase(Locale.ENGLISH))) continue;
            int startRegion = currNCRNA.getStart() - contextRange;
            int endRegion = currNCRNA.getEnd() + contextRange;
            if (startRegion - 1 < 0) {
                startRegion = 1;
            }
            if (endRegion - 1 >= Gx.length) {
                endRegion = Gx.length;
            }
            this.numOfCols = Math.max(endRegion - startRegion + 1 + 5, this.numOfCols);
            titleString.setLength(0);
            titleString.append(currNCRNA.getID());
            if (currNCRNA.getStrand() != '.') {
                titleString.append("(" + currNCRNA.getStrand() + ")");
            }
            for (Gene currGene : currNCRNA.getGenes()) {
                titleString.append("_" + currGene.getID() + "(" + currGene.getStrand() + ")");
            }
            int i = startRegion;
            while (i <= endRegion) {
                w.write(String.valueOf(Gx[i - 1]) + "\t");
                ++i;
            }
            w.write(String.valueOf(startRegion) + "\t");
            w.write(String.valueOf(endRegion) + "\t");
            w.write(String.valueOf(currNCRNA.getStart()) + "\t");
            w.write(String.valueOf(currNCRNA.getEnd()) + "\t");
            w.write(String.valueOf(titleString.toString()) + "\n");
            for (Gene currGene : currNCRNA.getGenes()) {
                if (currGene.getStrand() == '-') {
                    w.write(String.valueOf(currGene.getEnd()) + "\t" + currGene.getStart() + "\t");
                    continue;
                }
                w.write(String.valueOf(currGene.getStart()) + "\t" + currGene.getEnd() + "\t");
            }
            w.write("\n");
            for (Terminator currTerm : currNCRNA.getTerminators()) {
                if (currTerm.getStrand() == '-') {
                    w.write(String.valueOf(currTerm.getEnd()) + "\t" + currTerm.getStart() + "\t");
                    continue;
                }
                w.write(String.valueOf(currTerm.getStart()) + "\t" + currTerm.getEnd() + "\t");
            }
            w.write("\n");
            for (NCRNATranscript tu : currNCRNA.getPredictedNCRNATranscripts()) {
                if (tu.getStrand() == '-') {
                    w.write(String.valueOf(tu.getEnd()) + "\t" + tu.getStart() + "\t");
                    continue;
                }
                w.write(String.valueOf(tu.getStart()) + "\t" + tu.getEnd() + "\t");
            }
            w.write("\n");
            for (RfamTest anno : currNCRNA.getAnnotations()) {
                if (anno.getStrand() == '-') {
                    w.write(String.valueOf(anno.getEnd()) + "\t" + anno.getStart() + "\t");
                    continue;
                }
                w.write(String.valueOf(anno.getStart()) + "\t" + anno.getEnd() + "\t");
            }
            w.write("\n");
        }
        w.close();
        this.numOfCols += 50;
    }

    private void writeRScript() throws Exception {
        String script = "filename <- \"" + this.plotDataFile.getAbsolutePath() + "\"\n" + "plot.ncrnas.jpeg <- function(filename)\n" + "{\n" + "\tdataTable <- read.delim(filename,header=FALSE,col.names=c(1:" + this.numOfCols + "),blank.lines.skip=FALSE)\n" + "\ti <- 1\n" + "\twhile(i <= (nrow(dataTable)-4))\n" + "\t{\n" + "\t\tdata <- dataTable[i,]\n" + "\t\tdata <- data[!is.na(data)]\n" + "\t\tdata <- data[data != \"\"]\n" + "\n" + "\t\tlen <- length(data)\n" + "\t\tstartReg <- as.numeric(data[len-4])\n" + "\t\tendReg <- as.numeric(data[len-3])\n" + "\t\tstartNCRNA <- as.numeric(data[len-2])\n" + "\t\tendNCRNA <- as.numeric(data[len-1])\n" + "\t\tname <- as.character(data[len])\n" + "\n" + "\t\tgenes <- as.numeric(dataTable[(i+1),])\n" + "\t\tgenes <- genes[!is.na(genes)]\n" + "\t\tgenes <- genes[genes != \"\"]\n" + "\n" + "\t\tterms <- as.numeric(dataTable[(i+2),])\n" + "\t\tterms <- terms[!is.na(terms)]\n" + "\t\tterms <- terms[terms != \"\"]\n" + "\n" + "\t\ttus <- as.numeric(dataTable[(i+3),])\n" + "\t\ttus <- tus[!is.na(tus)]\n" + "\t\ttus <- tus[tus != \"\"]\n" + "\n" + "\t\tannos <- as.numeric(dataTable[(i+4),])\n" + "\t\tannos <- annos[!is.na(annos)]\n" + "\t\tannos <- annos[annos != \"\"]\n" + "\n" + "\t\tjpeg(paste(\"" + Main.genomeDir.getAbsolutePath() + "/ncrnaSiddPlot\",((i-1)%/%5)+1,\".jpg\", sep=\"\"), width=800, height=800, quality=100, res=125)\n" + "\t\tplot(startReg:endReg,as.numeric(data[1:(len-5)]),type=\"l\",main=name,ylim=c(-2.5,11),xlab=\"Position [nt]\",ylab=\"G [kcal/mol]\")\n" + "\t\tlines(c(startNCRNA,endNCRNA),c(-0.5,-0.5))\n" + "\n" + "\t\t#annos\n" + "\t\tt <- 1\n" + "\t\twhile(t <= (length(annos)-1))\n" + "\t\t{\n" + "\t\t\tarrows(annos[t],0.5,annos[t+1],0.5,col=\"darkred\")\n" + "\t\t\tt <- t+2\n" + "\t\t}\n" + "\t\t\n" + "\t\t#terms\n" + "\t\tt <- 1\n" + "\t\twhile(t <= (length(terms)-1))\n" + "\t\t{\n" + "\t\t\tarrows(terms[t],-1.2,terms[t+1],-1.2)\n" + "\t\t\tt <- t+2\n" + "\t\t}\n" + "\t\t\n" + "\t\t#tus\n" + "\t\ttt <- 1\n" + "\t\tycord <- 0\n" + "\t\twhile(tt <= (length(tus)-1))\n" + "\t\t{\n" + "\t\t\tif(tus[tt]>tus[tt+1]){ycord <- -1.9;}\n" + "\t\t\telse{ycord <- -1.8;}\n" + "\t\t\tarrows(tus[tt],ycord,tus[tt+1],ycord,col=\"darkblue\")\n" + "\t\t\ttt <- tt+2\n" + "\t\t}\n" + "\t\t\n" + "\t\t#genes\n" + "\t\tg <- 1\n" + "\t\twhile(g <= (length(genes)-1))\n" + "\t\t{\n" + "\t\t\tarrows(genes[g],-2.5,genes[g+1],-2.5,col=\"darkgreen\")\n" + "\t\t\tg <- g+2\n" + "\t\t}\n" + "\t\tdev.off()\n" + "\t\ti <- i+5\n" + "\t}\n" + "} \n" + "\n" + "plot.ncrnas.pdf <- function(filename)\n" + "{\n" + "\tdataTable <- read.delim(filename,header=FALSE,col.names=c(1:" + this.numOfCols + "),blank.lines.skip=FALSE)\n" + "\tpdf(\"" + Main.genomeDir.getAbsolutePath() + "/ncrnaSiddPlots.pdf\")\n" + "\ti <- 1\n" + "\twhile(i <= (nrow(dataTable)-4))\n" + "\t{\n" + "\t\tdata <- dataTable[i,]\n" + "\t\tdata <- data[!is.na(data)]\n" + "\t\tdata <- data[data != \"\"]\n" + "\n" + "\t\tlen <- length(data)\n" + "\t\tstartReg <- as.numeric(data[len-4])\n" + "\t\tendReg <- as.numeric(data[len-3])\n" + "\t\tstartNCRNA <- as.numeric(data[len-2])\n" + "\t\tendNCRNA <- as.numeric(data[len-1])\n" + "\t\tname <- as.character(data[len])\n" + "\n" + "\t\tgenes <- as.numeric(dataTable[(i+1),])\n" + "\t\tgenes <- genes[!is.na(genes)]\n" + "\t\tgenes <- genes[genes != \"\"]\n" + "\n" + "\t\tterms <- as.numeric(dataTable[(i+2),])\n" + "\t\tterms <- terms[!is.na(terms)]\n" + "\t\tterms <- terms[terms != \"\"]\n" + "\n" + "\t\ttus <- as.numeric(dataTable[(i+3),])\n" + "\t\ttus <- tus[!is.na(tus)]\n" + "\t\ttus <- tus[tus != \"\"]\n" + "\n" + "\t\tannos <- as.numeric(dataTable[(i+4),])\n" + "\t\tannos <- annos[!is.na(annos)]\n" + "\t\tannos <- annos[annos != \"\"]\n" + "\n" + "\t\tplot(startReg:endReg,as.numeric(data[1:(len-5)]),type=\"l\",main=name,ylim=c(-2.5,11),xlab=\"Position [nt]\",ylab=\"G [kcal/mol]\")\n" + "\t\tlines(c(startNCRNA,endNCRNA),c(-0.5,-0.5))\n" + "\n" + "\t\t#annos\n" + "\t\tt <- 1\n" + "\t\twhile(t <= (length(annos)-1))\n" + "\t\t{\n" + "\t\t\tarrows(annos[t],0.5,annos[t+1],0.5,col=\"darkred\")\n" + "\t\t\tt <- t+2\n" + "\t\t}\n" + "\t\t\n" + "\t\t#terms\n" + "\t\tt <- 1\n" + "\t\twhile(t <= (length(terms)-1))\n" + "\t\t{\n" + "\t\t\tarrows(terms[t],-1.2,terms[t+1],-1.2)\n" + "\t\t\tt <- t+2\n" + "\t\t}\n" + "\t\t\n" + "\t\t#tus\n" + "\t\ttt <- 1\n" + "\t\tycord <- 0\n" + "\t\twhile(tt <= (length(tus)-1))\n" + "\t\t{\n" + "\t\t\tif(tus[tt]>tus[tt+1]){ycord <- -1.83;}\n" + "\t\t\telse{ycord <- -1.8;}\n" + "\t\t\tarrows(tus[tt],ycord,tus[tt+1],ycord,col=\"darkblue\")\n" + "\t\t\ttt <- tt+2\n" + "\t\t}\n" + "\t\t\n" + "\t\t#genes\n" + "\t\tg <- 1\n" + "\t\twhile(g <= (length(genes)-1))\n" + "\t\t{\n" + "\t\t\tarrows(genes[g],-2.5,genes[g+1],-2.5,col=\"darkgreen\")\n" + "\t\t\tg <- g+2\n" + "\t\t}\n" + "\t\t\n" + "\t\ti <- i+5\n" + "\t}\n" + "\tdev.off()\n" + "} \n";
        script = this.asPdf ? String.valueOf(script) + "plot.ncrnas.pdf(filename)" : String.valueOf(script) + "plot.ncrnas.jpeg(filename)";
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.rScriptFile));
        bw.append(script);
        bw.close();
    }
}

