/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import genomic.AbstractSequenceFeature;
import seq.DNASequence;
import seq.Sequence;
import seq.SequenceTools;

public class Genome
extends AbstractSequenceFeature {
    private double[] gibbsEnergies;
    private double meanGibbsEnergy;
    private double sdGibbsEnergy;

    public Genome() {
        this("", new DNASequence());
    }

    public Genome(String ID, DNASequence sequence) {
        super(ID.split("[\\s]+")[0], 1, sequence.getLength(), '+');
        this.setSequence(sequence);
    }

    public DNASequence getSeqForSequenceFeature(AbstractSequenceFeature sf) {
        DNASequence res = this.getSequence().getSubsequence(sf.getStart(), sf.getEnd());
        if (sf.getStrand() == '-') {
            res = SequenceTools.reverseComplementDNA(res);
        }
        return res;
    }

    public void calculateGibbsEnergies() {
        if (this.getSequence().getLength() == 0) {
            return;
        }
        this.gibbsEnergies = SequenceTools.getGibbsEnergies(this.getSequence());
        double mean = 0.0;
        int i = 0;
        while (i < this.gibbsEnergies.length) {
            mean += this.gibbsEnergies[i];
            ++i;
        }
        this.meanGibbsEnergy = mean /= (double)this.gibbsEnergies.length;
        double sd = 0.0;
        int i2 = 0;
        while (i2 < this.gibbsEnergies.length) {
            sd += Math.pow(this.gibbsEnergies[i2] - mean, 2.0);
            ++i2;
        }
        sd /= (double)this.gibbsEnergies.length;
        this.sdGibbsEnergy = sd = Math.sqrt(sd);
    }

    public double getMeanGibbsEnergy() {
        return this.meanGibbsEnergy;
    }

    public double getSdGibbsEnergy() {
        return this.sdGibbsEnergy;
    }

    public double getGibbsEnergyAt(int pos) {
        return this.gibbsEnergies[pos - 1];
    }

    @Override
    public boolean isSequenceConsitentWithFeatureType(Sequence seq) {
        return seq instanceof DNASequence;
    }

    @Override
    public DNASequence getSequence() {
        return (DNASequence)super.getSequence();
    }

    @Override
    public String toGFFString() {
        return null;
    }
}

