/*
 * Decompiled with CFR 0.152.
 */
package interact;

import efault.Config;
import efault.ErrorStreamDumper;
import efault.Main;
import efault.ProcessStreamHandler;
import genomic.AbstractSequenceFeature;
import genomic.Genome;
import interact.IntaRNAParser;
import interact.TranskriptInteraction;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.LinkedList;
import java.util.List;
import seq.DNASequence;
import seq.FASTAEntry;
import seq.FASTAWriter;
import seq.SequenceTools;

public class IntarnaScanner {
    private File intarnaPath = new File(Config.getString("intarnaPath"));
    private File tmpOutShort = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/intarnatmpshort.out");
    private File tmpOutLong = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/intarnatmplong.out");
    private File tmpFastaHshort = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/intarnatmpfastahshort.fa");
    private File tmpFastaHlong = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/intarnatmpfastahlong.fa");
    private File tmpFastaT = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/intarnatmpfastat.fa");
    private Genome genome;
    private List<AbstractSequenceFeature> targets;
    private List<AbstractSequenceFeature> hunters;
    private List<TranskriptInteraction> interactions;
    private int lengthSwitch = Config.getInt("intarnaLengthSwitch");
    private boolean adjustLengthSwitch = Config.getBoolean("intarnaAdjustLengthSwitch");
    private int seedLength = Config.getInt("intarnaSeedLength");
    private int seedMM = Config.getInt("intarnaSeedMM");
    private boolean preserveOutput = Config.getBoolean("intarnaPreserveOutput");
    private String plus = String.valueOf(Config.getChar("intarnaStrandBracket")) + "+" + Config.getChar("intarnaStrandBracket");
    private String minus = String.valueOf(Config.getChar("intarnaStrandBracket")) + "-" + Config.getChar("intarnaStrandBracket");

    public IntarnaScanner(Genome genome, List<AbstractSequenceFeature> targets, List<AbstractSequenceFeature> hunters) {
        this.genome = genome;
        this.targets = targets;
        this.hunters = hunters;
        if (!this.preserveOutput) {
            this.tmpOutShort.deleteOnExit();
            this.tmpOutLong.deleteOnExit();
        }
        this.interactions = new LinkedList<TranskriptInteraction>();
    }

    public void scan() throws Exception {
        int minTargetLength = Integer.MAX_VALUE;
        for (AbstractSequenceFeature sf : this.targets) {
            minTargetLength = Math.min(minTargetLength, sf.getLength());
        }
        if (this.adjustLengthSwitch) {
            this.lengthSwitch = Math.min(this.lengthSwitch, minTargetLength);
        }
        System.out.println("intaRNALengthSwitch set to " + this.lengthSwitch);
        LinkedList<AbstractSequenceFeature> shortHunters = new LinkedList<AbstractSequenceFeature>();
        LinkedList<AbstractSequenceFeature> longHunters = new LinkedList<AbstractSequenceFeature>();
        for (AbstractSequenceFeature hunter : this.hunters) {
            if (hunter.getLength() >= this.lengthSwitch) {
                longHunters.add(hunter);
                continue;
            }
            shortHunters.add(hunter);
        }
        LinkedList<FASTAEntry<Object>> fastas = new LinkedList<FASTAEntry>();
        for (AbstractSequenceFeature target : this.targets) {
            if (target.getLength() < this.lengthSwitch) {
                System.out.println("target " + target.getID() + "dropped: too short");
                continue;
            }
            if (target.getStrand() == '+') {
                fastas.add(new FASTAEntry<DNASequence>(target.getID(), this.genome.getSequence().getSubsequence(target.getStart(), target.getEnd())));
                continue;
            }
            if (target.getStrand() == '-') {
                fastas.add(new FASTAEntry<DNASequence>(target.getID(), SequenceTools.reverseComplementDNA(this.genome.getSequence().getSubsequence(target.getStart(), target.getEnd()))));
                continue;
            }
            fastas.add(new FASTAEntry<DNASequence>(String.valueOf(target.getID()) + " " + this.plus, this.genome.getSequence().getSubsequence(target.getStart(), target.getEnd())));
            fastas.add(new FASTAEntry<DNASequence>(String.valueOf(target.getID()) + " " + this.minus, SequenceTools.reverseComplementDNA(this.genome.getSequence().getSubsequence(target.getStart(), target.getEnd()))));
        }
        BufferedWriter faWriter = new BufferedWriter(new FileWriter(this.tmpFastaT));
        FASTAWriter.write(faWriter, fastas);
        faWriter.close();
        fastas = new LinkedList();
        for (AbstractSequenceFeature hunter : shortHunters) {
            if (hunter.getStrand() == '+') {
                fastas.add(new FASTAEntry<DNASequence>(hunter.getID(), this.genome.getSequence().getSubsequence(hunter.getStart(), hunter.getEnd())));
                continue;
            }
            if (hunter.getStrand() == '-') {
                fastas.add(new FASTAEntry<DNASequence>(hunter.getID(), SequenceTools.reverseComplementDNA(this.genome.getSequence().getSubsequence(hunter.getStart(), hunter.getEnd()))));
                continue;
            }
            fastas.add(new FASTAEntry<DNASequence>(String.valueOf(hunter.getID()) + " " + this.plus, this.genome.getSequence().getSubsequence(hunter.getStart(), hunter.getEnd())));
            fastas.add(new FASTAEntry<DNASequence>(String.valueOf(hunter.getID()) + " " + this.minus, SequenceTools.reverseComplementDNA(this.genome.getSequence().getSubsequence(hunter.getStart(), hunter.getEnd()))));
        }
        faWriter = new BufferedWriter(new FileWriter(this.tmpFastaHshort));
        FASTAWriter.write(faWriter, fastas);
        faWriter.close();
        fastas = new LinkedList();
        for (AbstractSequenceFeature hunter : longHunters) {
            if (hunter.getStrand() == '+') {
                fastas.add(new FASTAEntry<DNASequence>(hunter.getID(), this.genome.getSequence().getSubsequence(hunter.getStart(), hunter.getEnd())));
                continue;
            }
            if (hunter.getStrand() == '-') {
                fastas.add(new FASTAEntry<DNASequence>(hunter.getID(), SequenceTools.reverseComplementDNA(this.genome.getSequence().getSubsequence(hunter.getStart(), hunter.getEnd()))));
                continue;
            }
            fastas.add(new FASTAEntry<DNASequence>(String.valueOf(hunter.getID()) + " " + this.plus, this.genome.getSequence().getSubsequence(hunter.getStart(), hunter.getEnd())));
            fastas.add(new FASTAEntry<DNASequence>(String.valueOf(hunter.getID()) + " " + this.minus, SequenceTools.reverseComplementDNA(this.genome.getSequence().getSubsequence(hunter.getStart(), hunter.getEnd()))));
        }
        faWriter = new BufferedWriter(new FileWriter(this.tmpFastaHlong));
        FASTAWriter.write(faWriter, fastas);
        faWriter.close();
        ProcessBuilder intarnaPB = new ProcessBuilder(String.valueOf(this.intarnaPath.getAbsolutePath()) + "/bin/IntaRNA", "-U", "-P", "-o", "-w", Integer.toString(this.lengthSwitch), "-p", Integer.toString(this.seedLength), "-u", Integer.toString(this.seedMM), "-m", this.tmpFastaHlong.getAbsolutePath(), "-t", this.tmpFastaT.getAbsolutePath());
        Process intarnaPlong = intarnaPB.start();
        ProcessStreamHandler intarnaHandlerLong = new ProcessStreamHandler(intarnaPlong.getInputStream(), this.tmpOutLong);
        intarnaHandlerLong.start();
        ErrorStreamDumper dumper1 = new ErrorStreamDumper(intarnaPlong.getErrorStream());
        dumper1.start();
        if (Main.numCPUs < 2) {
            intarnaPlong.waitFor();
            intarnaHandlerLong.join();
            dumper1.join();
        }
        intarnaPB = new ProcessBuilder(String.valueOf(this.intarnaPath.getAbsolutePath()) + "/bin/IntaRNA", "-U", "-P", "-o", "-p", Integer.toString(this.seedLength), "-u", Integer.toString(this.seedMM), "-m", this.tmpFastaHshort.getAbsolutePath(), "-t", this.tmpFastaT.getAbsolutePath());
        Process intarnaPshort = intarnaPB.start();
        ProcessStreamHandler intarnaHandlerShort = new ProcessStreamHandler(intarnaPshort.getInputStream(), this.tmpOutShort);
        intarnaHandlerShort.start();
        ErrorStreamDumper dumper2 = new ErrorStreamDumper(intarnaPshort.getErrorStream());
        dumper2.start();
        if (Main.numCPUs >= 2) {
            intarnaPlong.waitFor();
            intarnaHandlerLong.join();
            dumper1.join();
        }
        intarnaPshort.waitFor();
        intarnaHandlerShort.join();
        dumper2.join();
        IntaRNAParser parser = new IntaRNAParser(this.tmpOutShort.getAbsolutePath(), this.hunters, this.targets);
        parser.parseAndAnnotate();
        this.interactions.addAll(parser.getInteractions());
        parser = new IntaRNAParser(this.tmpOutLong.getAbsolutePath(), this.hunters, this.targets);
        parser.parseAndAnnotate();
        this.interactions.addAll(parser.getInteractions());
    }

    public List<TranskriptInteraction> getInteractions() {
        return this.interactions;
    }
}

