/*
 * Decompiled with CFR 0.152.
 */
package rfam;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;
import rfam.RfamTest;

public class RfamTestParser {
    public static List<RfamTest> parseRfamTests(String filename) throws Exception {
        LinkedList<RfamTest> res = new LinkedList<RfamTest>();
        BufferedReader r = new BufferedReader(new FileReader(filename));
        String line = r.readLine();
        while (line != null) {
            String[] lineFields = (line = line.trim()).split("[\\s]+");
            if (lineFields.length != 7) {
                System.err.println("Problem with line: " + line);
            } else {
                char strand;
                String id = lineFields[0];
                int start = Integer.parseInt(lineFields[2]);
                int end = Integer.parseInt(lineFields[3]);
                if (end < start) {
                    strand = '-';
                    int tmp = start;
                    start = end;
                    end = tmp;
                } else {
                    strand = '+';
                }
                res.add(new RfamTest(id, start, end, strand));
            }
            line = r.readLine();
        }
        return res;
    }

    public static List<RfamTest> parseRfamTestsNew(String filename) throws Exception {
        LinkedList<RfamTest> res = new LinkedList<RfamTest>();
        BufferedReader r = new BufferedReader(new FileReader(filename));
        String line = r.readLine();
        while (line != null) {
            if ((line = line.trim()).length() != 0 && line.charAt(0) != '#') {
                String id = line.split("[\\s]")[8].split(";")[0].split("=")[1];
                int start = Integer.parseInt(line.split("[\\s]")[3]);
                int end = Integer.parseInt(line.split("[\\s]")[4]);
                char strand = line.split("[\\s]")[6].charAt(0);
                res.add(new RfamTest(id, start, end, strand));
            }
            line = r.readLine();
        }
        return res;
    }
}

