/* Produces graphs of empirical rejection probabilities for the Burr ACD
   Graph Burr ACD-DGP
   13.12.99
   j.g.
   removed redundand code for Joe-Revision 5.8.2003
*/

LIBRARY CML, co, PGRAPH;
#INCLUDE CML.EXT;
#INCLUDE CML.DEC;
#include highfreq.ext;
#include highfreq.dec;
#include tacd.dec;
#include tacd.src;
let artstart = {};
let ind_x    = {};
let mypower  = {};
let _allcases = {};
CMLSET;

#include svddeflt.ext;
#include svd_h.src;
#include dtyfcacd.src;
#INCLUDE testacd.src;

x=0.5| 0.2| 0.1| 0.05| 0.01; /* Theoretical quantiles */

GRAPHSET;
_ptek = "";
XTICS(0, 0.5, 0.1, 0);
_pdate = "";
_plegctl = {2 3.8 5.8 1.1};
_paxes = 1;
_plwidth = { 4, 4, 4, 4 };
_pframe = 0;
_plframe = 0;
_ptitlht=0.25;
_paxht=0.25;
_pnumht=0.2;

XLABEL("level of significance");
YLABEL("prob. of rejection");

/******************************* Generalized Gamma ACD Evaluation  ***************/
_plegctl = {2 3.8 5.8 2.6};
yTICS(0, 0.5, 0.1, 0);

loadm overdis_wbll;
loadm overdis_expo;
loadm d0000g1;
loadm h0000g1;
loadm d0000g3;
loadm h0000g3;
loadm d0000g2;
{y1a, y2a} =(empirical_rejection_prob_2001(D0000g1,0));
{y1b, y2b} =(empirical_rejection_prob_2001(h0000g1,0));
{y1c, y2c} =(empirical_rejection_prob_2001(D0000g3,0));
{y1d, y2d} =(empirical_rejection_prob_2001(h0000g3,0));
{y1e, y2e} =(empirical_rejection_prob_2001(d0000g2,0));
_plegctl = {2 3.3 2 3.1};
_plegstr = "D-test, opt. kernel\0H-test, opt. kernel\0D-test, Gamma kernel
\0H-test, Gamma kernel\0D-test log residiuals, opt. kernel";
yTICS(0, 1, 0.1, 0);
TITLE("\201Size, estimated model: \l\201 G. Gamma ACD");
_ptek = "";
graphprt("-CF=g_gn.eps -C=1 -W=10");
XY(x,y1a~y1b~y1c~y1d~y1e);
_plegctl = {2 3.3 4.2 1.2};
TITLE("\201Size, estimated model:\l\201\ G. Gamma ACD (bootstrap)");
yTICS(0, 0.5, 0.1, 0);
_ptek = "";
graphprt("-CF=g_g.eps -C=1 -W=10");
_plegstr = "D-test, opt. kernel\0H-test, opt. kernel\0D-test, Gamma kernel
\0H-test, Gamma kernel\0D-test log residuals, opt. kernel";
XY(x,y2a~y2b~y2c~y2d~y2e);
graphprt("-CF=temp.eps -C=1 -W=10");
_plegctl = {2 3.8 5.8 1.2};

/******************************* Burr ACD Evaluation  ***************/
_plegctl = {2 3.8 5.8 2.6};
loadm d0000b1;
loadm h0000b1;
loadm d0000b3;
loadm h0000b3;
loadm d0000b2;
{y1a, y2a} =(empirical_rejection_prob_2001(D0000b1,0));
{y1b, y2b} =(empirical_rejection_prob_2001(h0000b1,0));
{y1c, y2c} =(empirical_rejection_prob_2001(D0000b3,0));
{y1d, y2d} =(empirical_rejection_prob_2001(h0000b3,0));
{y1e, y2e} =(empirical_rejection_prob_2001(d0000b2,0));

_plegstr = "D-test, opt. kernel\0H-test, opt. kernel\0D-test, Gamma kernel
\0H-test, Gamma kernel\0D-test log residuals, opt. kernel";
yTICS(0, 1, 0.1, 0);
TITLE("\201Power, estimated model: \l\201 Burr ACD");
graphprt("-CF=g_bn.eps -C=1 -W=10");
_plegctl = {2 3.3 2 3.5};
XY(x,y1a~y1b~y1c~y1d~y1e);

_plegctl = {2 3.3 1.2 4};
TITLE("\201Power, estimated model:\l\201\  Burr ACD (bootstrap)");
yTICS(0, 1, 0.1, 0);
graphprt("-CF=g_b.eps -C=1 -W=10");
XY(x,y2a~y2b~y2c~y2d~y2e);

graphprt("-CF=temp.eps -C=1 -W=10");

_plegctl = {2 3.8 5.8 1.2};


/******************************* Weibull ACD Evaluation  ***************/

loadm d0000w1;
loadm h0000w1;
loadm d0000w3;
loadm h0000w3;
loadm d0000w2;
{y1a, y2a} =(empirical_rejection_prob_2001(D0000w1,0));
{y1b, y2b} =(empirical_rejection_prob_2001(h0000w1,0));
{y1c, y2c} =(empirical_rejection_prob_2001(D0000w3,0));
{y1d, y2d} =(empirical_rejection_prob_2001(h0000w3,0));
{y1e, y2e} =(empirical_rejection_prob_2001(d0000w2,0));
{y1f, y2f} =(empirical_rejection_prob_2001(overdis_wbll,0));
_plegctl = {2 3.3 4.2 1.2};
_plegstr = "D-test, opt. kernel\0H-test, opt. kernel\0D-test, Gamma kernel
\0H-test, Gamma kernel\0D-test log residuals, opt. kernel\0Overdispersion test";
yTICS(0, 1, 0.1, 0);
TITLE("\201Power, estimated model: \l\201 Weibull ACD");
graphprt("-CF=g_wn.eps -C=1 -W=10");
XY(x,y1a~y1b~y1c~y1d~y1e~y1f);
TITLE("\201Power, estimated model:\l\201\  Weibull ACD (bootstrap)");
yTICS(0, 1, 0.1, 0);
graphprt("-CF=g_w.eps -C=1 -W=10");
XY(x,y2a~y2b~y2c~y2d~y2e~y1f);
graphprt("-CF=temp.eps -C=1 -W=10");
_plegctl = {2 3.8 5.8 1.2};

/******************************* Exponential ACD Evaluation  ***************/
_plegctl = {2 3.8 5.8 2.6};
loadm d0000e1;
loadm h0000e1;
loadm d0000e3;
loadm h0000e3;
loadm d0000e2;
_plegctl = {2 3.3 4.2 1.2};
{y1a, y2a} =(empirical_rejection_prob_2001(D0000e1,0));
{y1b, y2b} =(empirical_rejection_prob_2001(h0000e1,0));
{y1c, y2c} =(empirical_rejection_prob_2001(D0000e3,0));
{y1d, y2d} =(empirical_rejection_prob_2001(h0000e3,0));
{y1e, y2e} =(empirical_rejection_prob_2001(d0000e2,0));
{y1f, y2f} =(empirical_rejection_prob_2001(overdis_expo,0));
_plegstr = "D-test, opt. kernel\0H-test, opt. kernel\0D-test, Gamma kernel
\0H-test, Gamma kernel\0D-test log residuals, opt. kernel\0Overdispersion test";
yTICS(0, 1, 0.1, 0);
TITLE("\201Power, estimated model: \l\201 Exponential ACD");
graphprt("-CF=g_en.eps -C=1 -W=10");
XY(x,y1a~y1b~y1c~y1d~y1e~y1f);
TITLE("\201Power, estimated model:\l\201\  Exponential ACD (bootstrap)");
yTICS(0, 1, 0.1, 0);
graphprt("-CF=g_e.eps -C=1 -W=10");
XY(x,y2a~y2b~y2c~y2d~y2e~y1f);

