/* Exxon price power acd burr
*/

library cml, co, pgraph;
#include cml.ext;
#include co.ext
#include pgraph.ext;
CMLset;
coset;
graphset;

#include highfreq.dec;   /* This defines some necessary GLOBALS for j.g. procedures
                            copy this file in a directory executable for GAUSS (see below)*/
#include highfreq.ext;   /* ""                                                            */
#include svdDeflt.ext;
#INCLUDE gammafm.src;
#INCLUDE svd_h.src;
#include tacd.dec;
#include tacd.src;
#include dtyfcacd.src;   /* this includes file with necessary procedures (appended to this mail.)
                            You can copy dtyfcasc.src either in the local directory or
                            in a directory that I have specified in the GAUSS.CFG. Mine looks like:
                            src_path = $(GAUSSDIR)\src;$(GAUSSDIR)\examples;f:\jwg\forsch\highfreq\gaussprg
                         */


@============@
@ The following GLOBALS must be identical for all models tested to ensure comparability @

let number_of_bins = 20;                 /*number of bins for histogram plot of z changed from binwidth: j.g. 9.11.99 */
let lagorder = 50;                       /*Lags for autocorrelation plot:                      */
let conf_interval = 0.9;                 /*90 % confidence interval for histogram plot         */

@ end common section @
@============@

/*******************   TO BE ADAPTED FOR EACH DATA Set    *******************/

loadm datamatrix = baqp18;
OUTPUT file      = bplinacdb;
output reset; output on; screen on;
" ";
"Estimation first two third, etaluation first two third";

/****************************************************************************/

 ALLCASES = rows(datamatrix);

 P     =1;                                 /* lag length for lagged psi in ACD model (used as GLOBAL) */
 Q     =1;                                 /* lag length for lagged XI in  ACD model (used as GLOBAL) */

@
  This selects the last third of the data for forecasting purposes
  and also tests on the data
@

 XI    = datamatrix[1:round(allcases*(2/3))-1,9];
 FXI   = xi;

/* Globals needed for Forecasting j.g. November 4, 1999 */

                                           /* This uses the last third of durations for etaluation (XI is used as a GLOBAL)*/
 FCASES =rows(FXI);                        /* CASES is used as a GLOBAL in diebold_z                  */
 FMXI   =generate_lagged_xi(FXI,q,fcases); /* Generates a matrix of lagged durations (used as GLOBAL) */


/* Globals for Estimation  j.g. November 4, 1999 */

 CASES =rows(XI);                         /* CASES used for estimation                                            */
 MXI   =generate_lagged_xi(XI,q,cases);   /* Generates a matrix of lagged durations for estimation(used as GLOBAL) */
 MIND_P=genindx_with_cases(2,p,1,cases);  /* Generates an index vector that is only needed if analytical gradients
                                             are supplied for EACD, WACD and BACD, then used as global
                                          */

 EXO    = zeros(rows(xi),1);                             /* 0 = no exogenous regressors in PSI equation: estimation period */
 FEXO   = 0;                             /* same for forecasting period                                    */
 NOEXOG = 0;                             /* signifies number of exogenour regressors */
 data_input = {};                        /* I dont use this matrix to transfer data, I use Glokols (xi, mxi,)
                                            it may be needed, howeter for other models...*/
 let model_specifics = {};               /* I don't need any, you may.... */


 model            = "EACD";
 _cml_algorithm   = 3;
 _cml_linesearch  = 3;
 _cml_covpar      = 3;
 loadm model_parameters = ba_t_beta_eacd_o.fmt;
{parameter_input, f0 , g, varcov1, retcode} = CML(XI, 0, &li_ACD, model_parameters);

eacd_start       = parameter_input;
model            = "BAACD";
sub_aacd         = "BACD";
kappa            = 1.3;
sigma2           = 0.2;
model_parameters = parameter_input|kappa|sigma2;

_cml_algorithm   = 4;         /* CML settings */
_cml_linesearch  = 4;
/*_cml_gradstep  = 0.01;*/
_cml_gradmethod  = 1;
_use_cml         = 1;
_cml_covpar      = 2;
_cml_gradmethod  = 1;

/* This is for checking OPG vs. Hessian */
_cml_covpar      = 2;
_cml_maxiters    = 10000;
_uu_ = { 1e-06 1e250 };
_cml_Bounds = ones(rows(model_parameters),2).*_uu_;
_cml_maxtry = 100000;
{bplinacdb_par, bplinacdb_f0 , g, bplinacdb_varcov, bplinacdb_retcode} = CML(XI, 0, &li_AACD, model_parameters);
save bplinacdb_par;
save bplinacdb_f0;
bplinacdb_se = sqrt(diag(bplinacdb_varcov));
save bplinacdb_se;
save bplinacdb_retcode;
"Log-Likelihood";
 bplinacdb_f0*cases;
"BIC";
-2*bplinacdb_f0*cases+ln(cases)*rows(bplinacdb_par);
"Parameter estimates and standard errors";
bplinacdb_par~bplinacdb_se;
