@ --------------------------------------------------------
   Blueprint for the testing ACD models according
   to Fernandes and Grammig 1999.
   This tests AACD models and (end of file) writes out
   the residual vector (xi./psi) for each model in a file called
   aacdresi.dat!
   Based on file .prg
   Adapted for all models/stocks for Joe Revision
  --------------------------------------------------------@
new;

@ NON-EDIT AREA!!@
/****************/
YTICS(0,0.5,0.1,0);
s_p                      = 1;              /* Lag Order PSI */
s_q                      = 1;              /* Lag Order x_i */
let exog                 = {};             /* Names of exogenous variables                     */
EXO                      = 0;              /* 0 = no exogenous regressors in PSI equation: estimation period */
NOEXOG                   = 0;              /* signifies number of exogenour regressors         */
library cml, co, pgraph;
#include cml.ext;
#include co.ext
#include pgraph.ext;
CMLset;

coset;
graphset;
#include highfreq.dec;
#include highfreq.ext;
#include svdDeflt.ext;
#INCLUDE gammafm.src;
#INCLUDE svd_h.src;
#include tacd.dec;
#include tacd.src;
#include dtyfcacd.src;
#include testacd.src;
globalpsi = {};
MYPOWER                 = {}    ;     /* do not change this: used in bandwidht formula!!*/
let _allcases           = 1;          /* All cases used for nonparametric density       */
p = s_p; q              = s_q;
artstart                = 2;           /* Type of starting values for lagged variables   */
__output                = 1;           /* Not output produced by density procedure */
let var_buf = OMEGA;
iq = 1; DO WHILE (iq<=q);
 var_buf=var_buf|("ALPHA"$+FTOS(iq,"%*.*lf",1,0));
 iq=iq+1;
ENDO;
jp = 1; DO WHILE (jp<=p);
var_buf=var_buf|("BETA"$+FTOS(jp,"%*.*lf",1,0));
jp=jp+1;
ENDO;
IF (noexog>0); var_buf=var_buf|exog; ENDIF;
let _cml_smoothing = {};
outnames = "kernl"|"test"|"LOWTRC"|"UPPTRC"|"STAT"|"EXPECT"|"VAR"|"PVAL"|"STDN"|"USELOG";
let out        = {};
variable       =   var_buf;


/*************************************End Block Run****************************************************/
@ Main Program run:@
@==================@

"Exxon price";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  eaacdb_par;
loadm bpacd_ml_parameters   =  epacdb_par;
loadm bapacd_ml_parameters  =  eapacdb_par;
loadm baseacd_ml_parameters =  easeacdb_par;
loadm basacd_ml_parameters  =  easacdb_par;
loadm bacd_ml_parameters    =  elinacdb_par;
loadm bacd_ln_ml_parameters =  elogacdb_par;
loadm bEXACD_ml_parameters  =  eexacdb_par;
loadm blacd1_ml_parameters  =  elacd1b_par;
loadm bbcacd_ml_parameters  =  ebcacdb_par;
let stock_id             = "xonqp18";
loadm datamatrix         = Xonqp18;         /* Name of Data Matrix                             */
allcases                 = rows(datamatrix);
modsim                   = "xonpNpi";         /* Outputfile; max sechs Zeichen                   */
logfile                 = modsim $+ ".OUT";
output file             = ^logfile reset;
filnam                   = "xonpresi";       /* File where Residuals are written                */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,9];/* In sample */
mysample       = datamatrix[1:round(allcases*(2/3))-1,.];
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn~
mysample;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn
 index dura bid ask changeme volume vol_ask vol_bid sx numb_ask numb_bid number avg1 avg2 avg3 intensty;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);

/*************************************End Block Run****************************************************/

/*

"Boeing price";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  bpaacdb_par;
loadm bpacd_ml_parameters   =  bppacdb_par;
loadm bapacd_ml_parameters  =  bpapacdb_par;
loadm baseacd_ml_parameters =  bpaseacdb_par;
loadm basacd_ml_parameters  =  bpasacdb_par;
loadm bacd_ml_parameters    =  bplinacdb_par;
loadm bacd_ln_ml_parameters =  bplogacdb_par;
loadm bEXACD_ml_parameters  =  bpexacdb_par;
loadm blacd1_ml_parameters  =  bplacd1b_par;
loadm bbcacd_ml_parameters  =  bpbcacdb_par;
let stock_id             = "baqp18";
loadm datamatrix         = baqp18;         /* Name of Data Matrix                             */
allcases                 = rows(datamatrix);
modsim                   = "bapNpi";         /* Outputfile; max sechs Zeichen                   */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "bapresi";       /* File where Residuals are written                */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,9];/* In sample */
mysample       = datamatrix[1:round(allcases*(2/3))-1,.];
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn~
mysample;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn
 index dura bid ask changeme volume vol_ask vol_bid sx numb_ask numb_bid number avg1 avg2 avg3 intensty;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);

/*************************************End Block Run****************************************************/


"Disney price";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  dpaacdb_par;
loadm bpacd_ml_parameters   =  dppacdb_par;
loadm bapacd_ml_parameters  =  dpapacdb_par;
loadm baseacd_ml_parameters =  dpaseacdb_par;
loadm basacd_ml_parameters  =  dpasacdb_par;
loadm bacd_ml_parameters    =  dplinacdb_par;
loadm bacd_ln_ml_parameters =  dplogacdb_par;
loadm bEXACD_ml_parameters  =  dpexacdb_par;
loadm blacd1_ml_parameters  =  dplacd1b_par;
loadm bbcacd_ml_parameters  =  dpbcacdb_par;
let stock_id             = "disqp18";
loadm datamatrix         = disqp18;         /* Name of Data Matrix                             */
allcases                 = rows(datamatrix);
modsim                   = "dispNpi";         /* Outputfile; max sechs Zeichen                   */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "dispresi";       /* File where Residuals are written                */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,9];/* In sample */
mysample       = datamatrix[1:round(allcases*(2/3))-1,.];
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn~
mysample;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn
 index dura bid ask changeme volume vol_ask vol_bid sx numb_ask numb_bid number avg1 avg2 avg3 intensty;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);

/*************************************End Block Run****************************************************/

"Coke price";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  cpaacdb_par;
loadm bpacd_ml_parameters   =  cppacdb_par;
loadm bapacd_ml_parameters  =  cpapacdb_par;
loadm baseacd_ml_parameters =  cpaseacdb_par;
loadm basacd_ml_parameters  =  cpasacdb_par;
loadm bacd_ml_parameters    =  cplinacdb_par;
loadm bacd_ln_ml_parameters =  cplogacdb_par;
loadm bEXACD_ml_parameters  =  cpexacdb_par;
loadm blacd1_ml_parameters  =  cplacd1b_par;
loadm bbcacd_ml_parameters  =  cpbcacdb_par;
let stock_id             = "koqp18";
loadm datamatrix         = koqp18;         /* Name of Data Matrix                             */
allcases                 = rows(datamatrix);
modsim                   = "kopNpi";         /* Outputfile; max sechs Zeichen                   */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "kopresi";       /* File where Residuals are written                */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,9];/* In sample */
mysample       = datamatrix[1:round(allcases*(2/3))-1,.];
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn~
mysample;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn
 index dura bid ask changeme volume vol_ask vol_bid sx numb_ask numb_bid number avg1 avg2 avg3 intensty;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);


"Boeing volume";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  bvaacdb_par;
loadm bpacd_ml_parameters   =  bvpacdb_par;
loadm bapacd_ml_parameters  =  bvapacdb_par;
loadm baseacd_ml_parameters =  bvaseacdb_par;
loadm basacd_ml_parameters  =  bvasacdb_par;
loadm bacd_ml_parameters    =  bvlinacdb_par;
loadm bacd_ln_ml_parameters =  bvlogacdb_par;
loadm bEXACD_ml_parameters  =  bvexacdb_par;
loadm blacd1_ml_parameters  =  bvlacd1b_par;
loadm bbcacd_ml_parameters  =  bvbcacdb_par;
let stock_id             = "baqv25";
loadm datamatrix         = baqv25;         /* Name of Data Matrix */
allcases                 = rows(datamatrix);
modsim                   = "bavNpi";         /* Outputfile; max sechs Zeichen */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "bavresi";       /* File where Residuals are written */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,9];/* In sample */
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);

/*************************************End Block Run****************************************************/

"Coke volume";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  cvaacdb_par;
loadm bpacd_ml_parameters   =  cvpacdb_par;
loadm bapacd_ml_parameters  =  cvapacdb_par;
loadm baseacd_ml_parameters =  cvaseacdb_par;
loadm basacd_ml_parameters  =  cvasacdb_par;
loadm bacd_ml_parameters    =  cvlinacdb_par;
loadm bacd_ln_ml_parameters =  cvlogacdb_par;
loadm bEXACD_ml_parameters  =  cvexacdb_par;
loadm blacd1_ml_parameters  =  cvlacd1b_par;
loadm bbcacd_ml_parameters  =  cvbcacdb_par;
let stock_id             = "koqv25";
loadm datamatrix         = koqv25;         /* Name of Data Matrix */
allcases                 = rows(datamatrix);
modsim                   = "kovNpi";         /* Outputfile; max sechs Zeichen */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "kovresi";       /* File where Residuals are written */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,9];/* In sample */
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);

/*************************************End Block Run****************************************************/
"Disney volume";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  dvaacdb_par;
loadm bpacd_ml_parameters   =  dvpacdb_par;
loadm bapacd_ml_parameters  =  dvapacdb_par;
loadm baseacd_ml_parameters =  dvaseacdb_par;
loadm basacd_ml_parameters  =  dvasacdb_par;
loadm bacd_ml_parameters    =  dvlinacdb_par;
loadm bacd_ln_ml_parameters =  dvlogacdb_par;
loadm bEXACD_ml_parameters  =  dvexacdb_par;
loadm blacd1_ml_parameters  =  dvlacd1b_par;
loadm bbcacd_ml_parameters  =  dvbcacdb_par;
let stock_id             = "disqv25";
loadm datamatrix         = disqv25;         /* Name of Data Matrix */
allcases                 = rows(datamatrix);
modsim                   = "disvNpi";         /* Outputfile; max sechs Zeichen */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "disvresi";       /* File where Residuals are written */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,9];/* In sample */
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);

/*************************************End Block Run****************************************************/

"Exxon volume";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  evaacdb_par;
loadm bpacd_ml_parameters   =  evpacdb_par;
loadm bapacd_ml_parameters  =  evapacdb_par;
loadm baseacd_ml_parameters =  evaseacdb_par;
loadm basacd_ml_parameters  =  evasacdb_par;
loadm bacd_ml_parameters    =  evlinacdb_par;
loadm bacd_ln_ml_parameters =  evlogacdb_par;
loadm bEXACD_ml_parameters  =  evexacdb_par;
loadm blacd1_ml_parameters  =  evlacd1b_par;
loadm bbcacd_ml_parameters  =  evbcacdb_par;
let stock_id             = "xonqv25";
loadm datamatrix         = xonqv25;         /* Name of Data Matrix */
allcases                 = rows(datamatrix);
modsim                   = "xonvNpi";         /* Outputfile; max sechs Zeichen */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "xonvresi";       /* File where Residuals are written */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,9];/* In sample */
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);


/*************************************End Block Run****************************************************/

"Exxon trade";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  etaacdb_par;
loadm bpacd_ml_parameters   =  etpacdb_par;
loadm bapacd_ml_parameters  =  etapacdb_par;
loadm baseacd_ml_parameters =  etaseacdb_par;
loadm basacd_ml_parameters  =  etasacdb_par;
loadm bacd_ml_parameters    =  etlinacdb_par;
loadm bacd_ln_ml_parameters =  etlogacdb_par;
loadm bEXACD_ml_parameters  =  etexacdb_par;
loadm blacd1_ml_parameters  =  etlacd1b_par;
loadm bbcacd_ml_parameters  =  etbcacdb_par;
let stock_id             = "xon_t";
loadm datamatrix         = xon_t;         /* Name of Data Matrix */
allcases                 = rows(datamatrix);
modsim                   = "xontNpi";         /* Outputfile; max sechs Zeichen */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "xontresi";       /* File where Residuals are written */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,7];/* In sample */
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);

/*************************************End Block Run****************************************************/

"Boeing trade";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  btaacdb_par;
loadm bpacd_ml_parameters   =  btpacdb_par;
loadm bapacd_ml_parameters  =  btapacdb_par;
loadm baseacd_ml_parameters =  btaseacdb_par;
loadm basacd_ml_parameters  =  btasacdb_par;
loadm bacd_ml_parameters    =  btlinacdb_par;
loadm bacd_ln_ml_parameters =  btlogacdb_par;
loadm bEXACD_ml_parameters  =  btexacdb_par;
loadm blacd1_ml_parameters  =  btlacd1b_par;
loadm bbcacd_ml_parameters  =  btbcacdb_par;
let stock_id             = "ba_t";
loadm datamatrix         = ba_t;         /* Name of Data Matrix */
allcases                 = rows(datamatrix);
modsim                   = "ba_tNpi";         /* Outputfile; max sechs Zeichen */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "batresi";       /* File where Residuals are written */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,7];/* In sample */
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);

/*************************************End Block Run****************************************************/

"Coke trade";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  ctaacdb_par;
loadm bpacd_ml_parameters   =  ctpacdb_par;
loadm bapacd_ml_parameters  =  ctapacdb_par;
loadm baseacd_ml_parameters =  ctaseacdb_par;
loadm basacd_ml_parameters  =  ctasacdb_par;
loadm bacd_ml_parameters    =  ctlinacdb_par;
loadm bacd_ln_ml_parameters =  ctlogacdb_par;
loadm bEXACD_ml_parameters  =  ctexacdb_par;
loadm blacd1_ml_parameters  =  ctlacd1b_par;
loadm bbcacd_ml_parameters  =  ctbcacdb_par;
let stock_id             = "ko_t";
loadm datamatrix         = ko_t;         /* Name of Data Matrix */
allcases                 = rows(datamatrix);
modsim                   = "ko_tNpi";         /* Outputfile; max sechs Zeichen */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "kotresi";       /* File where Residuals are written */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,7];/* In sample */
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);


/*************************************End Block Run****************************************************/

"Disney trade";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  dtaacdb_par;
loadm bpacd_ml_parameters   =  dtpacdb_par;
loadm bapacd_ml_parameters  =  dtapacdb_par;
loadm baseacd_ml_parameters =  dtaseacdb_par;
loadm basacd_ml_parameters  =  dtasacdb_par;
loadm bacd_ml_parameters    =  dtlinacdb_par;
loadm bacd_ln_ml_parameters =  dtlogacdb_par;
loadm bEXACD_ml_parameters  =  dtexacdb_par;
loadm blacd1_ml_parameters  =  dtlacd1b_par;
loadm bbcacd_ml_parameters  =  dtbcacdb_par;
let stock_id             = "dis_t";
loadm datamatrix         = dis_t;         /* Name of Data Matrix */
allcases                 = rows(datamatrix);
modsim                   = "dis_tNpi";         /* Outputfile; max sechs Zeichen */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "distresi";       /* File where Residuals are written */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,7];/* In sample */
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);

/*************************************End Block Run****************************************************/

"IBM trade";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  itaacdb_par;
loadm bpacd_ml_parameters   =  itpacdb_par;
loadm bapacd_ml_parameters  =  itapacdb_par;
loadm baseacd_ml_parameters =  itaseacdb_par;
loadm basacd_ml_parameters  =  itasacdb_par;
loadm bacd_ml_parameters    =  itlinacdb_par;
loadm bacd_ln_ml_parameters =  itlogacdb_par;
loadm bEXACD_ml_parameters  =  itexacdb_par;
loadm blacd1_ml_parameters  =  itlacd1b_par;
loadm bbcacd_ml_parameters  =  itbcacdb_par;
let stock_id             = "ibm_t";
loadm datamatrix         = ibm_t;         /* Name of Data Matrix */
allcases                 = rows(datamatrix);
modsim                   = "ibm_tNpi";         /* Outputfile; max sechs Zeichen */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "ibmtresi";       /* File where Residuals are written */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,7];/* In sample */
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Write out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);

/*************************************End Block Run****************************************************/

"IBM volume";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  ivaacdb_par;
loadm bpacd_ml_parameters   =  ivpacdb_par;
loadm bapacd_ml_parameters  =  ivapacdb_par;
loadm baseacd_ml_parameters =  ivaseacdb_par;
loadm basacd_ml_parameters  =  ivasacdb_par;
loadm bacd_ml_parameters    =  ivlinacdb_par;
loadm bacd_ln_ml_parameters =  ivlogacdb_par;
loadm bEXACD_ml_parameters  =  ivexacdb_par;
loadm blacd1_ml_parameters  =  ivlacd1b_par;
loadm bbcacd_ml_parameters  =  ivbcacdb_par;
let stock_id             = "ibmqv25";
loadm datamatrix         = ibmqv25;         /* Name of Data Matrix */
allcases                 = rows(datamatrix);
modsim                   = "ibm_vNpi";         /* Outputfile; max sechs Zeichen */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "ibmvresi";       /* File where Residuals are wrivten */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,9];/* In sample */
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Wrive out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);


/*************************************End Block Run****************************************************/

"IBM price";
@ Change this for each model             @
@****************************************@
loadm baacd_ml_parameters   =  iaacdb_par;
loadm bpacd_ml_parameters   =  ipacdb_par;
loadm bapacd_ml_parameters  =  iapacdb_par;
loadm baseacd_ml_parameters =  iaseacdb_par;
loadm basacd_ml_parameters  =  iasacdb_par;
loadm bacd_ml_parameters    =  ilinacdb_par;
loadm bacd_ln_ml_parameters =  ilogacdb_par;
loadm bEXACD_ml_parameters  =  iexacdb_par;
loadm blacd1_ml_parameters  =  ilacd1b_par;
loadm bbcacd_ml_parameters  =  ibcacdb_par;
let stock_id             = "ibmqp18";
loadm datamatrix         = ibmqp18;         /* Name of Data Matrix */
allcases                 = rows(datamatrix);
modsim                   = "ibm_vNpi";         /* Outputfile; max sechs Zeichen */
logfile                  = modsim $+ ".OUT";
output file              = ^logfile reset;
filnam                   = "ibmpresi";       /* File where Residuals are wripten */
@ end of changebale Area @
@========================@
XI             = datamatrix[1:round(allcases*(2/3))-1,9];/* In sample */
CASES          = rows(XI);                      /* CASES used for estimation                                             */
MXI            = generate_lagged_xi(XI,q,cases);/* Generates a matrix of lagged durations for estimation(used as GLOBAL) */

"*************************** standard ACD ***********";
model           = "BACD";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = BACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bacd = global_psi;
"***************************Log-ACD (1) ***********";
model           = "BLACD1";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = blacd1_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_lacd1 = global_psi;
"***************************Log ACD ***********";
model           = "BLACDN";
sub_aacd        = "NOT_NULL";
$model;
ML_parameters   = bacd_ln_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_blacdn = global_psi;
"***************************EXACD ***********";
model           = "BAACD";
sub_aacd        = "EXACD";
$model;
ML_parameters   = bEXACD_ml_parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_exacd = global_psi;
"*************************** Box Cox ACD ***********";
model           = "BAACD";
sub_aacd        = "BCACD";
$model;
ML_parameters   = BBCACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_bcacd= global_psi;
"*************************** Power ACD ***********";
model           = "BAACD";
sub_aacd        = "PACD";
$model;
ML_parameters   = BPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_pacd = global_psi;
"***************************Asymmetric standard ACD ***********";
model           = "BAACD";
sub_aacd        = "ASACD";
$model;
ML_parameters   = BASACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_asacd= global_psi;
"***************************Asymmetric log ACD ***********";
model           = "BAACD";
sub_aacd        = "ASEACD";
$model;
ML_parameters   = BASEACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aseacd = global_psi;
"***************************Asymmetric power ACD ***********";
model           = "BAACD";
sub_aacd        = "APACD";
$model;
ML_parameters   = BAPACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_apacd= global_psi;
"***************************Augmented ACD ***********";
model           = "BAACD";
sub_aacd        = "AACD";
$model;
ML_parameters   = BAACD_ML_Parameters;
MYPOWER         = 2/9;
outlogdurations = NP_Test_Duration_Model_2("NORMAL",ML_parameters,1,2,1,0);
global_psi_aacd = global_psi;
/* Wripe out the residuals for the different models */
 mat=
xi./global_psi_bcacd~
xi./global_psi_lacd1~
xi./global_psi_exacd~
xi./global_psi_aacd~
xi./global_psi_apacd~
xi./global_psi_pacd~
xi./global_psi_aseacd~
xi./global_psi_asacd~
xi./global_psi_bacd~
xi./global_psi_blacdn;
LET vnames = r_bcacd r_lacd1 r_exacd r_aacd r_apacd r_pacd r_aseacd r_asacd r_bacd r_blacdn;
CREATE fh= ^filnam WITH ^vnames,0,8;
w=WRITER(fh,mat);
fh=CLOSE(fh);

/*************************************End Block Run****************************************************/
*/
