/* IBM price Aacd burr
*/


library cml, co, pgraph;
#include cml.ext;
#include co.ext
#include pgraph.ext;
CMLset;
coset;
graphset;
#include highfreq.dec;
#include highfreq.ext;
#include svdDeflt.ext;
#INCLUDE gammafm.src;
#INCLUDE svd_h.src;
#include tacd.dec;
#include tacd.src;
#include dtyfcacd.src;

@============@
@ The following GLOBALS must be identical for all models tested to ensure comparability @

let number_of_bins = 20;                 /*number of bins for histogram plot of z changed from binwidth: j.g. 9.11.99 */
let lagorder = 50;                       /*Lags for autocorrelation plot:                      */
let conf_interval = 0.9;                 /*90 % confidence interval for histogram plot         */

@ end common section @
@============@

/*******************   TO BE ADAPTED FOR EACH DATA SET    *******************/

loadm datamatrix = ibmqp18;
OUTPUT file      = iaacdb;
output reset; output on; screen on;
" ";
"Estimation first two third, evaluation first two third";

/****************************************************************************/

 ALLCASES = rows(datamatrix);

 P     =1;                                 /* lag length for lagged psi in ACD model (used as GLOBAL) */
 Q     =1;                                 /* lag length for lagged XI in  ACD model (used as GLOBAL) */

@
  This selects the last third of the data for forecasting purposes
  and also tests on the data
@

 XI    = datamatrix[1:round(allcases*(2/3))-1,9];
 FXI   = xi;

/* Globals needed for Forecasting j.g. November 4, 1999 */

                                           /* This uses the last third of durations for evaluation (XI is used as a GLOBAL)*/
 FCASES =rows(FXI);                        /* CASES is used as a GLOBAL in diebold_z                  */
 FMXI   =generate_lagged_xi(FXI,q,fcases); /* Generates a matrix of lagged durations (used as GLOBAL) */


/* Globals for Estimation  j.g. November 4, 1999 */

 CASES =rows(XI);                         /* CASES used for estimation                                            */
 MXI   =generate_lagged_xi(XI,q,cases);   /* Generates a matrix of lagged durations for estimation(used as GLOBAL) */
 MIND_P=genindx_with_cases(2,p,1,cases);  /* Generates an index vector that is only needed if analytical gradients
                                             are supplied for EACD, WACD and BACD, then used as global
                                          */

 EXO    = 0;                             /* 0 = no exogenous regressors in PSI equation: estimation period */
 FEXO   = 0;                             /* same for forecasting period                                    */
 NOEXOG = 0;                             /* signifies number of exogenour regressors */
 data_input = {};                        /* I dont use this matrix to transfer data, I use Glokols (xi, mxi,)
                                            it may be needed, however for other models...*/
 let model_specifics = {};               /* I don't need any, you may.... */

 model            = "EACD";
 _cml_algorithm   = 3;
 _cml_linesearch  = 3;
 _cml_covpar      = 3;
 loadm model_parameters = ba_t_beta_eacd_o.fmt;
{parameter_input, f0 , g, varcov1, retcode} = CML(XI, 0, &li_ACD, model_parameters);

sub_aacd         = "AACD";
model            = "BAACD";
eacd_start       = parameter_input;
kappa            = 1.3;
sigma2           = 0.2;
/*b                = 0;
c                = 0;*/
lambda           = 1;
/*upsilon          = 1;*/

model_parameters   = model_parameters|kappa|sigma2|1|0.01|0|1;

/* this was used to converge!!!
   first BFGS until step length problems
   then shift to Newton*/
loadm model_parameters = ipacdb_par;
model_parameters = model_parameters|0.01|0|1;

let model_parameters = -0.33987639 0.38975674 0.96392473 1.2934989 0.45879341 0.000027911617 0.045143728 -0.11164968 
 0.32441235;

_cml_algorithm   = 3;         /* CML settings */
_cml_linesearch  = 3;
_cml_gradmethod  = 1;
_use_cml         = 1;
_cml_covpar      = 2;
/*_cml_gradmethod  = 1; !! this was used for convergence */

loadm model_parameters = iaacdb_par;
_cml_covpar   = 2;
_uu_ = { 1e-06 1e250 };
_cml_Bounds = ones(rows(model_parameters),2).*_uu_;
_cml_bounds[1,1] = -50;
_cml_bounds[8,1]= -0.9999;
_cml_bounds[8,2]= 0.9999;
_cml_maxtry = 100000;
_cml_maxiters = 0;

{iaacdb_par, iaacdb_f0 , g, iaacdb_varcov, iaacdb_retcode} = CML(XI, 0, &li_aacd, model_parameters);
save iaacdb_par;
save iaacdb_f0;
iaacdb_se = sqrt(diag(iaacdb_varcov));
save iaacdb_se;
save iaacdb_retcode;
save iaacdb_varcov;
