/**********************************************************************/
/* 
   Program:  	DChPrgs.prg	
  
   Date:        14.9.1999
   Time:
   Comments:    Loglikelihod function 
   Author(s):   M. Scheidler  
*/
/***********************************************************************/

/*  Clearing of Globals (Variable Names) */

clearg ord1ad,ord2ad,depad,indad,corr1ad,corr2ad,four1ad,four_anz,four_Per,fourtyp;
clearg _model,mnp_func,corr1_on,corr2_on,_IterKer;
clearg Zuf_Matr,angebote,marktno,_kernel; 
clearg rndstart, _ghkall;

#include my_mnp.prg;
#include my_mnl.prg;
#include my_gar.prg;
#include lke_mnp.prg;


/* Prozedur zum Aufbau der Utility-Funktion:*/

proc mkutil(attr,beta);
local r,ftmp,futil;
r = rows(attr);
ftmp  = attr * beta;
futil = (ftmp)' .* ones(r,r);
retp(futil);
endp; 


/* Prozedur zum Aufbau der Loglikelihood-Funktion fuer MNL und 
   mehrere O&DS ?  */

proc mkmnl(no,odno,pax,attr,fattr,beta);
local r,k,on,od,indx,act,pact,uact,nact,uti,count,nsp;
local fampl,fphas,ffreq,fact,sysbeta,nutzen,fourpart;

r = rows(attr);
nsp=cols(attr);
sysbeta=beta[1:nsp];
fampl=0;
fphas=0;
ffreq=0;
fourpart=0;
if four_anz > 0;
 fampl  =beta[nsp+1:nsp+four_anz];
 fphas  =beta[nsp+four_anz+1:nsp+2*four_anz];
 ffreq  =seqa(1,1,four_anz);
endif;
od=maxc(odno);
uti=zeros(r,1);
count=minc(odno); 
do until count > od;  
  indx  = packr(miss(seqa(1,1,r).* (odno .== count),0));
  act   = attr[indx,.];
  pact  = pax[indx,.] ;
  fact  = fattr[indx,.];
  uact = mkutil(act,sysbeta); 
  if four_anz > 0;
  if (fourtyp eq 1);
   fourpart = cos(fact*(2*pi*ffreq./Four_Per)'+fphas')*abs(fampl);
  else;
   fourpart =   sin(fact*(2*pi*ffreq./Four_Per)')*fampl  
             + cos(fact*(2*pi*ffreq./Four_Per)')*fphas;
  endif; 

  uact  = uact + fourpart';
  endif;
  nact  = no[indx];
  uti[indx] = mymnl(nact,uact) .* pact;                      
  count = count+1;
endo;
retp(uti);
endp;


/* Prozedur zum Aufbau der Loglikelihood-Funktion fuer MNP und 
   mehrere O&DS ?  */
proc mkmnp(no,odno,pax,attr,fattr,beta,sigvec,indpon);
local r,k,on,od,indx,act,pact,uact,nact,uti,count;
local ms,xx,xd,ix,vv,sigact,sidx,itdone,sigtmp,nr,nsact,nsbig,tv;
local fampl,fphas,ffreq,fact,sysbeta,nutzen,nsp,fourpart;
r = rows(attr);
nsp=cols(attr);
sysbeta=beta[1:nsp];
fampl=0;
fphas=0;
ffreq=0;
fourpart=0;
if four_anz > 0;
 fampl  =beta[nsp+1:nsp+four_anz];
 fphas  =beta[nsp+four_anz+1:nsp+2*four_anz];
 ffreq  =seqa(1,1,four_anz);
endif;
od    = maxc((odno)');
uti   = zeros(r,1);
itdone=0;
rndseed rndstart;
count=1; 
do until count > od;  
  indx    = packr(miss(seqa(1,1,r).* (odno .== count),0));
  act     = attr[indx,.];
  pact    = pax[indx,.] ;
  fact  = fattr[indx,.];
  uact = mkutil(act,sysbeta); 
  if four_anz > 0;
   if (fourtyp eq 1);
    fourpart = cos(fact*(2*pi*ffreq./Four_Per)'+fphas')*abs(fampl);
   else;
    fourpart =   sin(fact*(2*pi*ffreq./Four_Per)')*fampl  
               + cos(fact*(2*pi*ffreq./Four_Per)')*fphas;
   endif; 
   uact  = uact + (fourpart)';
  endif;
 /* "uact=";; uact; */ 
  nact    = no[indx];
  nr      = rows(nact);
  nsact   = (nr*(nr-1)/2);
  nsbig   = (nr*(nr+1)/2);
  sidx    = ((seqa(1,1,nsact))' + itdone)';
  sidx    = ((seqa(1,1,nsbig))' + itdone)';
  sigtmp  = sigvec[sidx];
  ms = miss(0,0)*ones(nr,1);
  xx = xpnd(seqa(1,1,nsbig)) ;
  xd = diagrv(xx,ms);
  ix = packr(vech(xd));
  vv = ones(nsbig,1);
/*  vv[ix] = (sigtmp); */
  vv = sigtmp;
  sigact = xpnd(vv);
  if indpon;  
    sigact    = eye(nr);
    uti[indx] = mymnp(nact,uact,sigact) .* pact;
  else;
    uti[indx] = mymnp(nact,uact,sigact) .* pact;
  endif;
/* itdone  = itdone + nsact; */
  itdone = itdone + nsbig;
                      
  count = count+1;
endo;
retp(uti);
endp; 


/* Prozedur zum Aufbau der Loglikelihood-Funktion fuer MNP und 
   mehrere O&DS ?  */
proc mklkemnp(no,odno,pax,attr,fattr,beta,sigvec,indpon);
local r,k,on,od,indx,act,pact,uact,nact,uti,count;
local ms,xx,xd,ix,vv,sigact,sidx,itdone,sigtmp,nr,nsact,nsbig,tv;
local fampl,fphas,ffreq,fact,sysbeta,nutzen,nsp,fourpart;
r = rows(attr);
nsp=cols(attr);
sysbeta=beta[1:nsp];
fampl=0;
fphas=0;
ffreq=0;
fourpart=0;
if four_anz > 0;
 fampl  =beta[nsp+1:nsp+four_anz];
 fphas  =beta[nsp+four_anz+1:nsp+2*four_anz];
 ffreq  =seqa(1,1,four_anz);
 if (fourtyp eq 1);
  fourpart = cos(fattr*(2*pi*ffreq./Four_Per)'+fphas')*abs(fampl);
 else;
  fourpart =   sin(fattr*(2*pi*ffreq./Four_Per)')*fampl  
             + cos(fattr*(2*pi*ffreq./Four_Per)')*fphas;
 endif; 
endif;
od    = maxc((odno)');
uti   = zeros(r,1);
itdone=0;
rndseed rndstart;
count=1; 
do until count > od;  
  indx    = packr(miss(seqa(1,1,r).* (odno .== count),0));
  act     = attr[indx,.];
  pact    = pax[indx,.] ;
  fact  = fattr[indx,.];
  uact    = mkutil(act,sysbeta)+ (fourpart)';
 /* "uact=";; uact; */ 
  nact    = no[indx];
  nr      = rows(nact);
  nsact   = (nr*(nr-1)/2);
  nsbig   = (nr*(nr+1)/2);
  sidx    = ((seqa(1,1,nsact))' + itdone)';
  sidx    = ((seqa(1,1,nsbig))' + itdone)';
  sigtmp  = sigvec[sidx];
  ms = miss(0,0)*ones(nr,1);
  xx = xpnd(seqa(1,1,nsbig)) ;
  xd = diagrv(xx,ms);
  ix = packr(vech(xd));
  vv = ones(nsbig,1);
/*  vv[ix] = (sigtmp); */
  vv = sigtmp;
  sigact = xpnd(vv);
  if indpon;  
    sigact    = eye(nr);
    uti[indx] = lkemnp(nact,uact,sigact) .* pact;
  else;
    uti[indx] = lkemnp(nact,uact,sigact) .* pact;
  endif;
/* itdone  = itdone + nsact; */
  itdone = itdone + nsbig;
                      
  count = count+1;
endo;
retp(uti);
endp; 


/* Prozedur zum Aufbau der Loglikelihood-Funktion fuer MNP und 
   mehrere O&DS ?  */
proc simlke(no,odno,pax,attr,beta,sigvec,indpon);
local r,k,on,od,indx,act,pact,uact,nact,uti,count;
local ms,xx,xd,ix,vv,sigact,sidx,itdone,sigtmp,nr,nsact,nsbig,tv;
r = rows(attr);
od    = maxc((odno)');
uti   = zeros(r,1);
itdone=0;
rndseed rndstart;
count=1; 
do until count > od;  
  indx    = packr(miss(seqa(1,1,r).* (odno .== count),0));
  act     = attr[indx,.];
  pact    = pax[indx,.] ;
  uact    = mkutil(act,beta);
 /* "uact=";; uact; */ 
  nact    = no[indx];
  nr      = rows(nact);
  nsact   = (nr*(nr-1)/2);
  nsbig   = (nr*(nr+1)/2);
  sidx    = ((seqa(1,1,nsact))' + itdone)';
  sidx    = ((seqa(1,1,nsbig))' + itdone)';
  sigtmp  = sigvec[sidx];
  ms = miss(0,0)*ones(nr,1);
  xx = xpnd(seqa(1,1,nsbig)) ;
  xd = diagrv(xx,ms);
  ix = packr(vech(xd));
  vv = ones(nsbig,1);
/*  vv[ix] = (sigtmp); */
  vv = sigtmp;
  sigact = xpnd(vv);
  if indpon;  
    sigact    = eye(nr);
    uti[indx] = exp(lkemnp(nact,uact,sigact));
  else;
    uti[indx] = exp(lkemnp(nact,uact,sigact));
  endif;
/* itdone  = itdone + nsact; */
  itdone = itdone + nsbig;
                      
  count = count+1;
endo;
retp(uti);
endp; 







/* Prozedur zur SImualtion fuer MNP und 
   mehrere O&DS ?  */
proc simmnp(no,odno,pax,attr,beta,sigvec,indpon);
local r,k,on,od,indx,act,pact,uact,nact,uti,count;
local ms,xx,xd,ix,vv,sigact,sidx,itdone,sigtmp,nr,nsact,nsbig,tv;
r = rows(attr);
od    = maxc((odno)');
uti   = zeros(r,1);
itdone=0;
rndseed rndstart;
count=1; 
do until count > od;  
  indx    = packr(miss(seqa(1,1,r).* (odno .== count),0));
  act     = attr[indx,.];
  pact    = pax[indx,.] ;
  uact    = mkutil(act,beta);
  nact    = no[indx];
  nr      = rows(nact);
  nsact   = (nr*(nr-1)/2);
  nsbig   = (nr*(nr+1)/2);
  sidx    = ((seqa(1,1,nsact))' + itdone)';
  sidx    = ((seqa(1,1,nsbig))' + itdone)';
  sigtmp  = sigvec[sidx];
  ms = miss(0,0)*ones(nr,1);
  xx = xpnd(seqa(1,1,nsbig)) ;
  xd = diagrv(xx,ms);
  ix = packr(vech(xd));
  vv = ones(nsbig,1);
  vv = sigtmp;
  sigact = xpnd(vv);
  if indpon;  
    sigact    = eye(nr);
    uti[indx] = exp(mymnp(nact,uact,sigact));
  else;
    uti[indx] = exp(mymnp(nact,uact,sigact));
  endif;
  itdone = itdone + nsbig;
                      
  count = count+1;
endo;
retp(uti);
endp; 

/* Prozedur zum Ermitteln der benoetigten Parameter und Konstanten
   fuer die MNP-Schaetzung  */
proc parcount(odno);
local od,npara,count,indx,nactm,r,ract;
od = maxc((odno)');
r = rows(odno);
npara=0;
count=1; 
do until count > od;  
  indx    = packr(miss(seqa(1,1,r).* (odno .== count),0));
  ract    = rows(indx);
/*  nactm   = (ract * (ract-1) /2); */
  nactm   = (ract * (ract+1) /2); 
  npara   = npara + nactm;
  count   = count+1;
endo;
retp(npara);
endp; 

/* Prozedur zum Berechnen der VK-Matrix aus dem funktionalen Zusammenhang mit den
   Eigenschaften der Alternativen fr VIELE Maerkte  */
proc funkc_od(atcor1,atcor2,beta,nobeta,odno,no);
local od,count,indx,r,ract,sigvec,aatcor1,aatcor2,noelem;
od = maxc((odno)');
r = rows(odno);
noelem=parcount(odno);
sigvec=0;
count=1; 
do until count > od;  
  indx    = packr(miss(seqa(1,1,r).* (odno .== count),0));
  aatcor1 = atcor1[indx,.];
  aatcor2 = atcor2[indx,.];
  sigvec  = sigvec|funkcorr(aatcor1,aatcor2,beta,nobeta);
  count   = count+1;
endo;
retp(sigvec[2:noelem+1]);
endp;

/* Prozedur zum Berechnen der VK-Matrix aud dem funktionalen Zusammenhang mit den
   Eigenschaften der Alternativen fr einen Markt  */
proc funkcorr(atcor1,atcor2,beta,nobeta);
  local mvdiff1,mvdiff2,tmp1,sigvec,nopara1,nopara2;
  local eigen,t1,t2,diff,count,k,noelem;
  local sum1,sum2,sum3,quaddiff,zerovec,darkvec;
  k       = rows(atcor1);
  noelem  = k*(k+1)/2;
/*noelem  = k*(k-1)/2;*/
  sigvec  = zeros(noelem,1);
  tmp1    = ones(k,k);
  sum1=0;
  sum2=0;
  nopara1=0;
  nopara2=0;
  if (corr1_on == 1);
    nopara1 = cols(atcor1);
    mvdiff1 = zeros(noelem,nopara1);
    count=1; 
    do until count > nopara1;  
      eigen=atcor1[.,count];
      t1= tmp1   .* eigen;
      t2= eigen' .* tmp1 ;
/* alt:       diff=diagrv((t1-t2),miss(0,0)*ones(k,1));   */
/* neu: */ 
      diff=(t1-t2); 
      mvdiff1[.,count]=vech(diff);
      count=count+1;
    endo;
    if (_model eq 31 or _model eq 32);
      if (_model eq 31 );
        sum1=abs(mvdiff1)*beta[nobeta+1:nobeta+nopara1];
      else;
        sum1=abs(mvdiff1)*beta[nobeta+1];
      endif;
    elseif _model eq 30 or _model eq 35 or _model eq 61;
      quaddiff=(mvdiff1^2).*(1/(2*beta[nobeta+nopara1+1:nobeta+2*nopara1]^2)');
      sum1=exp(-quaddiff)*beta[nobeta+1:nobeta+nopara1];
    elseif _model eq 60;
    
      quaddiff=(mvdiff1^2).*(1/(2*beta[nobeta+1+nopara1+1:nobeta+1+2*nopara1]^2)');
      sum1=exp(-quaddiff)*beta[nobeta+1+1:nobeta+1+nopara1];
    else; 
    "XXXXXXXXXX"; stop;
    endif;

  endif;

  if (corr2_on == 1);
    nopara2 = cols(atcor2);
    mvdiff2 = zeros(noelem,nopara2);
    count=1; 
    do until count > nopara2;  
      eigen=atcor2[.,count];
      t1= tmp1   .* eigen;
      t2= eigen' .* tmp1 ;
/*      diff=diagrv(abs(t1-t2),miss(0,0)*ones(k,1));  */
      if (_model eq 31 or _model eq 32);
        diff=t1-t2;
      elseif (_model eq 30 or _model eq 35);
        diff=(t1.==t2);
      endif;
      mvdiff2[.,count]=vech(diff);
      count=count+1;
    endo;
    if (_model eq 31 or _model eq 32);
      if (_model==31);
        sum2=mvdiff2*beta[nobeta+nopara1+1:nobeta+nopara1+nopara2];      
      else;
        sum2=(mvdiff1.*mvdiff2)*beta[nobeta+nopara1+1:nobeta+nopara1+nopara2];
      endif;
    elseif _model eq 30 or _model eq 35 or _model eq 61;
      sum2=mvdiff2 * beta[nobeta+2*nopara1+1:nobeta+2*nopara1+nopara2];
    elseif _model eq 60;
      
      sum2=mvdiff2 * beta[nobeta+1+2*nopara1+1:nobeta+1+2*nopara1+nopara2];
    else; 
    "XXXXXXXXXX"; stop;
    endif;
  endif;
  sigvec= sum1 + sum2;
  if (_model eq 31 or _model eq 32);
    sum3=beta[nobeta+nopara1+nopara2+1] ;
    sigvec=sigvec+sum3;  
    if (mnp_func==1);
      sigvec=arctan(sigvec)/1.5708;
    endif;
    sigvec=vech(diagrv(xpnd(sigvec),ones(k,1))); 
  elseif (_model == 35);
    zerovec=zeros(k,1);
    darkvec=ones(k,k);
    darkvec=diagrv(darkvec,zerovec);
    sigvec=sigvec.*vech(darkvec)+vech(eye(k));
  elseif (_model == 60);
    sigvec=sigvec+vech(eye(k))*beta[nobeta+1];
  else;
    sigvec=sigvec+vech(eye(k));
  endif; 
  retp(sigvec);
endp;

proc sig2vech(odno,sigma);
local od,count,indx,r,sigvec,noelem,neuteil,odstart,odend;
od = maxc((odno)');
r = rows(odno);
noelem=parcount(odno);
sigvec=0;
count=1;
odstart=1; 
do until count > od;  
  indx    = packr(miss(seqa(1,1,r).* (odno .== count),0));
  odend   = odstart+rows(indx)-1;
  neuteil = vech(sigma[odstart:odend,odstart:odend]);
  sigvec  = sigvec|neuteil;
  count   = count+1;
  odstart = odend+1;
endo;
retp(sigvec[2:noelem+1]);
endp;



/* Prozedur zum Preaparieren der Loglikeklihood-Funktion 
   fuer den CML-Schaetzer */
proc li(beta,dta);
local no, odno, pax, attr, fattr, llf, param;
local k, sigvec, sigma, test, nobeta, indepon;
local atcor1, atcor2, nopara1, nopara2, noelem;
local reg_teil, unr_teil, T, Pp, Gewichte;
local fampl, fphas, ffreq, nsp, syspara, fourpart;
k=rows(dta);
odno   = dta[.,ord1ad];
no     = dta[.,ord2ad];
pax    = dta[.,depad];
attr   = dta[.,indad];
fattr  = dta[.,four1ad];
atcor1 = dta[.,corr1ad];
atcor2 = dta[.,corr2ad];
nobeta = cols(attr)+2*cols(fattr)*four_anz;
nopara1 =rows(corr1ad)*corr1_on;
nopara2 =rows(corr2ad)*corr2_on;
param  = beta[1:nobeta];
indepon=0;

if (_model le 25); /* Independent */
  if not (nobeta == rows(beta));
    "ERROR: Lnge des Initialwertevektors nicht o.k.";
    "Die Lnge sollte sein:" nobeta " und nicht: " rows(beta);
    retp(0);
  endif;
  indepon=1;
  noelem=parcount(odno);
  sigvec = ones(noelem,1);
elseif _model eq 27;
  if not (nobeta+1 == rows(beta));
    "ERROR: Lnge des Initialwertevektors nicht o.k.";
    "Die Lnge sollte sein:" nobeta " und nicht: " rows(beta);
    retp(0);
  endif;
  indepon=1;
  noelem=parcount(odno);
elseif (_model eq 31 or _model eq 32);
  if not (nobeta+nopara1+nopara2+1 == rows(beta));
    "ERROR: Lnge des Initialwertevektors nicht o.k.";
    "Die Lnge sollte sein:" nobeta+nopara1+nopara2+1 "und nicht:" rows(beta);
    retp(0);
  endif;
elseif (_model eq 30 or _model eq 35 or _model eq 61);
  if not (nobeta+nopara1*2+nopara2 == rows(beta));
    "ERROR: Lnge des Initialwertevektors nicht o.k.";
    "Die Lnge sollte sein:" nobeta+2*nopara1+nopara2 "und nicht:" rows(beta);
    retp(0);
  endif;
elseif (_model eq 40 or _model eq 50);
   if not (nobeta+nopara1+nopara2+2 == rows(beta));
    "ERROR: Lnge des Initialwertevektors nicht o.k.";
    "Die Lnge sollte sein:" nobeta+nopara1+nopara2+2 "und nicht:" rows(beta);
    retp(0);
  endif;
elseif (_model eq 51 or _model eq 45);
   if not (nobeta+nopara1+nopara2+1 == rows(beta));
    "ERROR: Lnge des Initialwertevektors nicht o.k.";
    "Die Lnge sollte sein:" nobeta+nopara1+nopara2+1 "und nicht:" rows(beta);
    retp(0);
  endif;
elseif (_model eq 60);
  if not (nobeta+nopara1*2+nopara2+1 == rows(beta));
    "ERROR: Lnge des Initialwertevektors nicht o.k.";
    "Die Lnge sollte sein:" nobeta+2*nopara1+nopara2+1 "und nicht:" rows(beta);
    retp(0);
  endif;
endif;

if ((_model ge 30 and _model lt 40) or _model eq 60 or _model eq 61) ; 
  sigvec = funkc_od(atcor1,atcor2,beta,nobeta,odno,no);
elseif (_model eq 50);
  gewichte = w_matrix(dta,beta,angebote,atcor1,atcor2,corr1_on,corr2_on,nobeta,mnp_func);
  T   	   = beta[nobeta+2]*eye(rows(gewichte));
  Pp  	   = eye(rows(gewichte)) - beta[nobeta+1]*gewichte;
  sigma    = (inv(Pp)*T)*(inv(Pp)*T)'+ eye(rows(gewichte));
  sigvec   = sig2vech(marktno,sigma);
elseif (_model eq 51);
  gewichte = w_matrix(dta,beta,angebote,atcor1,atcor2,corr1_on,corr2_on,nobeta,mnp_func);
  T   	   = eye(rows(gewichte));
  Pp  	   = eye(rows(gewichte)) - beta[nobeta+1]*gewichte;
  sigma    = (inv(Pp)*T)*(inv(Pp)*T)'+ eye(rows(gewichte));
  sigvec   = sig2vech(marktno,sigma);
endif;

fampl=0;
fphas=0;
ffreq=0;
fourpart=0;
nsp=cols(attr);
if four_anz > 0;
 fampl  =beta[nsp+1:nsp+four_anz];
 fphas  =beta[nsp+four_anz+1:nsp+2*four_anz];
 ffreq  =seqa(1,1,four_anz);
 if (fourtyp eq 1);
  fourpart = cos(fattr*(2*pi*ffreq./Four_Per)'+fphas')*abs(fampl);
 else;
  fourpart =   sin(fattr*(2*pi*ffreq./Four_Per)')*fampl  
             + cos(fattr*(2*pi*ffreq./Four_Per)')*fphas;
 endif; 
endif;
reg_teil = attr*param[1:nsp] + fourpart;


if     (_model eq 10);  		/* MNL */
  llf  = mkmnl(no,odno,pax,attr,fattr,param);
elseif (_model eq 11); 			/* MNL in GAR */
  unr_teil = zeros(k,1);
  llf      = ln(simulat(reg_teil,unr_teil,1,zuf_matr)).*pax;
elseif (_model == 22);
   unr_teil = eye(rows(dta));
   llf      = ln(simulat(reg_teil,unr_teil,_IterKer,zuf_matr)).*pax;
elseif (_model == 27);
   unr_teil = eye(rows(dta)) * beta[nobeta+1];
   llf      = ln(simulat(reg_teil,unr_teil,_IterKer,zuf_matr)).*pax;
elseif (_model eq 40);
/* "beta";beta;wait;
"angebote";angebote; wait;
"atcor1,atcor2";atcor1~atcor2;
"corr1_on,corr2_on";corr1_on~corr2_on;
"nobeta";nobeta;
"mnp_func";mnp_func; wait;
"angebote";angebote; wait;
"dta";dta; wait; */
 gewichte = w_matrix(dta,beta,angebote,atcor1,atcor2,corr1_on,corr2_on,nobeta,mnp_func);
/* "gewichte:";gewichte; */
  T   	   = beta[nobeta+2]*eye(rows(gewichte));
/* "T:";T;*/
  Pp  	   = eye(rows(gewichte))- beta[nobeta+1]*gewichte;
/* "Pp:";Pp; */
  unr_teil = T*inv(Pp);
  llf 	   = ln(simulat(reg_teil,unr_teil,_IterKer,zuf_matr)).*pax;
elseif (_model eq 45);
  gewichte = w_matrix(dta,beta,angebote,atcor1,atcor2,corr1_on,corr2_on,nobeta,mnp_func);
  T   	   = eye(rows(gewichte));
  Pp  	   = eye(rows(gewichte))- beta[nobeta+1]*gewichte;
  unr_teil = T*inv(Pp);
  llf 	   = ln(simulat(reg_teil,unr_teil,_IterKer,zuf_matr)).*pax;
elseif (_model eq 60 or _model eq 61);
  /* Sonderbehandlung ntig */
  llf  = mklkemnp(no,odno,pax,attr,fattr,param,sigvec,indepon);
else; 					/* other MNP */
  /* Sonderbehandlung ntig */
  llf  = mkmnp(no,odno,pax,attr,fattr,param,sigvec,indepon);
endif;



/*** for debugging only 
"Params von CML zur Berechnung der LLF";; beta;
"VK-Matrix";; xpnd(sigvec[1:15]);
"llf-Output zur bergabe an CML";;llf; wait;
***/
retp(llf);
endp;



proc pitimnp(marktno,nummer,pax);
local result, pointer, od, count, tmp, share, pointit;
local oditi, odpax, nofitin, nofpax,indx;
nofitin=rows(marktno);
nofpax=sumc(pax);
od=maxc(marktno);
result=zeros(od,nofitin);
share= pax2shar(marktno,pax);
pointer=1;
count=1; do until count > od;  
  indx  	= packr(miss(seqa(1,1,nofitin).* (marktno .== count),0));
  oditi	= rows(indx);      
  tmp	= pax[indx]';
  result[count,pointer:pointer+oditi-1]=tmp;
  pointer	= pointer+oditi;
  count	 	= count+1;
endo;
retp(result);
endp;

/*
proc pitireal(marktno,nummer,pax);
local result, pointer, nofitin,  nofpax, count, tmp;
nofitin=rows(marktno);
nofpax=sumc(pax);
result=zeros(nofpax,nofitin);
pointer=1;
count=1; do until count > nofitin;  
  tmp=ones(pax[count],1);
  result[pointer:pointer+pax-1,count]=tmp;
  pointer=pointer+pax;
  count = count+1;
endo;
retp(result);
endp;
*/

proc shar2pax(odno,echtpax,progshr);
/* odno    = Vektor von Nummern des Marktes, 
   echtpax = Vektor der echten Passagiere,
   progshr = Vektor der prognostizierten Shares  */ 
local r,od,count,indx,eact,pshr,pnum,ppax,odsize;
r =rows(echtpax);
od=maxc((odno)');
ppax=zeros(r,1);
count=1; do until count > od;  
  indx  = packr(miss(seqa(1,1,r).* (odno .== count),0));
  eact  = echtpax[indx];
  pshr  = progshr[indx];
  pnum  = rows(pshr);
  odsize= ones(1,pnum) * eact;
  ppax[indx] = odsize * pshr;    
  count = count+1;
endo;
retp(ppax);
endp;

proc pax2shar(odno,echtpax);
/* odno    = Vektor von Nummern des Marktes, 
   echtpax = Vektor der echten Passagiere,
   progshr = Vektor der prognostizierten Shares  */ 
local r,od,count,indx,eact,pshr,pnum,ppax,odsize;
r =rows(echtpax);
od=maxc((odno)');
pshr=zeros(r,1);
count=1; do until count > od;  
  indx  = packr(miss(seqa(1,1,r).* (odno .== count),0));
  eact  = echtpax[indx];
  pnum  = rows(eact);
  odsize= ones(1,pnum) * eact;
  pshr[indx] = eact/odsize;    
  count = count+1;
endo;
retp(pshr);
endp;

proc  prepdmnp(odno, no ,utility, 
                          nobeta, atcor1, atcor2, corrattr, 
                          corr1_on, corr2_on, mode);
local r, rv, cv, nd, od, indx, nact, count, share;
local nr, nsact, beta;
local nomod, nofod, uact, sigvech, indepon;
local amodel, idx, actpar, act_atc1, act_atc2, act_odno, test;

r             = rows(odno);
od          = maxc(odno);
count     = minc(odno); 
share   = zeros(r,1);
do until count > od;  
  indx     = packr(miss(seqa(1,1,r).* (odno .== count),0));
  if not (ismiss(indx) == 1); 
  uact   	= utility[indx,1];
  nact     	= no[indx];
  nr       	= rows(nact);
  nsact    	= (nr*(nr+1)/2);
  sigvech		=zeros(nsact,1);
  indepon  	= 0;
  if (mode==1 or nr==1); /* bei nur einem Itin passiert sowieso nichts */
    indepon	= 1;
  else;
    actpar	 	=  corrattr;
    act_atc1  	=  atcor1[indx,.];
    act_atc2  	=  atcor2[indx,.];  
    beta         	=  zeros(nobeta,1)|actpar; 
    sigvech    	=  funkcor2(act_atc1,act_atc2,beta, nobeta,corr1_on,corr2_on);
    test=xpnd(sigvech);
/*    test;
    wait; */
 endif;
  if (nr==1) ;
      share[indx] =1;  
  else;
       share[indx] = calcmnp(uact,sigvech);
  endif;
  endif;
  count 		 = count+1;  
endo;
retp(share);
endp;


/*
Prozedur zur Shareberechnung mit MNL fr einen Markt
*/

proc calcmnl(utility);
/* utility = Vektor der Nutzen der einzelnen Alternativen */ 
local d,util,utisum,share;

d   = rows(utility);
util      = exp(utility);  
utisum= ones(1,d) * util;
share=util/utisum;
retp(share);
endp;

/*
Prozedur zur Shareberechnung mit MNL fr mehrere Mrkte
*/

proc prepcmnl(odno,no,uti);
/* odno = Nummer des Marktes, no = Nummer des Itins im Markt, 
   uti  = Vektor der Nutzen der einzelnen Alternativen       */ 
local r,od,indx,uact,nact,count,share;
r =rows(uti);
share=zeros(r,1);
od=maxc((odno)');
count=1; do until count > od;  
  indx  = packr(miss(seqa(1,1,r).* (odno .== count),0));
/*  "indx:";indx;
  "uti:";uti; */
  uact  = uti[indx,1];
  nact  = no[indx];
  share[indx] = calcmnl(uact);
  count = count+1;
endo;
retp(share);
endp;


/*
Prozedur zur Shareberechnung mit MNP
*/
proc calcmnp(utility,sigvec);
/* utility = Vektor der Nutzen der einzelnen Alternativen
   sigvec  = Vektor von unbestimmten KV-Matrixeintrgen (unteres Dreieck) */
local d,rv,cv,nd,nk,test;
local wnorm,xx,xd,ix,vv,sigma,nalt,del,delomega,sk,omega,dv,scol,share;
local ms,vmin,prob,zz;
local wsigma, wdelom;
local sharesum;

d   = rows(utility);
rv  = rows(sigvec);
cv  = cols(sigvec);
nd  = d*(d-1)/2;
nk  = d*(d+1)/2;
/*"d= ";;d;
  "rv= ";;rv;
  "nk= ";;nk;
  "cv= ";;cv;
  wait;  */

if not ((cv == 1) and (rv == nk));
  errorlog "ERROR: Size of vector of covariance matrix elements not o.k.";
  retp(" ");
endif;  
/*
wnorm = sqrt(sigvec'sigvec);
sigvec = sigvec./wnorm;
utility = utility./sqrt(wnorm);   
*/
ms = miss(0,0)*ones(d,1);
xx = xpnd(seqa(1,1,nk)) ;
xd = diagrv(xx,ms);
ix = packr(vech(xd));
vv = ones(nk,1);
/* alt: vv[ix] = (sigvec); */
vv = sigvec;
sigma = xpnd(vv);
@ " ... so sieht sigma aus:";
  sigma; wait; @
test  = ones(1,nk) * sigvec;
if test==0;
   "COMMENT: Alle Kovarianzen sich gleich Null !";
endif;
if (d>4);
   call varput(1,"_qdfmth");
endif;

share= zeros(d,1);
nalt=1; do until nalt> d;
  del = -eye(d);
  del[.,nalt]= ones(d,1);
  dv  = del * utility;
  sk  = seqa(1,1,d); 
  sk[nalt] = miss(0,0); 
  sk = packr(sk);
  dv  = dv[sk,.];
  if not (test==0); 
    delomega = del*sigma*del';
  else; @ Einheitskovarianzmatrix @
    delomega = del*del';
  endif;
  zz=sqrt(diag(delomega)^2);
  delomega=diagrv(delomega,zz);
  delomega = submat(delomega,sk,sk);
  /******* How to treat Non-PD matrices *********/
  trap 1;
  wdelom=invpd(delomega);
  wsigma=invpd(sigma);
  trap 0;
  if scalerr(wdelom);
    "*** Die delomega - Matrix ist nicht positiv definit ! ***";
    "*** Scalerr(delomega) :"; scalerr(wdelom);
    "*** Scalerr(sigma)       :"; scalerr(wsigma);
    "*** delomega               :"; delomega;  wait;
    "*** sigma                     :"; sigma      ;  wait;

  endif;
  vmin= -10000*ones(d-1,1); 
  if (_ghkall==0);  
    rndseed rndstart;
  endif;
@ " ... wie sieht denn das dv aus ... :" dv; @ 
@ " ... und delomega ... :" delomega;        @
  prob= qdfn(dv,vmin,delomega);
  share[nalt]=prob;  
  nalt=nalt+1;
endo;
  /* Renormierung */
sharesum=ones(1,d)*share;
share=share./sharesum;

retp(share);
endp;



proc pax_od(odno,echtpax);
/* odno    = Vektor von Nummern des Marktes, 
   echtpax = Vektor der echten Passagiere,
   progshr = Vektor der prognostizierten Shares  */ 
local r,od,count,indx,eact,odpax,nofiti;
r =rows(echtpax);
od=maxc((odno)');
odpax=zeros(r,1);
count=1; do until count > od;  
  indx     = packr(miss(seqa(1,1,r).* (odno .== count),0));
  nofiti    = rows(indx);
  odpax[indx]  = sumc(echtpax[indx]).*ones(nofiti,1);
  count = count+1;
endo;
retp(odpax);
endp;



/* Prozedur zum Berechnen der VK-Matrix auf dem funktionalen Zusammenhang mit den
   Eigenschaften der Alternativen fr einen Markt (schlanke Variante) */
proc funkcor2(atcor1,atcor2,beta,nobeta,corr1_on,corr2_on);
  local mvdiff1,mvdiff2,tmp1,sigvec,nopara1,nopara2;
  local eigen,t1,t2,diff,count,k,noelem;
  local sum1,sum2,sum3,quaddiff,zerovec,darkvec;
  k       = rows(atcor1);
  noelem  = k*(k+1)/2;
  sigvec  = zeros(noelem,1);
  tmp1    = ones(k,k);
  sum1=0;
  sum2=0;
  nopara1=0;
  nopara2=0;
  if (corr1_on == 1);
    nopara1 = cols(atcor1);
    mvdiff1 = zeros(noelem,nopara1);
    count=1; 
    do until count > nopara1;  
      eigen=atcor1[.,count];
      t1= tmp1   .* eigen;
      t2= eigen' .* tmp1 ;
      diff=(t1-t2); 
      mvdiff1[.,count]=vech(diff);
      count=count+1;
    endo;
     quaddiff=(mvdiff1^2).*(1/(2*beta[nobeta+nopara1+1:nobeta+2*nopara1]^2)');
      sum1=exp(-quaddiff)*beta[nobeta+1:nobeta+nopara1];
  endif;

  if (corr2_on == 1);
    nopara2 = cols(atcor2);
    mvdiff2 = zeros(noelem,nopara2);
    count=1; 
    do until count > nopara2;  
      eigen=atcor2[.,count];
      t1= tmp1   .* eigen;
      t2= eigen' .* tmp1 ;
      diff=(t1.==t2);
      mvdiff2[.,count]=vech(diff);
      count=count+1;
    endo;
/*      "rows(beta)";;rows(beta);
        "nobeta";;nobeta;
        "nopara1";;nopara1;
        "nopara2";;nopara2;  */
      sum2=mvdiff2 * beta[nobeta+2*nopara1+1:nobeta+2*nopara1+nopara2];
  endif;

  sigvec= sum1 + sum2;
  if     (_model eq 60);
    sigvec=sigvec+vech(eye(k))*beta[nobeta+1];
  elseif (_model eq 35);
    zerovec=zeros(k,1);
    darkvec=ones(k,k);
    darkvec=diagrv(darkvec,zerovec);
    sigvec=sigvec.*vech(darkvec)+vech(eye(k));
  else;
    sigvec=sigvec+vech(eye(k));
  endif;
  retp(sigvec);
endp;
