
/**********************************************************************/
/***        	1.        Settings                            ***/
/**********************************************************************/

/*
   This gives settings for Nested Logits. Settings are calling main program
*/

/***************************************************************/
/***                    2. Initialize                   ***/
/***************************************************************/

/* Adresses computation */

 labels  =  getname(data);
 depad   =  indcv(depcen1,labels);
 indad   =  indcv(indcen1,labels);
 ord1ad  =  indcv(ordcen1,labels);
 ord2ad  =  indcv(ordcen2,labels);
 nestad  =  indcv(nestcen1,labels);

 
/* Read data */

 open fh = ^data for read; 
 dta     = readr(fh,maxzeil);
 
/* Show Base data */ 

/* "base data:";
 $(ordcen1~ordcen2~(indcen1')~depcen1); 
 dta[.,ord1ad]~dta[.,ord2ad]~dta[.,indad]~dta[.,depad];
 wait;
*/


nofl = rows(dta); 

/* Model control */

#include DNLUti_A.prg;

/* Prepare Nested Logit Level 1 */

k=rows(dta);
cl=cols(dta);
odno    = dta[.,ord1ad];
no        = dta[.,ord2ad];
nestno = dta[.,nestad];

tempno	=(100000*odno)+100*nestno+no;
dta2	=tempno~dta;
dta2	=sortc(dta2,1);
dta	=dta2[.,2:cols(dta2)];

odno     = dta[.,ord1ad];
no         = dta[.,ord2ad];
nestno  = dta[.,nestad];
tempno	=(100000*odno)+100*nestno+no;
tempmod = tempno-tempno%100;
tempmod2=tempmod[1]|tempmod[1:rows(tempmod)-1];
value   =(tempmod.==tempmod2);
count	=1;
laufno	=0;
laufod	=1;
nestno1=zeros(k,1);
no1=zeros(k,1);
do until count>k;
  if (value[count]==1);
    laufno = laufno+1;
  else;
    laufno=1;
    laufod=laufod+1;
  endif;
  nestno1[count] =laufod;
  no1[count]=laufno;
  count = count +1;
endo;

dta = dta~nestno1~no1;
nestn1ad=cl+1;
nestn2ad=cl+2;

/*
 $(ordcen1~ordcen2(indcen1')~depcen1); 
 dta[.,ord1ad]~dta[.,ord2ad]~dta[.,indad]~dta[.,depad]~dta[.,nestn1ad]~dta[.,nestn2ad];
 wait;
*/



/***************************************************************************/

/***************************************************************************/
/********************* 	3. Estimation - first step         *****************/
/***************************************************************************/

/* 	3.1 Call CML - Estimation first step	*/

 __title  = _modname $+ " auf " $+ modstr;
 {x,f0,g,h,retcode} = cml(dta,0,&li1,x0);

/* 	3.2 Standard deviations and tvalues 	*/

 s=sqrt(diag(h));
 hesse=h;
 tval = x./s ;
 param1=x;

/***************************************************************************/

/***************************************************************************/
/**************		4. Present results estimation      	************/
/***************************************************************************/

#include DChUti_C.prg;


/***************************************************************************/
/********************* 	5. Estimation - second step      *****************/
/***************************************************************************/

/* 	5.0 Prepare	*/

attr		=dta[.,indad];
pax		=dta[.,depad];
utility1	=mkutil(attr,param1)'; 
utility1      =utility1[.,1];
share1	=prepcmnl(nestno1,no1,utility1);

count=1;
anznest	= maxc(nestno1);
anzntyp   = maxc(nestno);
rnest	= rows(nestno1);
emu2	=zeros(anznest,1);
pax2	=zeros(anznest,1);
odno2	=zeros(anznest,1);
nesttyp2	=zeros(anznest,1);
nestno2	=zeros(anznest,1);
nofiti2	=zeros(anznest,1);
no2		=zeros(anznest,1);
laufno      =1;

do until count > anznest;
   indx    = packr(miss(seqa(1,1,rnest).* (nestno1 .== count),0)); 
   emu2[count]    = ln(sumc(utility1[indx])+0.0000001); 
   pax2[count]   = sumc(pax[indx]);
   odno2[count]   = maxc(odno[indx]);
   nestno2[count] = maxc(nestno1[indx]);
   nesttyp2[count] = maxc(nestno[indx]);
   nofiti2[count]   = rows(indx);
   if ((count gt 1) and (odno2[count] ne odno2[count-1]));
     laufno=1;
   endif;
   no2[count]=laufno; 

   laufno=laufno+1;
   count = count +1;
endo;

label = "EMU";
count=2;
if count le anzntyp;
xnest=zeros(anznest,anzntyp-1);
endif;
do until count > anzntyp;
 indx    = packr(miss(seqa(1,1,anznest).* (nesttyp2 .== count),0));
 xnest[indx,count-1] = ones(rows(indx),1);
  add   = "XNEST"$+ftos(count,"%*.*lf",1,0);
  label = label|add;
  count = count +1;
endo;

data2 = odno2~no2~pax2~emu2;
if (anzntyp gt 1);
data2 = odno2~no2~pax2~emu2~xnest;
endif;

/* 	5.1 Call CML - Estimation first step	*/

x0 = zeros(anzntyp+1-1,1);


 __title  = _modname $+ " auf " $+ modstr;
 {x,f0,g,h,retcode} = cml(data2,0,&li2,x0);

/* 	5.2 Standard deviations and tvalues 	*/

 s=sqrt(diag(h));
 hesse=h;
 tval = x./s ;
param2=x;




/***************************************************************************/
/**************		7. Simulation und Tests          	************/
/***************************************************************************/

attr2		=emu2~xnest;
utility2	=mkutil(attr2,param2)'; 
utility2      =utility2[.,1];
share2h	=prepcmnl(odno2,no2,utility2);

share2=zeros(rnest,1);

count=1;
do until count > anznest;
    indx    = packr(miss(seqa(1,1,rnest).* (nestno1 .== count),0));
    count2 = nestno2[count];
    share2[indx] = share2h[count2]*ones(rows(indx),1);
count=count+1;
endo;

share=share1.*share2;
sharemnp=share;

outdat	= dta~sharemnp;
paxmnp 	= shar2pax(odno,pax,sharemnp);
ergebnis	= odno~no~share~pax~sharemnp~paxmnp;
/*p_iti		= pitimnp(odno,no,pax); 
p_itimnp	= pitimnp(odno,no,paxmnp); */

loglik = sumc(ln(sharemnp).*pax);
f0=loglik/nofl;

/***************************************************************************/
/**************		6. present results of estimation lev  2    *******/
/***************************************************************************/


#include DChUti_C.prg;



#include DChUti_E.prg; /* Tests */


/************************** 	End    ************************************/

