/**********************************************************************/
/* 
   Program:  	DNLPrgs.prg	(von DChPrgs.prg)
   Author(s):   M. Scheidler  
*/
/***********************************************************************/

/*  Clearen of Globals (Variable Names) */

clearg ord1ad,ord2ad,depad,indad,nestad,nestn1ad,nestn2ad;
clearg _model;
clearg Zuf_Matr,angebote,marktno; 

clearg corr1ad,corr2ad,four1ad,four_anz,four_Per,fourtyp;
clearg mnp_func,corr1_on,corr2_on,_IterKer;
clearg _kernel; 
clearg rndstart, _ghkall;
clearg FOURCEN1, BSPEC_ON, BSPECIAL, BCORR_ON, CORRCEN1, CORRCEN2;                        

#include my_mnl.prg;

/* construct Utility-Function:*/

proc mkutil(attr,beta);
local r,ftmp,futil;
r = rows(attr);
ftmp  = attr * beta;
futil = (ftmp)' .* ones(r,r);
retp(futil);
endp; 


/* Prozedur zum Ermitteln der benoetigten Parameter und Konstanten
   fuer die MNP-Schaetzung  */
/* Prozedur to get the necessary parameters and constants for MNP estimation */

proc parcount(odno);
local od,npara,count,indx,nactm,r,ract;
od = maxc((odno)');
r = rows(odno);
npara=0;
count=1; 
do until count > od;  
  indx    = packr(miss(seqa(1,1,r).* (odno .== count),0));
  ract    = rows(indx);
/*  nactm   = (ract * (ract-1) /2); */
  nactm   = (ract * (ract+1) /2); 
  npara   = npara + nactm;
  count   = count+1;
endo;
retp(npara);
endp; 



/* Prozedur zum Aufbau der Loglikelihood-Funktion fuer MNL und 
   mehrere O&DS ?  */
/* Procedure to construct log likelihood for MNL and many O&D*/

proc mkmnl(no,odno,pax,attr,beta);
local r,k,on,od,indx,act,pact,uact,nact,uti,count,nsp;
local sysbeta,nutzen;

r = rows(attr);
nsp=cols(attr);
sysbeta=beta[1:nsp];
od=maxc(odno);
uti=zeros(r,1);
count=minc(odno); 
do until count > od;  
  indx  = packr(miss(seqa(1,1,r).* (odno .== count),0));
  act   = attr[indx,.];
  pact  = pax[indx,.] ;
  uact = mkutil(act,sysbeta); 

  uact  = uact ;
  nact  = no[indx];
  uti[indx] = mymnl(nact,uact) .* pact;                      
  count = count+1;
endo;
retp(uti);
endp;



/* Prozedur zum Preaparieren der Loglikeklihood-Funktion 
   fuer den CML-Schaetzer - Nested Logit Level 1*/

/* Procedure to prepare log likelihood funkction for CML estimator 
   - Nested Logit Level 1*/

proc li1(beta,dta);
local no, odno, pax, attr, fattr, llf, param;
local k, test, nobeta, indepon;
local noelem;
k=rows(dta);
odno   = dta[.,nestn1ad];
no     = dta[.,nestn2ad];
pax    = dta[.,depad];
attr   = dta[.,indad];
nobeta = cols(attr);
param  = beta[1:nobeta];
indepon=0;
if not (nobeta == rows(beta));
    "ERROR: Length of initial value vector not ok";
    "Length should be:" nobeta " and not: " rows(beta);
    retp(0);
endif;
indepon=1;  
llf  = mkmnl(no,odno,pax,attr,param);
retp(llf);
endp;

/* Prozedur zum Preaparieren der Loglikeklihood-Funktion 
   fuer den CML-Schaetzer - Nested Logit Level 2*/

/* Procedure to prepare log likelihood for CML estimation 
   - Nested Logit Level 2*/

proc li2(beta,dta);
local cl,k,odno,no,pax,attr,nobeta,llf;
k=rows(dta);
cl=cols(dta);
odno   = dta[.,1];
no     = dta[.,2];
pax    = dta[.,3];
attr    = dta[.,4:cl];
nobeta = cols(attr);
if not (nobeta == rows(beta));
    "ERROR: Lnge des Initialwertevektors nicht o.k.";
    "Die Lnge sollte sein:" nobeta " und nicht: " rows(beta);
    retp(0);
endif;
llf  = mkmnl(no,odno,pax,attr,beta);
retp(llf);
endp;



proc shar2pax(odno,echtpax,progshr);
/* odno    = Vektor von Nummern des Marktes, 
   echtpax = Vektor der echten Passagiere,
   progshr = Vektor der prognostizierten Shares  */ 
/* odno    = Vector with numbers of market
   echtpax = Vector passengers observed
   progshr = Vector forecasted shares  */ 

local r,od,count,indx,eact,pshr,pnum,ppax,odsize;
r =rows(echtpax);
od=maxc((odno)');
ppax=zeros(r,1);
count=1; do until count > od;  
  indx  = packr(miss(seqa(1,1,r).* (odno .== count),0));
  eact  = echtpax[indx];
  pshr  = progshr[indx];
  pnum  = rows(pshr);
  odsize= ones(1,pnum) * eact;
  ppax[indx] = odsize * pshr;    
  count = count+1;
endo;
retp(ppax);
endp;

proc pax2shar(odno,echtpax);
/* odno    = Vektor von Nummern des Marktes, 
   echtpax = Vektor der echten Passagiere,
   progshr = Vektor der prognostizierten Shares  */ 
local r,od,count,indx,eact,pshr,pnum,ppax,odsize;
r =rows(echtpax);
od=maxc((odno)');
pshr=zeros(r,1);
count=1; do until count > od;  
  indx  = packr(miss(seqa(1,1,r).* (odno .== count),0));
  eact  = echtpax[indx];
  pnum  = rows(eact);
  odsize= ones(1,pnum) * eact;
  pshr[indx] = eact/odsize;    
  count = count+1;
endo;
retp(pshr);
endp;

/*
Prozedur zur Shareberechnung mit MNL fr einen Markt
*/
/*
Procedure to compute market shares with MNL for single market
*/

proc calcmnl(utility);
/* utility = Vektor der Nutzen der einzelnen Alternativen */ 
/* utility = Vector of utilities for alternatives */ 

local d,util,utisum,share;

d   = rows(utility);
util      = exp(utility);  
utisum= ones(1,d) * util;
share=util/utisum;
retp(share);
endp;

/*
Prozedur zur Shareberechnung mit MNL fr mehrere Mrkte
*/
/*
procedure to compute market shares for many markets
*/

proc prepcmnl(odno,no,uti);
/* odno = Nummer des Marktes, no = Nummer des Itins im Markt, 
   uti  = Vektor der Nutzen der einzelnen Alternativen       */ 
/* odno = Number of Market, no = number of itineraries in market 
   uti  = Vektor of utilities for alternatives      */ 
local r,od,indx,uact,nact,count,share;
r =rows(uti);
share=zeros(r,1);
od=maxc((odno)');
count=1; do until count > od;  
  indx  = packr(miss(seqa(1,1,r).* (odno .== count),0));
/*  "indx:";indx;
  "uti:";uti; */
  uact  = uti[indx,1];
  nact  = no[indx];
  share[indx] = calcmnl(uact);
  count = count+1;
endo;
retp(share);
endp;


proc pax_od(odno,echtpax);
/* odno    = Vektor von Nummern des Marktes, 
   echtpax = Vektor der echten Passagiere,
   progshr = Vektor der prognostizierten Shares  */ 
/* odno    = Vector with numbers of market
   echtpax = Vector passengers observed
   progshr = Vector forecasted shares  */ 

local r,od,count,indx,eact,odpax,nofiti;
r =rows(echtpax);
od=maxc((odno)');
odpax=zeros(r,1);
count=1; do until count > od;  
  indx     = packr(miss(seqa(1,1,r).* (odno .== count),0));
  nofiti    = rows(indx);
  odpax[indx]  = sumc(echtpax[indx]).*ones(nofiti,1);
  count = count+1;
endo;
retp(odpax);
endp;

proc pitimnp(marktno,nummer,pax);
local result, pointer, od, count, tmp, share, pointit;
local oditi, odpax, nofitin, nofpax,indx;
nofitin=rows(marktno);
nofpax=sumc(pax);
od=maxc(marktno);
result=zeros(od,nofitin);
share= pax2shar(marktno,pax);
pointer=1;
count=1; do until count > od;  
  indx  	= packr(miss(seqa(1,1,nofitin).* (marktno .== count),0));
  oditi	= rows(indx);      
  tmp	= pax[indx]';
  result[count,pointer:pointer+oditi-1]=tmp;
  pointer	= pointer+oditi;
  count	 	= count+1;
endo;
retp(result);
endp;
