/**********************************************************************/
/* Program Namf: lke_mnp.prg
** Subject:      Multinomial Probit  estimation procedures
** Date:         24.9.99
** Time:
** Comments:    P-MNP mit Logit-Kernel
** Author(s):   M. Scheidler  
**
** Purpose:    Return the log likelihood of a multinomial probit process
**             (mit Logit Kernel).
**
** Format:     MYMNP(ycat,x,vcmat);
**
** Input     ycat   Nx1 vector of alternatives chosen for each observation
**
**             xl   NxK matrix, utility evaluation for each observation for
**                  each choice
**
**          vcmat
**               KxK symmetric, positive definite covariance
**            matrix of the K-variate normal density function.
**
** Output:    llf    Nx1 vector of the log likelihood.
**
**************************************************************/

/*=======================================================================*/


proc lkemnp(ycat,x,vcmat);
local xh, xl, mu;
local r,rndv,uti,sumuti,prob,sumprob,result;
local _range;
_range=5;

r	= rows(x);
xh	= ones(r,_IterKer) * _range;
xl	= -xh;
mu	= zeros(r,_IterKer);
rndv 	= rndtn(xh,xl,mu,vcmat);
/*   "rndv: ";rndv;
   "x   : ";x; */
uti	= exp(x[1,.] + rndv)';
sumuti 	= sumc(uti)';
prob	= (uti./sumuti)';
sumprob = (sumc(prob)/_IterKer);
sumprob = sumprob.*(sumprob .> 0) + .0000003.*(sumprob .<= 0);
result  = ln(sumprob);

retp(result);
endp;


