/**********************************************************************/
/* Program Namf: my_mnl.prg
** Subject:      Multinomial Logit Estimation Procedure
** Date:         12.12.1997
** Time:
** Comments:   
** Author(s):   M. Scheidler  */
/*********************************************************************/

/*==================================================================== 
Description: Input-Variables: 
   ycat is the category choice
   x is the matrix of utilities */
/*====================================================================*/
proc mymnl(ycat,x);
     local n, k, llf,  ych, prb, ex;
        n = rows(x);
        k = cols(x);                    @ number of alternatives @
        ycat = ycat - minc(ycat) + 1;   @ scales to first category unity @
 
        if (minc(ycat) < 1) or (maxc(ycat) > k);
          errorlog "ERROR: Either the categorical variable does not start at unity,
                           or the number of categories exceeds cols(x)";
        endif;
        ex = exp(x);
        prb = zeros(n,1);
        ych = 1; do until ych > k;
            prb = prb + ex[.,ych].*(ycat .== ych);
            ych = ych+1;
        endo;
        prb = prb./sumc(ex');       
        llf = ln(prb);
    retp(llf);      
endp;


      




