/**********************************************************************/
/* ProgramNamf:  my_mnp.prg
** Subject:      Multinomial Probit  estimation procedures
** Date:         12.12.1997
** Time:
** Comments:   
** Author(s):   
**
** Purpose:    Return the log likelihood of a multinomial probit process.
**
** Format:     MYMNP(ycat,x,vcmat);
**
** Input     ycat   Nx1 vector of alternatives chosen for each observation
**
**             xl   NxK matrix, utility evaluation for each observation for
**                  each choice
**
**          vcmat
**         1.   (K*(K-1)/2)x1 vector of unique elements in
**            the differenced covariance matrix.
**         2.    KxK symmetric, positive definite covariance
**            matrix of the K-variate normal density function.
**         3.    KxK Cholesky factor of the KxK covariance
**            matrix of the K-variate normal density function.
**         4.    Kx(r+1) matrix for the factor analytic case,
**            where covariance matrix has r factors.
**
**          _mnpsc    (Case 1) Scale for vcmat (Helps precision)
**                       0 - no scaling   1 - unit scale (default)
**          _mnpint   Integration algorithm:
**                       0 - default, 1 = cdfmvn, 2 = GHK 
**
**       MYMNP uses QDFN to evaluate the multivariate normal integral, and
**       thus the following globals are used - see QDFN for documentation.
**
**        _qdfmth   scalar, the choice of method.
**        _qdfrep   scalar, the number of replications.
**        _qdfrlz   scalar, the number of realizations.
**        _qdford   scalar, the order of the integration
**
**
** Output:    llf    Nx1 vector of the log likelihood.
**
**************************************************************/

/*=======================================================================*/
   external matrix _mnpsc, _mnpint;
       _cdford = 16;
       _cdftol = 1e-6;

/*   proc mymnp; endp;  */
/*=======================================================================*/
/*  Clearen of Globals (Variable Names) */
clearg _flag36,_flag71,_flag72,_flag73, _flag74;
_flag36=0;


   proc mymnp(ycat,x,vcmat);
   local n, k, llf, i, ych, del, v, vmin, dv, sk, omega, delomega, zz, prob,
        nk, nkk, w, ms, xx, xd, ix, indx, vv, sigma, scol, msg, rv,cv,
        wnorm, covmeth, covnorm, penalty, com;
   local temp, share, normsum, llfalt;
        clear covmeth, covnorm;
        n = rows(x);
        k = cols(x);                   @ number of coefficients @      
        nk = k*(k+1)/2  ;
        nkk = k*(k-1)/2;
        _flag73=0;
        _flag74=0;
        _flag36=_flag36+1;        
        if 1;
          if maxc(ycat)-minc(ycat)+1 > k;
             msg = "Number of categories exceeds cols(x)";
             goto errmsg;
          endif;
          rv = rows(vcmat);
          cv = cols(vcmat);
          if (rv == nkk) and (cv == 1);
             covmeth = 0;                              @ reduced form @
             covnorm = varget("_mnpsc");               @ unit norm @
          elseif (rv == k) and (cv == k);
             if (vcmat == vcmat');
                  covmeth = 1;                         @ full omega   @
             elseif (vech(diagrv(vcmat,zeros(k,1))) == 0);
                  covmeth = 2;                         @ chol(omega)   @
             else;
                  covmeth = 3;                         @ factor analytic @
             endif;
          elseif (rv == k) and (cv >= 2);
             covmeth = 3;                              @ factor analytic @
          else;
             msg = "Covariance matrix inconsistent";
             goto errmsg;
          endif;
          if (covmeth == 3);
             call varput(2,"_qdfmth");
          elseif (k > 4);
             call varput(1,"_qdfmth");
          else;
             call varput(0,"_qdfmth");
          endif;
          _flag71=covmeth;
          _flag72=covnorm;
        else;
          covmeth = _flag71;
          covnorm = _flag72;
        endif;
        ycat = ycat - minc(ycat) + 1;

    @ Assume vcmat is a nkkx1 vector of params @
    if (covmeth == 0);                         @ reduced form @
            if covnorm;                        @ unit norm @
              wnorm = sqrt(vcmat'vcmat);
              vcmat = vcmat./wnorm;
              x = x./sqrt(wnorm);              @ adjust upper bounds @
            endif;
            ms = miss(0,0)*ones(k,1);
            xx = xpnd(seqa(1,1,nk)) ;
            xd = diagrv(xx,ms);
            ix = packr(vech(xd));
            vv = zeros(nk,1);
            vv[ix] = (vcmat);
            sigma = xpnd(vv);
     elseif covmeth == 1;                      @ vcmat = omega @
            omega = vcmat;
     elseif covmeth == 2;                      @ vcmat = chol(omega) @
            omega = vcmat'vcmat;
     elseif covmeth == 3;                      @ vcmat =  d~b  @
            omega = vcmat;
     else;
            msg = "Omega matrix improperly dimensioned";
            goto errmsg;
    endif;



    llf = zeros(n,1);
    llfalt = zeros(n,1);
    share = zeros(n,1);
    ych = 1; do until ych > k;

      indx = packr(miss(seqa(1,1,n).*(ycat .== ych),0));
      del = -eye(k);
      del[.,ych] =  ones(k,1);
      v = x[indx,.];
      dv = del*v';
      
      if (covmeth == 0);                         @ reduced form @
        scol = sigma[.,ych];
        delomega = .5*(ones(k,k).*scol + scol' - sigma);
      elseif (covmeth == 1) or (covmeth == 2);
        delomega = del*omega*del';
        zz = sqrt(diag(delomega)^2);
        delomega = diagrv(delomega,zz);
      elseif (covmeth == 3);
        delomega = del*omega;
        delomega[.,1] = omega[.,1];
        delomega = delomega~sqrt(abs(omega[ych,1])).*ones(k,1);
      endif;
      
      sk = seqa(1,1,k); sk[ych] = miss(0,0); sk = packr(sk);
      dv = dv[sk,.];
      
      if covmeth == 3;
        delomega = submat(delomega,sk,0);
        if omega[ych,1] == 0;
           sk = cols(delomega)-1;
           sk = seqa(1,1,sk);
           delomega = submat(delomega,0,sk);
        endif;
      else  ;
        delomega = submat(delomega,sk,sk);
      endif;
      

      vmin = -10000*ones(k-1,1);
      trap 1;
      w = invpd(delomega);                   @  check for pd @
      trap 0;

      if scalerr(w) and (covmeth <= 1);      @ reduced form or full omega @
         w = eigh(delomega);
         penalty = sumc( (w .le 0).*w^2);
         llf[indx] = -2 -penalty*ones(rows(indx),1);       
         llfalt[indx] = -2 -penalty*ones(rows(indx),1);  
         _flag74=1;
      else;

  
          if _mnpint == 2;
            rndseed rndstart;
            call varput(1,"_qdfmth");  @ smooth recursive simulator @
            prob = (qdfn(dv,vmin,delomega));
          else;
            if (k > 4 and _ghkall==0);             @ Assuming that a simulation based@
                rndseed rndstart;
               @ method is used @
            endif; 
            
            prob = (qdfn(dv,vmin,delomega));            
          endif;

        _flag73=sumc(prob .<= 0);
        prob = prob.*(prob .> 0) + .0000003.*(prob .<= 0);
        @ Renormierung: Teil 1 @
         share[indx] = prob;
        llfalt[indx] = ln(prob); 
      endif;
      ych = ych+1;
    endo;
    
    @ error message checking @

 
    retp(llfalt);

ERRMSG:
          print msg;
          retp("");

endp;


