function [ a_T ] = get_a_T( param, excess_returns, analysis, factors, factor_type, c_fac, mim_base_assets)
% This is a_T in the generic a_T*g_T=0 setup, for the respective 
% "analysis" (here 2 or 7)
% see corresponding u_T procedure for comments

N=size(excess_returns,2);
K=size(factors,2);

    if analysis==2;     % two-pass regression

    % transforms N*K param vector into KxN beta matrix       
    [ ~, betas_mat, ~ ] = get_alpha_beta_lambda( param, analysis, excess_returns, factors, c_fac );    
    
    a_T=eye((1+K)*N);
    
        if factor_type==1;          % factor is excess return
        
        a_T=[a_T zeros(N*(1+K),K);zeros(K,N*(1+K)) eye(K)];
        
        elseif factor_type==2;      % if factors are not excess returns
                                    % pass regression
                     
                a_T=[a_T zeros(N*(1+K),N);zeros(K,N*(1+K)) betas_mat'];

            
           
        end;                        % factor types        
        
    elseif analysis==7;
        
    % Two-pass regression with initial mimicking portfolio
    
    % transforms N*K param vector into KxN beta matrix       
    [ ~, betas_mat, ~ ] = get_alpha_beta_lambda( param, analysis, excess_returns, factors, c_fac );  
    
    a_T=eye(size(mim_base_assets+1,2)+(1+c_fac)+(1+c_fac)*N);
    
    % c_fac is the number of mimicked factors, only ONE works here: MP_CDRM
    

                a_T=[a_T zeros(size(a_T,1),size(betas_mat,1));zeros(size(betas_mat,2),size(a_T,2)) betas_mat'];

    end                             % analysis
    
end                                 % function

