/* This GAUSS program produces the estimation and test results in 
J. Grammig and K.-O. Maurer:
"Non-monotonic hazard functions and the autoregressive conditional duration model", 
Econometrics Journal, 2000. 
*/

/* Including library and procedures */
library  cml,pgraph;
#include cml.ext;
#include pgraph.ext;
CMLset;
graphset;
OUTPUT file = ectj.out;
output reset;
output on;
#include ectj.dec; 
#include ectj.ext; 
#include ectj.src;   

/* Standard Settings for estimation, density forecast evaluation, and non-parametric testing*/

let number_of_bins = 20;                /*number of bins for histogram plot of z */
let lagorder       = 50;                /*lags for autocorrelation plot           */
let conf_interval  = 0.9;               /* 100 confidence interval for histogram plot */
P                  = 1;                 /* lag length for lagged psi in ACD model */
Q                  = 1;                 /* lag length for lagged XI in  ACD model */
EXO                = 0;                 /* 0 = no exogenous regressors in PSI equation: estimation period */
FEXO               = 0;                 /* same for forecasting period                                    */
NOEXOG             = 0;                 /* signifies number of exogenour regressors */
data_input         = {};                /* Dummy */
MYPOWER            = 2/9    ;           /* do not change this: used in bandwidht formula!!*/
let _allcases      = 1;                 /* All cases used for nonparametric density       */
_cml_algorithm     = 3;                       
_cml_linesearch    = 3;
_cml_covpar        = 3;

"";
"";
"===============================================================================";
"                     Non-monotonic hazard functions and the autoregressive";
"                                   conditional duration model             ";
"                             Joachim Grammig and Kai-Oliver Maurer        ";
"                                  University of Frankfurt                 ";
"                                        EctJ, 2000                        ";
"===============================================================================";
"";
"		Results are produced in this sequence:                         ";
"   		Boeing (in-sample)                                             ";
"   		Boeing (out-of-sample)                                         ";
"   		Coca-Cola (in-sample)                                          ";
"   		Coca-Cola (out-of-sample)						   ";
"   		Disney (in-sample)							   ";
"   		Disney (out-of-sample)							   ";
"   		Exxon (in-sample)								   ";
"   		Exxon (out-of-sample)							   ";
"   		IBM (in-sample)								   ";
"   		IBM (out-of-sample)							   ";

"   		6 figures of graphical test results are produced for each stock."; 
"   		The first three contain the in-sample, the second three the     ";
"   		out-of-sample charts. The EctJ article only contains in-sample  "; 
"   		results for Exxon and IBM.                                      ";
"		The log file ectj.out contains all numerical output.            ";
"";
"===============================================================================";
"";
"                                             Boeing                        ";
"===============================================================================";

loadm datamatrix   = ba;      
ALLCASES           = rows(datamatrix);
XI                 = datamatrix[1:round(allcases*(2/3)-1)];
CASES              = rows(XI);  
MIND_P             = genindx_with_cases(2,p,1,cases);   

/*Initial values:*/
loadm BACD_start   = ba_bacd_o.fmt;
loadm WACD_start   = ba_wacd_o.fmt;
loadm EACD_start   = ba_eacd_o.fmt;

/* In-sample evaluation */
FXI                = xi;
FCASES             = rows(FXI);                        
FMXI               = generate_lagged_xi(FXI,q,fcases); 
MXI                = generate_lagged_xi(XI,q,cases);    
"";
"";
"===============================================================================";
"                                  BACD: In-sample";
"===============================================================================";
"";
model              = "BACD";
call jg_ectj_2000(data_input, model, bacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"";
"===============================================================================";
"                                  WACD: In-sample";
"===============================================================================";
"";
model              = "WACD";
call jg_ectj_2000(data_input, model, wacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);
"";
"===============================================================================";
"                                  EACD: In-sample";
"===============================================================================";
"";
model              = "EACD";
call jg_ectj_2000(data_input, model, eacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"";
"";
"===============================================================================";
"";
"";
/* Out-of-sample evaluation */
FXI                = datamatrix[round(allcases*(2/3)):allcases];
FCASES             = rows(FXI);                        
FMXI               = generate_lagged_xi(FXI,q,fcases); 

"===============================================================================";
"                                  BACD: Out-of-sample";
"===============================================================================";
"";
model              = "BACD";
call jg_ectj_2000(data_input, model, bacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  WACD:  Out-of-sample";
"===============================================================================";
"";
model              = "WACD";
call jg_ectj_2000(data_input, model, wacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  EACD:  Out-of-sample";
"===============================================================================";
"";
model              = "EACD";
call jg_ectj_2000(data_input, model, eacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);
"";
"===============================================================================";
"";
"";
"                                    Coca Cola                                 ";
"===============================================================================";
"";
loadm datamatrix   = ko;      
ALLCASES           = rows(datamatrix);
XI                 = datamatrix[1:round(allcases*(2/3)-1)];
CASES              = rows(XI);  
MIND_P             = genindx_with_cases(2,p,1,cases);   

/*Initial values:*/
loadm BACD_start   = ko_bacd_o.fmt;
loadm WACD_start   = ko_wacd_o.fmt;
loadm EACD_start   = ko_eacd_o.fmt;

/* In-sample evaluation */
FXI                = xi;
FCASES             = rows(FXI);                        
FMXI               = generate_lagged_xi(FXI,q,fcases); 
MXI                = generate_lagged_xi(XI,q,cases);    

"===============================================================================";
"                                  BACD: In-sample";
"===============================================================================";
"";
model              = "BACD";
call jg_ectj_2000(data_input, model, bacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  WACD: In-sample";
"===============================================================================";
"";
model              = "WACD";
call jg_ectj_2000(data_input, model, wacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  EACD: In-sample";
"===============================================================================";
"";
model              = "EACD";
call jg_ectj_2000(data_input, model, eacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);
"";
"";
"===============================================================================";
"";
"";
/* Out-of-sample evaluation */
FXI                = datamatrix[round(allcases*(2/3)):allcases];
FCASES             = rows(FXI);                        
FMXI               = generate_lagged_xi(FXI,q,fcases); 

"===============================================================================";
"                                  BACD: Out-of-sample";
"===============================================================================";
"";
model              = "BACD";
call jg_ectj_2000(data_input, model, bacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  WACD:  Out-of-sample";
"===============================================================================";
"";
model              = "WACD";
call jg_ectj_2000(data_input, model, wacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  EACD:  Out-of-sample";
"===============================================================================";
"";
model              = "EACD";
call jg_ectj_2000(data_input, model, eacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);
"";
"===============================================================================";
"";
"";
"                                         Disney                               ";
"===============================================================================";
"";
loadm datamatrix   = dis;      
ALLCASES           = rows(datamatrix);
XI                 = datamatrix[1:round(allcases*(2/3)-1)];
CASES              = rows(XI);  
MIND_P             = genindx_with_cases(2,p,1,cases);   

/*Initial values:*/
loadm BACD_start   = dis_bacd_o.fmt;
loadm WACD_start   = dis_wacd_o.fmt;
loadm EACD_start   = dis_eacd_o.fmt;

/* In-sample evaluation */
FXI                = xi;
FCASES             = rows(FXI);                        
FMXI               = generate_lagged_xi(FXI,q,fcases); 
MXI                = generate_lagged_xi(XI,q,cases);    

"===============================================================================";
"                                  BACD: In-sample";
"===============================================================================";
"";
model              = "BACD";
call jg_ectj_2000(data_input, model, bacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);
"";
"===============================================================================";
"                                  WACD: In-sample";
"===============================================================================";
"";
model              = "WACD";
call jg_ectj_2000(data_input, model, wacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);
"";
"===============================================================================";
"                                  EACD: In-sample";
"===============================================================================";
"";
model              = "EACD";
call jg_ectj_2000(data_input, model, eacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);
"";
"";
"===============================================================================";
"";
"";

/* Out-of-sample evaluation */
FXI                = datamatrix[round(allcases*(2/3)):allcases];
FCASES             = rows(FXI);                        
FMXI               = generate_lagged_xi(FXI,q,fcases); 

"===============================================================================";
"                                  BACD: Out-of-sample";
"===============================================================================";
"";
model              = "BACD";
call jg_ectj_2000(data_input, model, bacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  WACD:  Out-of-sample";
"===============================================================================";
"";
model              = "WACD";
call jg_ectj_2000(data_input, model, wacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  EACD:  Out-of-sample";
"===============================================================================";
"";
model              = "EACD";
call jg_ectj_2000(data_input, model, eacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);
"";
"===============================================================================";
"";
"";
"                                                Exxon                         ";
"===============================================================================";
"";
loadm datamatrix   = xon;      
ALLCASES           = rows(datamatrix);
XI                 = datamatrix[1:round(allcases*(2/3)-1)];
CASES              = rows(XI);  
MIND_P             = genindx_with_cases(2,p,1,cases);   

/*Initial values:*/
loadm BACD_start   = xon_bacd_o.fmt;
loadm WACD_start   = xon_wacd_o.fmt;
loadm EACD_start   = xon_eacd_o.fmt;

/* In-sample evaluation */
FXI                = xi;
FCASES             = rows(FXI);                        
FMXI               = generate_lagged_xi(FXI,q,fcases); 
MXI                = generate_lagged_xi(XI,q,cases);    

"===============================================================================";
"                                  BACD: In-sample";
"===============================================================================";
"";
model              = "BACD";
call jg_ectj_2000(data_input, model, bacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  WACD: In-sample";
"===============================================================================";
"";
model              = "WACD";
call jg_ectj_2000(data_input, model, wacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  EACD: In-sample";
"===============================================================================";
"";
model              = "EACD";
call jg_ectj_2000(data_input, model, eacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

/* Out-of-sample evaluation */
FXI                = datamatrix[round(allcases*(2/3)):allcases];
FCASES             = rows(FXI);                        
FMXI               = generate_lagged_xi(FXI,q,fcases); 

"===============================================================================";
"                                  BACD: Out-of-sample";
"===============================================================================";
"";
model              = "BACD";
call jg_ectj_2000(data_input, model, bacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  WACD:  Out-of-sample";
"===============================================================================";
"";
model              = "WACD";
call jg_ectj_2000(data_input, model, wacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  EACD:  Out-of-sample";
"===============================================================================";
"";
model              = "EACD";
call jg_ectj_2000(data_input, model, eacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);
"";
"===============================================================================";
"";
"";
"                                          IBM                                 ";
"";
"===============================================================================";
"";
loadm datamatrix   = IBM;      
ALLCASES           = rows(datamatrix);
XI                 = datamatrix[1:round(allcases*(2/3)-1)];
CASES              = rows(XI);  
MIND_P             = genindx_with_cases(2,p,1,cases);   

/*Initial values:*/
loadm BACD_start   = ibm_bacd_o.fmt;
loadm WACD_start   = ibm_wacd_o.fmt;
loadm EACD_start   = ibm_eacd_o.fmt;

/* In-sample evaluation */
FXI                = xi;
FCASES             = rows(FXI);                        
FMXI               = generate_lagged_xi(FXI,q,fcases); 
MXI                = generate_lagged_xi(XI,q,cases);    

"===============================================================================";
"                                  BACD: In-sample";
"===============================================================================";
"";
model              = "BACD";
call jg_ectj_2000(data_input, model, bacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  WACD: In-sample";
"===============================================================================";
"";
model              = "WACD";
call jg_ectj_2000(data_input, model, wacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);

"===============================================================================";
"                                  EACD: In-sample";
"===============================================================================";
"";
model              = "EACD";
call jg_ectj_2000(data_input, model, eacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);
"";
"";
"===============================================================================";
"";
/* Out-of-sample evaluation */
FXI                = datamatrix[round(allcases*(2/3)):allcases];
FCASES             = rows(FXI);                        
FMXI               = generate_lagged_xi(FXI,q,fcases); 

"===============================================================================";
"                                  BACD: Out-of-sample";
"===============================================================================";
"";
model              = "BACD";
call jg_ectj_2000(data_input, model, bacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);
"";
"===============================================================================";
"                                  WACD:  Out-of-sample";
"===============================================================================";
"";
model              = "WACD";
call jg_ectj_2000(data_input, model, wacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);
"";
"===============================================================================";
"                                  EACD:  Out-of-sample";
"===============================================================================";
"";
model              = "EACD";
call jg_ectj_2000(data_input, model, eacd_start, 0,number_of_bins, lagorder, 1 , conf_interval);