/* This is a run of the procedure diebold_z that performs testing along the lines
   of Diebold-Hahn-Tsay 1997 based on NYSE Exxon price durations
   Data set:  xonqp18.fmt

   It estimates and evaluates financial duration models controlled by the string "model"
   EACD: Exponential ACD
   WACD: Weibull ACD
   BACD: Burr ACD
   GGACD: Generalized Gamma ACD
   GGLACD1: log-Generalized Gamma ACD (Type 1)
   GGLACD2: log-Generalized Gamma ACD (Type 2)
   the follwoing are self explained:
   ELACD1
   ELACD2
   WLACD2
   BLACD1
   BLACD2

   Per default, the BACD is the model estimated. The others are commented out.
   If you want to estimate a different model, remove the /* */ comments around 
   the code.

   other models that are possible to estimate and implemented in the program are
  
   Threshold-ACD (Zhang, Russell, Tsay)
   SCD (Bauwens and Veredas)
   SVD: Stochastic Volatility Duration (Ghysels Gourieroux Jasiak)

   
   Authors: Luc Bauwens (CORE, University Catholique Louvain), Pierre Giot, (CORE,Maastricht University)
            Joachim Grammig, (CORE, University of Frankfurt)   David Veredas, CORE

   For details refer to the paper
   Bauwens, L., P. Giot, J. Grammig, D. Veredas (2000) "A comparison of financial duration models via density
   forecasts", CORE Discussion paper 2000/60.
   Details on the Burr-ACD model (and ACD models in general) may also be found in
   J. Grammig and K.O. Maurer "Non-monotonic hazard functions and the Autoregressive Conditional Duration model, in:
   The Econometrics Journal, 2000, vol 3 pp. 16-38
*/

/* Invoke needed GAUSS modules and self written procedures */
 library cml, co, pgraph;
 #include cml.ext;
 #include co.ext
 #include pgraph.ext;
 CMLset;
 coset;
 graphset;
 #include highfreq.dec;   /* Globals                   */
 #include highfreq.ext;   /* ""                        */
 #include tacd.dec;       /* Threshold-ACD globals     */
 #include tacd.src;       /* Threshold-ACD sources     */
 #include svdDeflt.ext;   /* SVD globals               */
 #INCLUDE svd_h.src;      /* SVD sources               */
 #include dtyfcacd.src;   /* standard sources          */



/* Load and construct starting values */

loadm BACD_start      =  xonqp18_beta_bacd_o.fmt;
loadm WACD_start      =  xonqp18_beta_wacd_o.fmt ;
loadm EACD_start      =  xonqp18_beta_eacd_o.fmt;
GGACD_start           =  wacd_start|1;
loadm WLACD1_start    =  xonqp18_beta_lnwacd1_o.fmt;
loadm WLACD2_start    =  xonqp18_beta_lnwacd2_o.fmt;
BLACD1_start          =  wlacd1_start|0.1;
BLACD2_start          =  wlacd2_start|0.1;
elacd2_start          =  wlacd2_start[1:rows(wlacd2_start)-1];
elacd1_start          =  wlacd1_start[1:rows(wlacd2_start)-1];
GGLACD1_start         =  wLacd1_start|1;
GGLACD2_start         =  wLacd2_start|1;
BLACD2_s_start        =  wlacd2_start|0.1;
WLACD2_s_start        =  wlacd2_start|0.1;
elacd2_s_start        =  wlacd2_start[1:rows(wlacd2_start)-1];
GGLACD2_s_start       = wLacd2_s_start|1;


@============@
@ The following GLOBALS must be identical for all models tested to ensure comparability @

 let number_of_bins = 20;                 /*number of bins for histogram plot of z changed from binwidth: j.g. 9.11.99 */
 let lagorder = 50;                       /*Lags for autocorrelation plot:                      */
 let conf_interval = 0.9;                 /*90 % confidence interval for histogram plot         */

@ end common section @
@============@


/*******************   TO BE ADAPTED FOR EACH DATA SET    *******************/

loadm datamatrix = xonqp18;      /* Give here the name of your GAUSS fmt file containing the data */
OUTPUT file      = probe_o.out;  /* ASCII protocol file containing the numerical results          */
output reset; output on; screen on;

"                            xon Price 18 DATA FILE 20 Bins";
"                            ******************************";
" ";
"Estimation first two-third, evaluation last one third";

/****************************************************************************/

 ALLCASES = rows(datamatrix);

 P     =1;                                 /* lag length for lagged psi in ACD model (used as GLOBAL) */
 Q     =1;                                 /* lag length for lagged XI in  ACD model (used as GLOBAL) */

@
  This selects the last third of the data for forecasting purposes
  and also tests on the data
  The first two third are used for estimation
  The duration data is the 9 th column of the data matrix
@

 XI    = datamatrix[1:round(allcases*(2/3))-1,9];
 FXI   = datamatrix[round(allcases*(2/3)):allcases,9];

/* Globals needed for Forecasting j.g. November 4, 1999 */

                                           /* This uses the last third of durations for evaluation (XI is used as a GLOBAL)*/
 FCASES =rows(FXI);                        /* CASES is used as a GLOBAL in diebold_z                  */
 FMXI   =generate_lagged_xi(FXI,q,fcases); /* Generates a matrix of lagged durations (used as GLOBAL) */

/* Globals for Estimation  j.g. November 4, 1999
   You can leave all that for the start: Currently there are no exogenous variables
   included in the models
*/

 CASES =rows(XI);                         /* CASES used for estimation                                            */
 MXI   =generate_lagged_xi(XI,q,cases);   /* Generates a matrix of lagged durations for estimation(used as GLOBAL) */
 MIND_P=genindx_with_cases(2,p,1,cases);  /* Generates an index vector that is only needed if analytical gradients
                                             are supplied for EACD, WACD and BACD, then used as global
                                          */

 EXO    = 0;                             /* 0 = no exogenous regressors in PSI equation: estimation period */
 FEXO   = 0;                             /* same for forecasting period                                    */
 NOEXOG = 0;                             /* signifies number of exogenour regressors */
 data_input = {};                        /* I dont use this matrix to transfer data, I use Glokols (xi, mxi,)
                                            it may be needed, however for other models...*/
 let model_specifics = {};               /* just leave it */

"===============================================================================";
"                                  BACD";
" ";
model = "BACD";

est_model=1;		/*_cml_Maxiters = 25;*/

_cml_algorithm  = 4;                      /* CML settings */ 
_cml_linesearch = 3;
_cml_covpar     = 3;
restrict_ACD(model);

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound, 
	upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode}
      = diebold_z(data_input, model, bACD_start, model_specifics, number_of_bins, 
	  			  lagorder, est_model, conf_interval);

if est_model==1; 
call print_estimation_results (LOGL,beta,vc,retcode,CASES);
else;
call print_noestimation (BACD_start,CASES);
endif;
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);


/*
"===============================================================================";
"                                  GGACD";
" ";
model = "GGACD";

est_model=1;		/*_cml_Maxiters = 25;*/

_cml_algorithm  = 4;                      /* CML settings */ 
_cml_linesearch = 3;
_cml_covpar     = 3;
restrict_ACD(model);

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound, 
	upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode}
      = diebold_z(data_input, model, GGACD_start, model_specifics, number_of_bins, 
	  			  lagorder, est_model, conf_interval);
xonqp18_beta_ggacd_o=beta;
save xonqp18_beta_ggacd_o;

if est_model==1; 
call print_estimation_results (LOGL,beta,vc,retcode,CASES);
else;
call print_noestimation (GGACD_start,CASES);
endif;
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);
*/

/*
"===============================================================================";
"                                  GGLACD1";
" ";
model = "GGLACD1";

est_model=1;		/*_cml_Maxiters = 25;*/

_cml_algorithm  = 4;                      /* CML settings */ 
_cml_linesearch = 3;
_cml_covpar     = 3;
restrict_LACD(model);

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound, 
	upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode}
      = diebold_z(data_input, model, GGLACD1_start, model_specifics, number_of_bins, 
	  			  lagorder, est_model, conf_interval);

if est_model==1; 
call print_estimation_results (LOGL,beta,vc,retcode,CASES);
else;
call print_noestimation (GGLACD1_start,CASES);
endif;
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);
*/

/*
"===============================================================================";
"                                  GGLACD2";
" ";
model = "GGLACD2";

est_model=1;		/*_cml_Maxiters = 25;*/

_cml_algorithm  = 1;                      /* CML settings */ 
_cml_linesearch = 2;
_cml_covpar     = 3;
restrict_LACD(model);

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound, 
	upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode}
      = diebold_z(data_input, model, GGLACD2_start, model_specifics, number_of_bins, 
	  			  lagorder, est_model, conf_interval);

if est_model==1; 
call print_estimation_results (LOGL,beta,vc,retcode,CASES);
else;
call print_noestimation (GGLACD2_start,CASES);
endif;
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);

*/

/*
"===============================================================================";
"                                  WACD";
" ";
model = "WACD";
est_model=1;

cmlset;
_cml_algorithm  = 4;                      /* CML settings */ 
_cml_linesearch = 3;
_cml_covpar     = 3;
restrict_ACD(model);

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound,
	upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode}
      = diebold_z(data_input, model, WACD_start, model_specifics, number_of_bins, 
	  			  lagorder, est_model, conf_interval);

if est_model==1; 
call print_estimation_results (LOGL,beta,vc,retcode,CASES);
else;
call print_noestimation (WACD_start,CASES);
endif;
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);
*/

/*
"===============================================================================";
"                                  EACD";
" ";
model = "EACD";                         

est_model=1;

cmlset;
_cml_algorithm  = 4;                      /* CML settings */ 
_cml_linesearch = 3;
_cml_covpar     = 3;
restrict_ACD(model);

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound,
	upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode}
      = diebold_z(data_input, model, EACD_start, model_specifics, number_of_bins, 
	  			  lagorder, est_model, conf_interval);

if est_model==1; 
call print_estimation_results (LOGL,beta,vc,retcode,CASES);
else;
call print_noestimation (EACD_start,CASES);
endif;
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);
*/
/*
"===============================================================================";
"                                  POISSON";
" ";
model = "POISSON";

est_model=0;
/* There is only one parameter in the Poisson process, the so-called lambda
It must be specified as the first coefficient
However, I use 1 0 0 0 so that we can still use the procedures designed for the WACD... 
NB: this assumes there are NO exogenous variables */
let POISSON_estimates  = 1 0 0 0;
/* For the exponential distribution, the estimated parameter is equal the mean of the xi */
lam=meanc(xi);
POISSON_estimates[1,1]=lam;

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound,
	upper_bound, chi_square, p_value, degrees_freedom, void1, void2, void3, void4} = 
	diebold_z(data_input, model, POISSON_estimates, model_specifics, number_of_bins, 
			  lagorder, est_model, conf_interval);

LOGL = -(ln(lam)+(sumc(xi)/lam));
vc = lam^2/CASES;
call print_estimation_results (LOGL,lam,vc,0,CASES);
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);
*/


/* -------------------------------------------------------------------*/
/* Density Forecasting and testing using models of the LOG-ACD family */
/* -------------------------------------------------------------------*/

/*
"===============================================================================";
"                                  BLACD1";
" ";
model = "BLACD1";

est_model=1;

_cml_algorithm  = 4;                      /* CML settings */ 
_cml_linesearch = 3;
_cml_covpar     = 3;
restrict_LACD(model);

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound, 
	upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode}
      = diebold_z(data_input, model, BLACD1_start, model_specifics, number_of_bins, 
	  			  lagorder, est_model, conf_interval);

if est_model==1; 
call print_estimation_results (LOGL,beta,vc,retcode,CASES);
else;
call print_noestimation (BLACD1_start,CASES);
endif;
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);
*/

/*            
"===============================================================================";
"                                  WLACD1";
" ";
model = "WLACD1";                         

est_model=1;

cmlset;
_cml_algorithm  = 4;                      /* CML settings */ 
_cml_linesearch = 3;
_cml_covpar     = 3;
restrict_LACD(model);

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound,
	upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode} =
	diebold_z(data_input, model, WLACD1_start, model_specifics, number_of_bins, 
			  lagorder, est_model, conf_interval);

if est_model==1; 
call print_estimation_results (LOGL,beta,vc,retcode,CASES);
else;
call print_noestimation (WLACD1_start,CASES);
endif;
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);
*/

/*
"===============================================================================";
"                                  ELACD1";
" ";
model = "ELACD1";                         

est_model=1;

cmlset;
_cml_algorithm  = 4;                      /* CML settings */ 
_cml_linesearch = 3;
_cml_covpar     = 3;
restrict_ACD(model);

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound,
	upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode}
      = diebold_z(data_input, model, ELACD1_start, model_specifics, number_of_bins, 
	  			  lagorder, est_model, conf_interval);

if est_model==1; 
call print_estimation_results (LOGL,beta,vc,retcode,CASES);
else;
call print_noestimation (ELACD1_start,CASES);
endif;
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);
*/

/*
"===============================================================================";
"                                  BLACD2";
" ";
model = "BLACD2";
est_model=1;

_cml_algorithm  = 4;                      /* CML settings */ 
_cml_linesearch = 3;
_cml_covpar     = 3;
restrict_LACD(model);

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound, 
	upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode}
      = diebold_z(data_input, model, BLACD2_start, model_specifics, number_of_bins, 
	  			  lagorder, est_model, conf_interval);

if est_model==1; 
call print_estimation_results (LOGL,beta,vc,retcode,CASES);
else;
call print_noestimation (BLACD2_start,CASES);
endif;
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);
*/
/*            
"===============================================================================";
"                                  WLACD2";
" ";
model = "WLACD2";                         

est_model=1;

cmlset;
_cml_algorithm  = 4;                      /* CML settings */ 
_cml_linesearch = 3;
_cml_covpar     = 3;
restrict_LACD(model);

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound,
	upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode} = 
	diebold_z(data_input, model, WLACD2_start, model_specifics, number_of_bins, 
			  lagorder, est_model, conf_interval);

if est_model==1; 
call print_estimation_results (LOGL,beta,vc,retcode,CASES);
else;
call print_noestimation (WLACD2_start,CASES);
endif;
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);
*/

/*
"===============================================================================";
"                                  ELACD2";
" ";
model = "ELACD2";

est_model=1;

cmlset;
_cml_algorithm  = 4;                      /* CML settings */ 
_cml_linesearch = 3;
_cml_covpar     = 3;
restrict_ACD(model);

{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound,
	upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode}
      = diebold_z(data_input, model, ELACD2_start, model_specifics, number_of_bins, 
	  			  lagorder, est_model, conf_interval);

if est_model==1; 
call print_estimation_results (LOGL,beta,vc,retcode,CASES);
else;
call print_noestimation (ELACD2_start,CASES);
endif;
call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
		corr_z,limsup,ratio_z,corr_z2,ratio_z2);

*/

/*

/* ---------------------------------------------------------------*/
/* Density Forecasting and testing using models of the SVD */
/* ---------------------------------------------------------------*/

model = "SVD";

/* Here change any SVD defaults you want
   defaults are in svddeflt.ext
*/

_svd_sml_ActivePsi = {1 0,0 1};  /* Diagonal Factor Structure: Default is overwritten */

/*_svd_sml_IterationS = 5;
_svd_dsc_samples    = 5;
_svd_dsc_iterations = 5;
*/

/* Call estimation and density evaluation program */
est_model=1;
{z, corr_z, limsup, ratio_z, corr_z2, ratio_z2, xaxis_z_bins, yaxis_z_bins, lower_bound,
    upper_bound, chi_square, p_value, degrees_freedom, LOGL, beta, vc, retcode}
      = diebold_z(data_input, model, 0, model_specifics, number_of_bins,
                  lagorder, est_model, conf_interval);

call print_evaluation_results (chi_square,p_value,degrees_freedom,FCASES,
        corr_z,limsup,ratio_z,corr_z2,ratio_z2);

*/


