
/************************************************************************
	read in data in event time
************************************************************************/

format 16,8;

oldcapt = 896;
/* SAS fild ordering : ;
where chang is in sas = bin in gauss
"TARGET","CHANGE","FOMC","TB6_WAV","FF_WAV","SP6MFF","spread","event","chang","kdate","monthdum","duration"*/
loadm  zz_data = newdata3;
capt = rows(zz_data);

datex = seqa(1,1,capt);
event= zz_data[1:capt,8];event[1,1] = 1;
target = zz_data[1:capt,1];
dur = zz_data[1:capt,12];
duration = zz_data[1:capt,12];
chang = zz_data[1:capt,2];
change = zz_data[1:capt,2];
	i = 2;
	do until i > capt;
		if event[i,1] == 1;
		change[i,1] = change[i,1];
        	duration[i,1] = duration[i,1];
		else;
        	change[i,1] = change[i-1,1];
		duration[i,1] = duration[i-1,1];
		endif;
	i=i+1;
	endo;
	
duration[1:3,.] = 1 | 1| 2;
bin = zz_data[1:capt,9];
fomc = zz_data[1:capt,3];
ffr = zz_data[1:capt,5];
sp6mff = zz_data[1:capt,6];
spread6 = zz_data[1:capt,7];
tbill6 = zz_data[1:capt,4];
ffr = zz_data[1:capt,5];
fridate = zz_data[1:capt,10];
monthdum = zz_data[1:capt,11];

lagtarget =  9.5 | target[1:capt-1,1];
lagfomc = 0 | fomc[1:capt-1,1];
spreadtarget = lagtarget - tbill6;

event[1,1] = 0;	
use_only_cases_upto=115;
full_event = sumc(event);


i1 = use_only_cases_upto;
i0 = 0;


num_k = 5;
reference_state = 3; 


sj = -0.5 | -0.25 | 0 | 0.25 | 0.5;


"___________________________________________________________________";
"___OPTIONs______DATA_______________________________________________";
"___________________________________________________________________";

"____________________full data set  = ";; capt;
"use only cases up to for estimation = ";; use_only_cases_upto;
"_____________use casses full event  = ";; full_event;
"_____________number of states used: ACM  = ";; num_k;
"_____________reference state      : ACM  = ";; reference_state;
"___________________________________________________________________";
"___________________________________________________________________";
	
/************************************************************************
    select and convert data to event time
 ************************************************************************/
 
/* HJ use only the first use_only_cases_upto events for estimation.
   However, for forecasting, we need the full set of 115 events
*/ 

 
eventdata = zeros(200,23);
changit = zeros(200,1);
ybin = zeros(200,1);
event[1,1] = 0;
lagchange = 0;

i = 1;
t = 1;
 do until t > capt;
    if event[t,1] == 1;
        eventdata[i,1]=lagchange;
        eventdata[i,2]=spread6[t,1];
        eventdata[i,3]=datex[t,1];
        eventdata[i,4]=target[t,1];
	/*ybin[i,1] = bin[t,1];*/
            changit[i,1]= chang[t,1];
                if t > 1;
            lagchange = target[t,1] - target[t-1,1];
        endif;
        i = i+1;
    endif;
t = t+1;
endo;

chang = changit[1:full_event,.];
eventdata_fore= eventdata[1:full_event,.]; 
eventdata= eventdata[1:use_only_cases_upto,.]; 

/************************************************************************
    initialize a xtilde matrix and construct xtilde and x matrix
 *************************************************************************/

xtildeg = zeros(num_k,full_event);
ybin = zeros(full_event,1);


	i=1;
	do until i gt full_event;
	if  (chang[i,1] ge minc(chang)) and (chang[i,1] le -0.4375);
	ybin[i,1] = -0.5;
	xtildeg[.,i] = 1|0|0|0|0;
	elseif (-0.4375 < chang[i,1]) and (chang[i,1] le -0.125);
	ybin[i,1] = -0.25;
	xtildeg[.,i] = 0|1|0|0|0;
	elseif (-0.125 < chang[i,1])  and (chang[i,1] < 0.125);
	ybin[i,1] = 0;
	xtildeg[.,i] = 0|0|1|0|0;
	elseif (0.125 le chang[i,1]) and (chang[i,1] < 0.4375);
	ybin[i,1] = 0.25;
	xtildeg[.,i] = 0|0|0|1|0;
	else; /* (0.4375 le chang[i,1])  and (chang[i,1] le maxc(chang));  */
	ybin[i,1] = 0.5;
	xtildeg[.,i] =  0|0|0|0|1; 
	endif;
	i=i+1;
	endo;

chang = changit[1:use_only_cases_upto,.];
xtilde_fore= xtildeg[.,1:full_event];
xtilde = xtildeg[.,1:use_only_cases_upto];

/* the x matrix is the xtilde matrix without the reference state of xtilde */
x = mat_rs_delete(reference_state,xtilde)';
x_fore = mat_rs_delete(reference_state,xtilde_fore)';
/************************************************************************
        set initial values for first pi and h value
 ************************************************************************/
pi_init=sumc(xtilde')/sumc(sumc(xtilde'));
pi_init1=pi_init;
xtilde_out = xtilde_fore[.,cols(xtilde)+1:cols(xtilde_fore)];
pi_init_out =sumc(xtilde_out')/sumc(sumc(xtilde_out'));
pi_init_fore=sumc(xtilde_fore')/sumc(sumc(xtilde_fore'));
pi_init = mat_rs_delete(reference_state,pi_init);
h_init=ln(pi_init/(1-ones(rows(pi_init),1)'*pi_init ));


"pi" pi_init;


z = zeros(num_k-1,1);

/*like in hamilton and jorda code we include for the first value a zero, since we
loose one observation by taking lags */
lagx = (z' | x[1:rows(x)-1,.]);
/*rows(lagx);*/
lagx_fore = (z' | x_fore[1:rows(x_fore)-1,.]);




/************************************************************************
        this is done for the forecast preparation....
 *************************************************************************/


 
monthstart = zeros(capt,1);  @ contains number of weeks prior to t to get to previous month @
monthend = zeros(capt,1);   @ contains number of weeks after t to get to next month @
it = 1;
do until it > capt;
	monthstartcount = 1;
	monthendcount = 1;
	if monthdum[it,1] == 1;
		monthstart[it,1] = 1;
	else;
		do until monthstartcount > 5;
			if (it - monthstartcount) > 0;
				if monthdum[it-monthstartcount,1] == 1;
					monthstart[it,1] = monthstartcount+1;
					monthstartcount = 6;
				endif;
			else;
				monthstart[it,1] = it - 1;
				monthstartcount = 6;
			endif;
		monthstartcount = monthstartcount+1;
		endo;
	endif;
	do until monthendcount > 5;
		if (it + monthendcount) < (capt + 1);
			if monthdum[it+monthendcount,1] == 1;
				monthend[it,1] = monthendcount;
				monthendcount = 6;
			endif;
		else;
			monthend[it,1] = capt - it;
			monthendcount = 6;
		endif;
	monthendcount = monthendcount+1;
	endo;
it = it+1;
endo;

monthstart[1:5,1] = 0|1|2|3|4;

monthcou=monthstart~monthend;
save monthcou = monthcou;


t1 =capt;         @ t1 is the last period analyzed in weekly analysis @

datexx = lastmonth2(fridate);
datexx[1:5,1] = 19840224* ones(5,1);

outtarr = lastmonth2(target);
outtarr[1:5,1] = 9.5*ones(5,1);

lagtar = fridate ~ target ~ datexx ~ outtarr;


proc (1) = mat_rs_delete(rs,mat);
/* description: there comes a ROWS!!! vector in with the dimension
num_k = rows(mat);
the total number of states is num.
the refernce state is deleted from and indicator
vector for the reference state->rs_ind
for the new matrix only the rows are selected without the
reference state row*/
local new_mat,num,rs_ind,sel;

num = rows(mat);
rs_ind = seqa(1,1,num);
sel = delif(rs_ind,rs_ind .== rs);
new_mat = mat[sel,.];

retp(new_mat);
endp;

proc (1) = mat_rs_include(rs,mat);
/* description: there comes a row vector in with the dimension
num_k = rows(mat);
the total number of states is num.
the refernce state is included 
for the new matrix only the rows are selected with the
reference state row*/
local new_mat,rs_state,rs_ind,sel,num,i;

rs_state = 1-sumc(mat); /* there comes out a column vector*/

num = rows(mat)+1;
rs_ind = seqa(1,1,num);
sel = delif(rs_ind,rs_ind .== rs);

new_mat = zeros(num,cols(mat));
i= 1;
do until i ge num;
new_mat[sel[i],.]= mat[i,.];
i = i+1;
endo;
new_mat[rs,.]  = rs_state';

retp(new_mat);
endp;

proc lastmonth2(x);
@ this proc creates a weekly series whose output value for any week is 
	the value that the input vector assumed for the last week during the
	last complete month prior to week t; first 5 values are -1000 by construction @
local y, it,ij;
y = -1000*ones(t1,1);         @ this can be used to make sure no entry fails to get filled @
it = 6;
do until it > t1;
	ij = 0;
	do until ij > 5;
		if monthdum[it-ij,1] == 1;
			y[it,1] = x[it-ij-1,1];
			ij = 5;
		endif;
	ij = ij+1;
	endo;
it = it+1;
endo;
retp(y);
endp;


/********************************************************************************
*********************************************************************************
Creates unconditional transition and conditional transition probability-matrices.
*********************************************************************************
*********************************************************************************
(i)   matrix of unconditional transitions: absolute values
(ii)  matrix of unconditional transitions: relative values
(iii) matrix of conditional transition probabilites: fixed origin, random destination 
(iv)  matrix of conditional transition probabilites: random origin, fixed destination
********************************************************************************/



/*******************************************************************************
(i)   matrix of unconditional transitions: absolute values
********************************************************************************/
trans = transition(xtilde); /* output 'trans' can be renamed whenever it is called */
trans_fore = transition(xtilde_fore); /*output 'trans' can be renamed whenever it is called */
/*******************************************************************************
(ii)   matrix of unconditional transitions: relative values
********************************************************************************/

trans_rel = trans/(cols(xtilde)-1);
trans_rel_fore = trans_fore/(cols(xtilde_fore)-1);
/*******************************************************************************
(iii)   matrix of conditional transition probabilites: fixed origin, random destination 
********************************************************************************/
trans_con_1 = trans ./ sumc(trans');
trans_con_1_fore = trans_fore ./ sumc(trans_fore');
/*******************************************************************************
(iv)   matrix of conditional transition probabilites: random origin, fixed destination
********************************************************************************/
trans_con_2 = trans ./ sumc(trans)';




proc (1)=transition(xtilde);
local trans, xtilde_t, xtilde_tplus, a, b, i, mat;

/* initializes matrix of unconditional transitions */
trans = zeros(rows(xtilde),rows(xtilde)); 


/* comparison: state(t) and state(t+1): considers (cols(xtilde)-1) transitions;
xtilde_t: state in t, xtilde_tplus: state in t+1 */ 
xtilde_t = xtilde[.,1:(cols(xtilde)-1)];
xtilde_tplus = xtilde[.,2:cols(xtilde)]; 

i = 1;
do while i le cols(xtilde_t);

a = indexcat(xtilde_t[.,i],1);              /* determines state in t */
b = indexcat(xtilde_tplus[.,i],1);          /* determines state in t+1 */

mat = zeros(rows(xtilde),rows(xtilde));     /* initializes matrix */
mat[a,b]=1;                                 /* fills in 1 for event of corresponding transition */

trans = trans + mat;                        /* cumulates number of events */
i = i+1;
endo;

retp(trans);
endp;

