/************************************************************************
 This Gauss program controls estimation of probit model 
 James D. Hamilton and Oscar Jorda (1999)
 "A Model for the Federal Funds Rate Target"
************************************************************************/

/************************************************************************
     I adjusted the code, however, in principal it remained unchanged
     This code corresponds to the results reported in Section 3.2 of the
     thesis:     "Empirical Estimates for the Ordered Probit Model"   
     with this code you can reproduce the results reported in Table 5     
************************************************************************/


library pgraph,optmum;
#include optmum.ext;
#include pgraph.ext;
graphset; optset;   
format 16,8;




/************************************************************************
	read in data in calendar time
************************************************************************/

#include readdatb4.prg; 

event[1,1] =0;


/**********************************************************************************************
	set control parameters
*********************************************************************************************/
eventdata = eventdata[.,1:2];
ki = cols(eventdata);          @ ki is the number of explanatory variables, 
						excluding constant term @
kc = 		1;                @ use kc = 2 to print values when likelihood called
                                    kc = 1 for no print @
kqopt = 	1;	          @ use kqopt = 1 for numerical search to avoid crash
                                    use kqopt = 2 for calculation of final standard errors @
deltiny = 1.e-3;          @ this is a tiny value that prevent algorithm from calculating a zero
 	                               difference between bins @

#include probseek.src;

/************************************************************************************
	set initial values for parameters 
************************************************************************************/
if num_k == 5;
th0 = 	2.6 | 0.4 | -2 | ones(3,1);
elseif num_k == 4;
th0 = 	1 | 1 | -1 | 1*ones(2,1);
else;
"num_k problem "; stop;
endif;
proc startval;     @ This defines starting value for iteration to be th0 @
  retp(th0); endp;

"Initial values";
if num_k == 4;
probix_4(th0);
elseif num_k == 5;
probix_5(th0);
else;"num_k problem "; stop;
endif;


/**********************************************************************************************
 estimate parameters by maximum likelihood 
**********************************************************************************************/
"";"------------------------";"";

kc = 1;

     #include optmum.ext;
      _opalgr = 2;    @ This chooses BFGS optimization  @
      _opmiter = 300;  @ This controls the maximum number of iterations @
if num_k == 4;
       {thx,f,g,h} =optmum(&probix_4,startval);
elseif num_k == 5;
       {thx,f,g,h} =optmum(&probix_5,startval);
else;"num_k problem "; stop;
endif;

kqopt = 2;
	thx[ki+2,1] = thx[ki+1,1] + thx[ki+2,1]^2 + deltiny;
	thx[ki+3,1] = thx[ki+2,1] + thx[ki+3,1]^2 + deltiny;
	if num_k == 5;
	thx[ki+4,1] = thx[ki+3,1] + thx[ki+4,1]^2 + deltiny; endif;
"";"";"Final results";"MLE as parameterized for numerical optimization ";
"Coefficients:";thx';
"";"Value of log likelihood:";;-f;
"";"Gradient vector:";g';

"==================================";
kc = 2;
if num_k == 4;
        call probix_4(thx);
elseif num_k == 5;
	call probix_5(thx);
else;"num_k problem "; stop;
endif;



/* ------------------------------------------------------------------------------------------------------------------------
   === CALCULATE STANDARD ERRORS === */

kc = 1;

if num_k == 4;
   g = gradp(&probix_4,thx);hs = (hessp(&probix_4,thx));
elseif num_k == 5;
g = gradp(&probix_5,thx);hs = (hessp(&probix_5,thx));
else;"num_k problem "; stop;
endif;


"";"Numerically calculated gradient:";
"";"";

   va = eigrs(hs);
   if minc(eigrs(hs)) <= 0;
        "Negative of Hessian is not positive definite";
        "Either you have not found local maximum, or else estimates are up "
        "against boundary condition.  In latter case, impose the restricted "
        "params rather than estimate them to calculate standard errors";
    else;
       hs = invpd(hs);
       std = diag(hs)^.5;
       "For vector of coefficients parameterized as follows,";(thx)';
       "the standard errors are";std';
    endif;


"variance covariance matrix is";
format /m3;
hs;
format /m1;
hs;

if num_k == 4;
output file = probseek_par4.prg reset;
elseif num_k == 5;
output file = probseek_par5.prg reset;
else;"num_k problem "; stop;
endif;

output off;
output on;
"probseek_par = {"; thx "};";       
output off;

output file = probseek.out reset;
probseek_par = thx ~ std  ~ (thx ./ std); 
  "For vector of coefficients";
 "and standard errors"; 
"t -test"; ; probseek_par;
 " maximized likelihood value: "; -f;
 
 lp ="/home/kehrleke/share/gk2005/reviseresubmit5/results_myacm/";
 f = -f~rows(thx)~rows(eventdata);
 save path = ^lp max_lik_op_num = f;
