@ This GAUSS code contains procs used in var analysis @

/* ========================================================== 
	proc to create lags of variables 
    ========================================================== */
proc makelags(xz,plag,nfirst);
@ this proc takes vector of obs from 1 (say, 1965:1) to nt (say, 1995:12) and turns it into
     matrix whose rows cover nfirst (say, 1966:1) to nt (1995:12); 
     first column is lagged 1, second column is lagged 2;
     last column is lagged plag @
local xlag, ilag;
xlag = xz[nfirst-1:rows(xz)-1,1];
ilag = 2;
do until ilag > plag;
          xlag = xlag ~ xz[nfirst-ilag:rows(xz)-ilag,1];
ilag = ilag + 1;
endo;
retp(xlag);
endp;

/* =======================================================
	proc to put lags into a matrix plus a constant 
   ======================================================= */
proc multlags(yz,plag,nfirst);
@   inputs:
		yz = (ntotal x ny) matrix of original observations
		plag = number of lags used
		nfirst = index of the first observation used for estimation
	output:
		xz = (nusable x (1 + ny*plag)) matrix of explanatory variables for VAR
		col. 1 = constant term
		col. 2 = value of first element of yz for date nfirst - 1
		col. 3 = value of first element of yz for date nfirst - 2
		        ...
		col. plag +1 = value of first element of yz for date nfirst - plag
		col. plag + 2 = value of second element of yz for date nfirst - 1 @
local xz,iy;
xz = zeros(rows(yz)-nfirst+1,1);
iy = 1;
do until iy > cols(yz);
	xz = xz ~ makelags(yz[.,iy],plag,nfirst);
iy = iy + 1;
endo;
xz = xz[.,2:cols(xz)];
xz = ones(rows(xz),1)~xz;
retp(xz);
endp;

/*  =======================================================
	proc to estimate VAR
    ======================================================== */
proc(3)=varit(yv,xv);
@ input:
	yv = (nr x ny) matrix of nr observations on ny left-hand variables
	xv = (nr x nx) matrix of nr observations on nx right-hand variables
		               note first column of this matrix should be constant term
    output:
	bhat1 = (ny x nx) matrix of OLS regression coefficients
	vhat1 = (ny X ny) covariance matrix of OLS residuals 
	ehat1 = (nr x ny) matrix of OLS residuals  @
local bhat1,vhat1,nr,ehat1;
nr = rows(yv);
bhat1 = (yv'*xv)*invpd(xv'*xv);
ehat1 = yv - xv*bhat1';
vhat1 = (ehat1'*ehat1)/nr;
retp(bhat1,vhat1,ehat1);
endp;

/* ========================================================
	this proc simulates the VAR for one period
    ========================================================= */
proc(2)=updates(ylag,ycur,k0,simcont);
	@ this proc simulates VAR for one step
		inputs:
			ylag = (nys x 1) vector of lagged values of variables of VAR
			ycur = (ny x 1) vector of current values of variables in VAR
			k0 = (ny x 1) vector of constant terms (if desired) plus shocks (used for
			 	checking) for residuals; set to zero if just want simple impulse-
				response function
			simcont = (ny x 1) vector that controls exogenous variables in VAR
				ith element of simcont is 1 if that variable is to be forced to equal
				the ith element of ycur; if so, the necessary residual is stored in 
				the ith element of et which is returned by the proc
		globals:
			b0 = (ny x ny) matrix of contemporaneous coefficients of VAR  (assumes
				is lower triangular with ones on diagonal and negative of OLS coefficients
				on contemporaneous terms below the diagonal)
			phi = (ny x nys) matrix of coefficients on lagged variables of VAR
			ny = number of variables in the VAR
		output:	
			ynew = (ny x 1) vector of new values for variables of VAR
			et = (ny x 1) vector of shocks to values necessary to obtain restriction @
local it, ynew, bcur, et;
bcur = eye(ny) - b0;
ynew = zeros(ny,1);
et = zeros(ny,1);
ynew[1,1] = phi[1,.]*ylag + k0[1,1];
ycur[1,1] = ynew[1,1];
it = 2;
do until it > ny;
	ynew[it,1] = bcur[it,.]*ycur + phi[it,.]*ylag+ k0[it,1];
	if simcont[it,1] > 0;
		et[it,1] = ycur[it,1] - ynew[it,1] ;
		ynew[it,1] = ycur[it,1];
	endif;
	ycur[it,1] = ynew[it,1];
it = it+1;
endo;
retp(ynew, et);
endp;

/* =========================================================
    this proc takes the output from simulation and restacks in appropriate locations
    in the lagged variables of the VAR
    ========================================================= */
proc readj(xnew,xold,nyx);
	@ input:
		xnew = (nys x 1 ) vector of new values for variables in VAR
	   	xold = (1 x  (nys * plags)) vector of old values for all conditioning variables 
		nyx = number of variables  appearing as lags in VAR (should equal global
			  ny in usual case
	    output:
		xold = updated value for xold  @
local ir;
ir = 1;
do until ir > nyx;
	xold[1,1+(ir-1)*plag:ir*plag] = xnew[ir,1] ~ xold[1,1+(ir-1)*plag:ir*plag-1];
ir = ir+1;
endo;
retp(xold);
endp;


/* =============================================================
    this proc simulates VAR from given initial condition and time path for any restricted 
    variables or shocks 
    ============================================================= */
proc(2)=simul(x0,xforce,k0,ks,simcont);
@	input: 
		x0 = (1 x nys) vector of initial values for all explantory variables
			(set equal to zeros if want usual impulse-response function)
		xforce = (ny x ks) matrix of values to which variables are to be forced, if
			desired (set equal to zero if not wanted)
		k0 = (ny x ks) matrix of constant terms plus any shocks one wants to add
			to each equation (set to zero for regular impulse-response function
		ks = number of desired simulations
		simcont = (ny x 1) vector that controls exogenous variables in VAR
				ith element of simcont is 1 if that variable is to be forced to equal
				the (i,it) element of xforce at step it; if so, the necessary residual
				 is stored in the (i,it) element of eall which is returned by the proc
	global:
		ny = number of variables of system
		phi,b0 = used by proc updates (called by this proc)
		plag = number of lags in VAR (used by proc readj)
	output:
		h = (ny x ks) matrix of simulated values for variables of system
		eall = (ny x ks) matrix of values for shocks, if calculated @

local h,it,ynew,eall,e0;
h = zeros(ny,ks);
eall = zeros(ny,ks);
it = 1;
do until it > ks;
	{ynew, e0} = updates(x0',xforce[.,it],k0[.,it],simcont);
	h[.,it] = ynew;
	eall[.,it] = e0;
	x0 = readj(ynew,x0,ny);
it = it+1;
endo;
retp(h,eall);
endp;
	

