/* 
  
tell_tale_tails.prg

Front-End Program to replicate the results in 

Joachim Grammig and ranziska Julia Peter  
        
              Tell-Tale Tails
A New Approach to Estimating Unique Information Shares

Journal of Financial and Quantitative Analysis
Vol. 48, No 2, April 2013

see readme.txt for explanations on how to use

Department of Econometrics, 
Statistics and Empirical Economics
University of Tübingen
Mohlstrasse 36

D-72074 Tübingen
Germany

http://www.wiwi.uni-tuebingen.de/cms/index.php?id=881
http://www.facebook.com/tuemetrics

Tel: +49 7071 29 76009

September 2, 2011 
revised September 3, 2013
*/ 


new;
dseed=2128565434+7; /*set seed for bootstrap*/
/************Some settings for the empirical analysis: Global variables************/
/* The cointegration vector is fixed to its theoretical values*/
ci_vec_fixed    = 1; /* zero: use estimated ci vector, one: use fixed one */
ci_vector_fixed = {1,-1}; /* this is the fixed vector */
demean_ci_relation=1; /* Set to one if the cointegrating re-lation to be de-meaned
                         which is sensible for CDS/Bond market data. 
                         The mean of the residuals from the cointegrating relation
                         beta*prices seems nonzero by the naked eye clearly
                         in these data. If you want to impose the restriction that 
                         there is no drift in the price series (very sensible
                         for the blanco application) then you need to de-mean the
                         cointegrating relation (see Hasbrouck 1995, equation 13
                         or Hamilton p. 581, equation 19.1.45*/
Mix_model_type=0; /* Needed for bootstrap. Mix_model_type=0 implies the full model, and 
                     Mix_model_type=2 bootstraps the diagonal model (W is a diagonal matrix)*/
id= "ford" $+ "_nomiss";
identifier=7; /*identifier: ford is 7th entity*/
k=1; /*k=Lag length VECM (q-1)*/
#include model.src;   /*source file- has to be included!*/
library cml; /*GAUSS CML library invoke*/
cmlset; /*Set CML globals to default values*/

/************Estimation Mixture and Hasbrouck shares************/
#include estimate.run;

/************Write Output************/
estimates=id $+ "_estresults"; /*Estimation results*/
load  estoutput = ^estimates;
hasb=((estoutput[18,2]+ estoutput[20,2])/2)*100; /*Hasbrouck shares*/
Psi=exp(estoutput[23:24,2])'; /*Psi1 Psi2*/
Wmatrix=exp(estoutput[26,2])|estoutput[27:28,2]|exp(estoutput[29,2]);/*W*/
gam=(estoutput[34,2]); /*Mixture prob*/
wald_pval=estoutput[31,3]; /* Psi1=Psi2 test p-value*/
info_cds=estoutput[32,2]*100; /* IS_T CDS*/
names= "psi_CDS"~"psi_BOND"~"mix_prob"~"w11"~"w12"~"w21"~"w22"~"waldpval"~"Haslow"~"Hasup"~"Hasmid"~"IS_T-CDS";
tab_par=psi~gam~Wmatrix'~wald_pval*100~estoutput[20,2]*100~estoutput[18,2]*100~hasb~info_cds;
"************************";
"Estimation Results";
"************************";
let mask=0 1 ;
printfmt(names'~tab_par',mask'); 

/* Comment out the stop if you also want to bootstrap */
/*stop;*/
/************Bootstrap Parameters and Information Shares************/
#include boot.run;

/************Calculate specification test and organize and show results************/
estimates=id $+ "_estresults"; /*Estimation results*/
load  estoutput = ^estimates;
hasb=((estoutput[18,2]+ estoutput[20,2])/2)*100; /*Hasbrouck shares*/
Psi=exp(estoutput[23:24,2])'; /*Psi1 Psi2*/
Wmatrix=exp(estoutput[26,2])|estoutput[27:28,2]|exp(estoutput[29,2]);/*W*/
gam=(estoutput[34,2]); /*Mixture prob*/
wald_pval=estoutput[31,3]; /*Psi1=Psi2 test p-value*/
info_cds=estoutput[32,2]*100; /*IS_T CDS*/
/*load bootstrapped parameters and Information shares*/
is_m="is_m" $+ id;
par="p_m" $+ id ;
is_h="is_h" $+ id ;
ksis="ksi" $+ id ;
var="vc" $+ id ;
load is_m= ^is_m;
load param= ^par;
load  is_h= ^is_h;
load   vc= ^var;
retcode=param[.,9]; /*select only those iterations with successful convergence*/
param=selif(param, retcode.==0);
is_m=selif(is_m, retcode.==0);
infostdc_m=stdc(is_m[.,2:3]); /*calculate standard deviation*/
paramstdc=stdc(param[.,2:8]);

/************ Specification test according to Equation (2.25) in "Tell-tale-tails"************/
/************Get estimated parameters************/
Psiest=diagrv(eye(2),exp(estoutput[23:24,2]))';
Wmat=reshape(exp(estoutput[26,2])|estoutput[27:28,2]|exp(estoutput[29,2]),2,2);
gam=(estoutput[34,2]);
varmix=Wmat*(gam*eye(2)+(1-gam)*psiest)*Wmat'; /*model implied cov(u)*/
varres=reshape(estoutput[48:51,2],2,2); /*estimated cov(u) from vecm residuals*/
/*Calculate test statstic*/
obs=rows(ci_series);
testlnest=obs*(ln(det(varmix))-ln(det(varres)));
/************Get distribution of test statistic from bootstrap************/
diffln={};
for r(1,rows(vc),1);  /*loop over bootstrap replictions*/
 sigma_u=reshape(vc[r,2:5],2,2); /*sigma_u=boostrapped VECM innovation variance*/
 psis=diagrv(eye(2), param[r,2:3]);
 W=reshape(param[r,4:7],2,2);
 p=param[r,8];
 sigma_w=W*(p*eye(2)+(1-p)*psis)*W'; /*sigma_w= variance from bootstrapped mnixture estimates*/
 testln=obs*(ln(det(sigma_w))-ln(det(sigma_u)));
 diffln=diffln|(testln);
endfor;
/************Calculate p-values************/
dat=sortc(diffln,1);
flagln1=meanc((dat[.,1] .ge testlnest));
flagln2=meanc((dat[.,1] .le testlnest));
pvalueln=2*minc(flagln1|flagln2);

/************Write Output************/
names= "psi_CDS"~"psi_BOND"~"mix_prob"~"w11"~"w12"~"w21"~"w22"~"waldpval"~"Lambdapv"~"Haslow"~"Hasup"~"Hasmid"~"IS_T-CDS";
tab_par=psi~gam~Wmatrix'~wald_pval*100~pvalueln*100~estoutput[20,2]*100~estoutput[18,2]*100~hasb~info_cds;
st_error=(paramstdc[ 1:2,1])'~paramstdc[7,1]~(paramstdc[3:6,1])'~-999~-999~-999~-999~-999~infostdc_m[1,1];

/************Print output************/
"************************";
"Estimation Results";
"************************";
tab1=names'~tab_par'~st_error';
let mask=0 1 1;
printfmt(tab1,mask'); 

/*Note: The bootstrap p-value for the Lambda-test statistic may differ slightly across GAUSS Versions. the one reported in
the paper is for GAUSS 6.043 64 bit for Linux. This is the output from the program run on that system

************************
Estimation Results
************************
 psi_CDS        22.850014        4.2756282 
psi_BOND        6.4393239        1.2043198 
mix_prob       0.68109913      0.034129986 
     w11        2.6544908       0.19195255 
     w12      -0.19944481       0.39353791 
     w21       0.76520006        0.3012286 
     w22        3.6553715       0.24326498 
waldpval       0.32706059             -999 
Lambdapv             91.5             -999 
  Haslow        52.288449             -999 
   Hasup         80.02756             -999 
  Hasmid        66.158004             -999 
IS_T-CDS        83.424117       0.16361401 

***********************************************/

