#include "RNNPBlib/RNNPB_CVOfflineTrainer.h"
#include "RNNPBlib/RNNPB_ApplicationInterface.h"
#include "RNNPBlib/RNNPB_NeuronLayer.h"
#include "RNNPBlib/RNNPB_AssemblyTools.h"
#include "RNNPBlib/RNNPB_Helper.h"
#include "RNNPBlib/RNNPB_Weight.h"
#include "RNNPBlib/RNNPB_NetworkContainer.h"
#include "RNNPBlib/RNNPB_TrainingData.h"

#include <vector>
#include <iostream>
#define _USE_MATH_DEFINES
#include <math.h>
#include <time.h>
#include <stdio.h>


using namespace std;


class TestApp : public RNNPB_ApplicationInterface
{
public:
	/*
	 * Writes input for NN into ret.
	 * */
	void get_nn_input(RNNPB_Vector* ret)
	{
		(*ret)[0]=get_app_input()[0];
	}

	/*
	 * Writes target value for NN into ret.
	 * */
	void get_nn_target(RNNPB_Vector* ret)
	{
		//double myiteration = get_app_input()[0];
		RNNPB_Vector myiteration(2);
		myiteration = get_app_input();

		switch(get_feedback_method())
		{
			case 0:
				(*ret)[0] = (cos(myiteration[0]*M_PI)+1.0)/2.0;
				(*ret)[1] = (cos(myiteration[1]*M_PI)+1.0)/3.0;
				break;
			case 1:
				(*ret)[0] = (sin(myiteration[0]*M_PI)+1.0)/2.0;
				(*ret)[1] = (sin(myiteration[1]*M_PI)+1.0)/3.0;
				break;
			case 2:
				(*ret)[0] = myiteration[0];
				(*ret)[1] = myiteration[1]*0.5;
				break;
			case 3:
				(*ret)[0] = myiteration[0]*2;
				(*ret)[1] = myiteration[1]*3;
				break;
			case 4:
				(*ret)[0] = max(min((myiteration[0]-0.5)*10000000.0,1.0),0.0);  //heaviside
				(*ret)[1] = max(min((myiteration[1]-0.5)*10000000.0,1.0),0.0);  //heaviside
				break;
			case 5:
				(*ret)[0] = myiteration[0]*3;
				(*ret)[1] = myiteration[1]*4;
				break;
		}
	}

public:
	TestApp
		(
				unsigned int nr_of_iterations,
				bool random_sampling,
				RNNPB_Vector set_min_iteration,
				RNNPB_Vector set_max_iteration
		) : RNNPB_ApplicationInterface(nr_of_iterations, random_sampling, set_min_iteration, set_max_iteration)
	{
	}
};


void testFunc(unsigned int nr_of_runs)
{
	srand(42);

	vector <RNNPB_NeuronLayer*> pb;

	/*
	 * Subnetwork modulated topology
	 */
	RNNPB_NeuronLayer in(1, Linear);

	RNNPB_NeuronLayer hidden1(10, Logistic);
	RNNPB_AssemblyTools::addBiasToLayer(&hidden1);

	RNNPB_NeuronLayer hidden2(10, Logistic);
	RNNPB_AssemblyTools::addBiasToLayer(&hidden2);

	RNNPB_NeuronLayer out(1, Linear);

	RNNPB_AssemblyTools::connectLayers(&in, &hidden1);
	RNNPB_AssemblyTools::connectLayers(&hidden1, &hidden2);

	RNNPB_NeuronLayer injection(hidden2.size()*out.size(), Linear);
	RNNPB_NeuronLayer expansion(20, Linear);

	RNNPB_AssemblyTools::connectLayersSecondorder(&hidden2, &out, &injection);
	RNNPB_AssemblyTools::connectLayers(&expansion, &injection);
	RNNPB_AssemblyTools::addParametricBiasToLayer(&expansion, &pb);

	/*
	 * Create network-container
	 * */
	RNNPB_NetworkContainer network(&in, &out, &pb);		//give output for network parsing and memory allocation

	/*
	 * Setup application and trainer
	 * */
	RNNPB_Vector max_iteration(2);
	RNNPB_Vector min_iteration(2);
	max_iteration[0]=1.0;
	max_iteration[1]=1.0;
	min_iteration[0]=0.0;
	min_iteration[1]=0.0;

	TestApp testApp(5, false, min_iteration, max_iteration);

	network.printNetwork();

	//Online generation of trainingdata:
	//RNNPB_CVTrainer trainer(&network, &testApp, 6);

	//Offline generation of trainingdata (a bit faster):
	RNNPB_CVOfflineTrainer trainer(&network, &testApp, 1000, 6);
	trainer.generateAllTrainingData(1);

	/*
	 * Learn, test
	 * */	

	trainer.trainNetwork(nr_of_runs, -1, 1000);

	trainer.testNetwork(1);				//one run, no training
}

int main(int argc, char** argv)
{
	#ifndef WIN32
	for(int i=1;i<argc;i++)
	{
		if(!strcmp(argv[i],"--test"))
		{
			testFunc(1000);
			return 0;
		}
	}
	#endif

	testFunc(8000);
	return 0;
}

