/**
 * Framework Parameters
 * 
 * Copyright 2013 Fabian Schrodt, FSchrodt@gmx.de
 * 
 * This file is part of RNNPBlib.
 * 
 * RNNPBlib is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
 * 
 * RNNPBlib is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with RNNPBlib. If not, see http://www.gnu.org/licenses/.
 */

#pragma once

////////////////// DEFINITIONS ///////////////////

/*
 * Runtime-affecting precompiler directives:
 * */

//#define ENABLE_DEBUG				// NN-warnings und errors
#define ENABLE_RUNTIME				// Runtime measurements
#define ENABLE_LOOKUP_TABLES			// Get activations and their derivations by lookup tables (recommended)
#define ENABLE_EXP_APPROX			// Use fast exp-approximation. Attention: Very imprecise
//#define ENABLE_SUBNET_TREE			// Builds a threadable neural network hierarchy (see documentation for more details). Subnet trees with threading may be profitable if there are 2 or more subnets. but mostly it is much slower, so this is rather experimental...
//#define ENABLE_EXPERIMENT			// Enable writing experimental data to files, readable by matlab

/*
 * Learning rates and similar stuff:
 * */

//#define ENABLE_BPTT				// Enable Enhanced Batch Backpropagation Through Time (for recurrent networks)

//#define ENABLE_ANNEALING			// Enable exponential annealing of learning rate by factor ANNEALING_FACTOR.
#define ENABLE_SEPARATE_ANNEALING		// Enable adaptation of learning rate per weight by weight-adaptation corridor (see documentation)

//Annealing parameters
#define ANNEALING_FACTOR 0.9999
#define MIN_WEIGHT_UPDATE 0.000015
#define MAX_WEIGHT_UPDATE 0.01

#define MIN_CV_UPDATE MIN_WEIGHT_UPDATE		// Minimum/maximum update for CV-elementy may differ from other min weight updates
#define MAX_CV_UPDATE MAX_WEIGHT_UPDATE

#define ENABLE_WEIGHT_DECAY			// Enable weight decay. Weight decay factor will be annealed by ANNEALING_FACTOR to avoid divergence!
#define WEIGHT_DECAY 0.001

//#define ENABLE_RESET_WEIGHT
#define RESET_WEIGHT 10				// Experimental: Reset weight if its absolute value exceeds RESET_WEIGHT

#define ENABLE_FLAT_SPOT_ELIM			// Enables flat spot elimination (must be used for quasi-linear/heaviside neurons)
#define MINIMUM_DIFFERENTIAL 0.05
//#define MINIMUM_DIFFERENTIAL (RNNPB_Helper::gaussianNoise(0.2))	// alternative that brings variance in weight-updates

#define DEFAULT_WEIGHT_LEARNING_RATE 0.1
#define DEFAULT_WEIGHT_MOMENTUM 0.4

#define DEFAULT_CV_LEARNING_RATE 0.1
#define DEFAULT_CV_MOMENTUM 0.4

#define MODULATION_UPDATE_RATE 0.95		// Portion the behaviorally local weight gets from the total weight update. (This allows to increase the learning rate a bit.)

/*
 * Initial parameters for weights and neurons:
 * */

#define DEFAULT_STEEPNESS 1.0
#define DEFAULT_SIGMOID_STEEPNESS 1.5
#define DEFAULT_TANH_STEEPNESS 0.75
#define DEFAULT_GAUSSIAN_STEEPNESS 2.0						// equals 1/sigma
#define DEFAULT_RADIAL_LINEAR_STEEPNESS 2.0					// equals 1/radius


#define DEFAULT_INIT_WEIGHT (0.0 + RNNPB_Helper::gaussianNoise(0.2))

//#define DEFAULT_INIT_RBFCENTER (0.5 + RNNPB_Helper::uniformNoise(0.5))	// optimized for input space in [0,1]
#define DEFAULT_INIT_RBFCENTER (0.0 + RNNPB_Helper::uniformNoise(0.2))		// optimized for input space in [-0.2,0.2]

#define DEFAULT_INIT_BIAS_CV (0.1)						// all CV elements should be initialized with the same value for comparability

#define DEFAULT_INIT_SECONDORDER_CV (0.1)					// again for comparability
//#define DEFAULT_INIT_SECONDORDER_CV DEFAULT_INIT_RBFCENTER			// for SO-RBF-centers

#define DEFAULT_INIT_MODULATION_CV (0.1)					// again for comparability
//#define DEFAULT_INIT_MODULATION_CV DEFAULT_INIT_RBFCENTER			// for modulated RBF-centers

