/**
 * Helper for writing data to files (Implementation)
 * 
 * Copyright 2013 Fabian Schrodt, FSchrodt@gmx.de
 * 
 * This file is part of RNNPBlib.
 * 
 * RNNPBlib is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
 * 
 * RNNPBlib is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with RNNPBlib. If not, see http://www.gnu.org/licenses/.
 */

#include "RNNPB_MatlabWriter.h"
#include "RNNPB_Definitions.h"
#include "RNNPB_Vector.h"

using namespace std;

template <typename T> std::string to_string(T value)	//for stoopit win c++ (VC08)
{
	std::ostringstream os;
	os << value;
	return os.str();
}

//specialization for RNNPB-Vectors...
void RNNPB_MatlabWriter::write(stringstream& value_name, RNNPB_Vector* val)
{
	if(newOfstream(value_name))
		createOfstream(value_name);

	for(unsigned int i=0;i<val->size;i++)
	{
		char val_c[50]="";
		sprintf(val_c, "%f ", (*val)[i]);

		*(Filemap[value_name.str()]) << val_c;
	}

	*(Filemap[value_name.str()]) << endl;
}

template <typename T> void RNNPB_MatlabWriter::write(string value_name, T val)
{
	stringstream tmp;
	tmp<<value_name;
	write(tmp,val);
}

unsigned int RNNPB_MatlabWriter::get_run_nr()
{
	return atoi(run_nr.str().c_str());
}

string RNNPB_MatlabWriter::get_exp_name()
{
	return exp_name.str();
}

void RNNPB_MatlabWriter::createOfstream(stringstream& value_name)
{
	stringstream filename;
	filename << "matlab/" << exp_name.str() << "_" << value_name.str() << "_" << run_nr.str();

	Filemap[value_name.str()] = new ofstream(filename.str().c_str(), ios_base::app);
}

bool RNNPB_MatlabWriter::newOfstream(stringstream& value_name)
{
	if(Filemap[value_name.str()]==NULL)
	{
		return true;
	}
	return false;
}

RNNPB_MatlabWriter::RNNPB_MatlabWriter()
{
	//read config file:
	ifstream in ("matlab/exp.config");

	char stpdbuf[100];
	in >> stpdbuf;
	exp_name.str(stpdbuf);
	in >> stpdbuf;
	run_nr.str(stpdbuf);

	#ifdef WIN32
	_Longlong tmp=atoi(run_nr.str().c_str());	//microsofts c++ headers are buggy, so we have to use longlong here...
	#else
	int tmp=atoi(run_nr.str().c_str());
	#endif
	tmp++;

	//rewrite config file:
	ofstream out ("matlab/exp.config", ios_base::trunc);

	out<<exp_name.str()<<" "<<to_string(tmp)<<endl;

	in.close();
}

RNNPB_MatlabWriter::~RNNPB_MatlabWriter()
{
	for(std::map<string, ofstream*, cmp_str>::iterator i=Filemap.begin();i!=Filemap.end();i++)
		i->second->close();
}
