/**
 * Container for Neural Networks (Header)
 * 
 * Copyright 2013 Fabian Schrodt, FSchrodt@gmx.de
 * 
 * This file is part of RNNPBlib.
 * 
 * RNNPBlib is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
 * 
 * RNNPBlib is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with RNNPBlib. If not, see http://www.gnu.org/licenses/.
 */

#pragma once

#include <pthread.h>

#include "RNNPB_Definitions.h"

#include "RNNPB_LUT.h"
#include "RNNPB_NeuronLayer.h"
#include "RNNPB_Weight.h"

#include "RNNPB_ThreadedFunction.h"

class RNNPB_NeuronLayer;

class RNNPB_NetworkContainer
{
	friend class RNNPB_Neuron;
	friend class RNNPB_NeuronLayer;
	friend class RNNPB_CVTrainer;
	friend class RNNPB_CVOfflineTrainer;

	//activation buffers
	double* memorya;
	//activation differential buffers
	double* memoryb;
	//delta error buffers
	double* memoryc;

protected:

	RNNPB_NeuronLayer* input;
	RNNPB_NeuronLayer* output;
	vector <RNNPB_NeuronLayer*>* concept_layers;

	vector <RNNPB_Neuron*> neurons;
	vector <RNNPB_Neuron*> inverseNeurons;

	vector <RNNPB_Weight*> weights;

	unsigned int weightSize();

	void allocateMemory();

	void deallocateMemory();

	#ifdef ENABLE_LOOKUP_TABLES
	RNNPB_LUT lut;	//TODO: Only one LUT for all subnets...
	#endif

public:

	//Threadable hierarchy of subnetworks
	vector <RNNPB_NetworkContainer*> subnets;

	void setWeightsConstant(bool set);

	//void iterate();
	struct Iterate : public RNNPB_ThreadedFunction<void*, RNNPB_NetworkContainer>
	{
		void* func();
	} iterate;

	//void clear();
	struct Clear : public RNNPB_ThreadedFunction<void*, RNNPB_NetworkContainer>
	{
		void* func();
	} clear;

	//void cumulateWeightUpdates();
	struct CumulateWeightUpdates : public RNNPB_ThreadedFunction<void*, RNNPB_NetworkContainer>
	{
		void* func();
	} cumulateWeightUpdates;

	//void learnWeights();
	struct LearnWeights : public RNNPB_ThreadedFunction<void*, RNNPB_NetworkContainer>
	{
		void* func();
	} learnWeights;


	void registerNeuron(RNNPB_Neuron* add_neuron, int run);

	void registerWeight(RNNPB_Weight* add_weight);

	void registerSubnet(RNNPB_NetworkContainer* add_subnet);


	void printNetwork();

	RNNPB_NetworkContainer(RNNPB_NeuronLayer* set_input, RNNPB_NeuronLayer* set_output, vector <RNNPB_NeuronLayer*>* set_concept_layers);

	~RNNPB_NetworkContainer();
};



