/**
 * Interface for classes that transmit simulation commands via piping. (Header+Implementation)
 * 
 * Copyright 2013 Fabian Schrodt, FSchrodt@gmx.de
 * 
 * This file is part of SimulationManager.
 * 
 * SimulationManager is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
 * 
 * SimulationManager is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with SimulationManager. If not, see http://www.gnu.org/licenses/.
 */

#pragma once

#include "PipeRW.h"

#include <iostream>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

using namespace std;


class PipeClient : public PipeRW
{
	virtual void applyCommand() = 0;

public:

	void run()
	{
		while(1)
		{
			readDataToBuffer();
			applyCommand();
		}
	}

	PipeClient(unsigned int set_buffersize, char* output_pipename, char* input_pipename) : PipeRW(set_buffersize)
	{
		/*We open the fifo for writing*/
		if((output_fifo = fopen(output_pipename, "r+b")) == NULL)
		{
			fprintf(stderr, "Can't open the output pipe.....\n");
			exit(0);
		}

		/*We open the fifo for reading*/
		if((input_fifo = fopen(input_pipename, "r+b")) == NULL)
		{
			fprintf(stderr, "Can't open the input pipe.....\n");
			exit(0);
		}
	}
};
