/**
 * Function class for basic pipe operations (Header+Implementation)
 * 
 * Copyright 2013 Fabian Schrodt, FSchrodt@gmx.de
 * 
 * This file is part of SimulationManager.
 * 
 * SimulationManager is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License version 3 as published by the Free Software Foundation.
 * 
 * SimulationManager is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with SimulationManager. If not, see http://www.gnu.org/licenses/.
 */

#pragma once

#include <iostream>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>

using namespace std;

class PipeRW
{
protected:

	unsigned char* readbuffer;

	unsigned int buffersize;

	FILE* output_fifo; /*handle for output FIFO*/
	FILE* input_fifo; /*handle for input FIFO*/

	void flushWriteBuffer()
	{
		fflush(output_fifo);
	}

	/*
	 * gets data from FIFO-pipe
	 * returns bytesize of data read
	 **/
	unsigned int readDataToBuffer()
	{
		unsigned int datalength;
		fread((void*) &datalength, sizeof(unsigned int), 1, input_fifo);

		fread(readbuffer, sizeof(unsigned char), datalength, input_fifo);

		//append 0 terminator (not really necessary)
		readbuffer[datalength]=0;

		//cout<<"READ DATA OF LENGTH "<<datalength<<": '"<<readbuffer<<"'"<<endl;

		return datalength;
	}

	void writeData(unsigned char* data, unsigned int datalength)
	{
		unsigned int byteswritten = fwrite((void*) &datalength, sizeof(unsigned int), 1, output_fifo);
		byteswritten += fwrite(data, sizeof(unsigned char), datalength, output_fifo);

		//cout<<"WROTE "<<byteswritten<<" BYTES TO PIPE. DATA IS OF LENGTH "<<datalength<<": '"<<data<<"'"<<endl;
	}

public:
	PipeRW(unsigned int set_buffersize)
	{
		//set readbuffer:
		buffersize=set_buffersize;
		readbuffer = (unsigned char*) malloc(buffersize);

		//set writebuffer:
		//set buffersize: for a command to be written atomic the writebuffer must exceed the maximum length of actor-data
		//since data written has the same type as data read we can use set_buffersize for both buffers
		//TODO: account for different sensor/actor types
		//TODO: init after pipe is opened		
		//setbuf(output_fifo, new char[sizeof(unsigned int)*2+set_buffersize+sizeof(int)+10]);	//+space for command- and length-info
	}

	~PipeRW()
	{
		delete[] readbuffer;
	}
};
