/*
 * Decompiled with CFR 0.152.
 */
package chip;

import java.io.BufferedWriter;
import java.io.FileWriter;

public class RumSamplerSaver
extends Thread {
    protected boolean finalized = false;
    protected String filePrefix;
    protected long sleepMillis;
    protected long increment = 0L;
    protected int[][] object;
    protected String[] rowNames;

    @Override
    public void run() {
        while (!this.finalized) {
            try {
                Thread.sleep(this.sleepMillis);
                this.save(String.valueOf(this.filePrefix) + ++this.increment);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        System.out.println("Fertig");
    }

    protected void save(String filename) throws Exception {
        System.out.println("Saving: " + filename);
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        System.out.println(String.valueOf(this.rowNames.length) + " rows");
        int row = 0;
        while (row != this.rowNames.length) {
            bw.write(this.rowNames[row]);
            int col = 0;
            while (col != this.object[row].length) {
                bw.write("\t" + this.object[row][col]);
                ++col;
            }
            bw.write("\n");
            ++row;
        }
        bw.flush();
        bw.close();
        System.out.println("done saving");
    }

    public RumSamplerSaver(String filePrefix, long sleepTimeSeconds, int[][] objectToSave, String[] rownames) {
        final Thread mainThread = Thread.currentThread();
        this.filePrefix = filePrefix;
        this.sleepMillis = sleepTimeSeconds * 1000L;
        this.object = objectToSave;
        this.rowNames = rownames;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RumSamplerSaver.this.finalized = true;
                System.out.println("Shutdown hook");
                RumSamplerSaver.this.stop(new RuntimeException("DIE!"));
                try {
                    RumSamplerSaver.this.save(String.valueOf(RumSamplerSaver.this.filePrefix) + "final");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("Saved.");
                System.out.println("Killing main?");
                mainThread.stop(new RuntimeException("DIE!"));
            }
        });
    }
}

