/*
 * Decompiled with CFR 0.152.
 */
package countnornac;

import efault.Config;
import efault.Main;
import genomic.Gene;
import genomic.NCRNA;
import genomic.NCRNATranscript;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

public class CountNoRNAcStarter {
    File countnornacNCRNAFile = new File(String.valueOf(Main.genomeDir.getAbsolutePath()) + "/ncrnas.tmp");
    File countnornacGeneFile = new File(String.valueOf(Main.genomeDir.getAbsolutePath()) + "/genes.tmp");
    File countnornacRProfile = new File(String.valueOf(Main.genomeDir.getAbsolutePath()) + "/rprofile.tmp");
    File countnornacTUFile = new File(String.valueOf(Main.genomeDir.getAbsolutePath()) + "/tus.tmp");
    File countnornacGenomeFile = new File(Main.genomeDir.getAbsoluteFile() + "/genome.tmp");
    File interProfileFile;

    public CountNoRNAcStarter() {
        this.countnornacNCRNAFile.deleteOnExit();
        this.countnornacGeneFile.deleteOnExit();
        this.countnornacRProfile.deleteOnExit();
        this.countnornacTUFile.deleteOnExit();
        this.countnornacGenomeFile.deleteOnExit();
    }

    public void start() throws Exception {
        System.out.println("Initializing interactive countNoRNAc R shell...");
        System.out.println("Preparing data...");
        this.writeDataTMPs();
        this.writeStartSkript();
        System.out.println("countNoRNAc is running");
        this.startBash();
        System.out.println("countNoRNAc has been terminated");
    }

    private void startBash() throws Exception {
        ProcessBuilder bashBuilder = new ProcessBuilder("xterm", "-T", "countNoRNAc", "-e", "R", "-q", "--no-init-file");
        bashBuilder.environment().put("R_PROFILE", this.countnornacRProfile.getAbsolutePath());
        Process bashP = bashBuilder.start();
        bashP.waitFor();
    }

    private void writeDataTMPs() throws Exception {
        char[] gchars;
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.countnornacNCRNAFile));
        for (NCRNA nc : Main.ncRNAs) {
            bw.write(String.valueOf(nc.toCountNoRNAcString()) + "\n");
        }
        bw.close();
        bw = new BufferedWriter(new FileWriter(this.countnornacGeneFile));
        for (Gene g : Main.genes) {
            bw.write(String.valueOf(g.toString()) + "\n");
        }
        bw.close();
        bw = new BufferedWriter(new FileWriter(this.countnornacTUFile));
        for (NCRNA nc : Main.ncRNAs) {
            for (NCRNATranscript tu : nc.getPredictedNCRNATranscripts()) {
                bw.write(String.valueOf(tu.toString()) + "\n");
            }
        }
        bw.close();
        bw = new BufferedWriter(new FileWriter(this.countnornacGenomeFile));
        char[] cArray = gchars = Main.genome.getSequence().getSequenceString().toCharArray();
        int n = gchars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            bw.write(String.valueOf(c) + "\n");
            ++n2;
        }
        bw.close();
    }

    private void writeStartSkript() throws Exception {
        String script = "setwd(\"" + Main.genomeDir.getAbsolutePath() + "\");\n" + "library(\"utils\");\n" + "cat(\"Accessing data, please wait...\");\n" + "usage <<- list();\n" + "add.usage <- function(name,text) {usage[[name]] <<- text; class(usage[[name]])<<-\"usage.note\";}\n" + "print.usage.note <- function(s) cat(s)\n" + "#terminators <<- NULL;\n" + "if(file.exists(\"" + Main.terminatorsFile.getAbsolutePath() + "\"))\n" + "terminators <<- read.table(\"" + Main.terminatorsFile.getAbsolutePath() + "\",row.names=1,col.names=c(\"ID\",\"start\",\"end\",\"strand\",\"score\",\"n.a.\"),stringsAsFactors=FALSE);\n" + "add.usage(\"terminators\", \"Table containing information about all predicted terminator signals.\\nThe rownames are the IDs of the terminators.\\nThe table consists of the columns 'start', 'end', 'strand', 'score',\\nwhere 'score' is the confidence value of the terminator.\");\n" + "#sidd.sites <<- NULL;\n" + "if(file.exists(\"" + Main.siddSitesFile.getAbsolutePath() + "\"))\n" + "sidd.sites <<- read.table(\"" + Main.siddSitesFile.getAbsolutePath() + "\",row.names=1,col.names=c(\"ID\",\"start\",\"end\",\"strand\",\"score\",\"n.a.\"),stringsAsFactors=FALSE);\n" + "add.usage(\"sidd.sites\", \"Table containing information about all predicted SIDD sites.\\nThe rownames are the IDs of the SIDD sites.\\nThe table consists of the columns 'start', 'end', 'strand', 'score',\\nwhere 'score' is the minimum free energy value of the SIDD site.\");\n" + "#genes <<- NULL;\n" + "if(file.exists(\"" + this.countnornacGeneFile.getAbsolutePath() + "\"))\n" + "genes <<- read.table(\"" + this.countnornacGeneFile.getAbsolutePath() + "\",row.names=1,col.names=c(\"ID\",\"start\",\"end\",\"strand\"),stringsAsFactors=FALSE);\n" + "add.usage(\"genes\", \"Table containing information about all annotated genes.\\nThe rownames are the IDs of the genes.\\nThe table consists of the columns 'start', 'end', 'strand'.\");\n" + "#nc.transcripts <<- NULL;\n" + "if(file.exists(\"" + this.countnornacTUFile.getAbsolutePath() + "\"))\n" + "nc.transcripts <<- read.table(\"" + this.countnornacTUFile.getAbsolutePath() + "\",row.names=1,col.names=c(\"ID\",\"ncrna\",\"start\",\"end\",\"strand\",\"sidd.site\",\"terminator\",\"genes\",\"antisense\"),stringsAsFactors=FALSE);\n" + "add.usage(\"nc.transcripts\", \"Table containing information about all predicted ncRNA transcripts.\\nThe rownames are the IDs of the elements.\\nThe table consists of the columns 'start', 'end', 'strand',\\n'sidd.site' (ID of the SIDD site), 'terminator' (ID of the terminator),\\n'genes' (list of overlapping genes), 'antisense' ('true' if antisense to a gene).\");\n" + "#pc.matches <<- NULL;\n" + "if(file.exists(\"" + Main.pcMatchesFile.getAbsolutePath() + "\"))\n" + "pc.matches <<- read.table(\"" + Main.pcMatchesFile.getAbsolutePath() + "\",row.names=1,col.names=c(\"ID\",\"start\",\"end\",\"strand\",\"trans.fac\",\"n.a.\"),stringsAsFactors=FALSE);\n" + "add.usage(\"pc.matches\", \"Table containing information about all predicted TF binding sites.\\nThe rownames are the IDs of the elements.\\nThe table consists of the columns 'start', 'end', 'strand',\\n'trans.fac' (ID of transcription/sigma factor).\");\n" + "#rfam.hits <<- NULL;\n" + "if(file.exists(\"" + Main.rFamHitsFile.getAbsolutePath() + "\"))\n" + "rfam.hits <<- read.table(\"" + Main.rFamHitsFile.getAbsolutePath() + "\",row.names=NULL,col.names=c(\"ID\",\"source.prog\",\"nc.locus.id\",\"strand\",\"start\",\"end\",\"score\",\"e.value\"),stringsAsFactors=FALSE);\n" + "add.usage(\"genes\", \"Table containing information about all Rfam hits.\\nThe rownames are the IDs of the hits.\\nThe table consists of the columns 'ID' (Rfam-ID),\\n'source.prog' (program used to match the Rfam seeds),\\n'nc.locus.id' (ID of the ncRNA locus),\\n 'strand', 'start', 'end' (relative to the ncRNA locus),\\n'score', 'e.value' (score and E-value of the hit).\");\n" + "#sidd.profile <<- NULL;\n" + "if(file.exists(\"" + Main.siddProfileFile.getAbsolutePath() + "\"))\n" + "sidd.profile <<- read.table(\"" + Main.siddProfileFile.getAbsolutePath() + "\")[,1];\n" + "genome <<- paste(read.table(\"" + this.countnornacGenomeFile.getAbsolutePath() + "\",sep=\"$\",header=FALSE,stringsAsFactors=FALSE)[,1],sep=\"\",collapse=\"\");\n" + "#interactions <<- NULL;\n" + "if(file.exists(\"" + Main.interactionsFile.getAbsolutePath() + "\"))\n" + "interactions <<- read.table(\"" + Main.interactionsFile.getAbsolutePath() + "\",row.names=NULL,col.names=c(\"hunterID\",\"targetID\",\"hunterStart\",\"hunterEnd\",\"hunterStrand\",\"targetStart\",\"targetEnd\",\"targetStrand\",\"hunterED\",\"targetED\",\"hybridE\",\"energy\"),stringsAsFactors=FALSE);\n" + "#iProfileN <<- NULL;\n" + "if(file.exists(\"" + Main.profileNFile.getAbsolutePath() + "\")){\n" + "iProfileN <<- as.matrix(read.table(\"" + Main.profileNFile.getAbsolutePath() + "\",row.names=1,header=F,stringsAsFactors=FALSE));\n" + "(function(){ colnames(iProfileN) <<- seq_len(ncol(iProfileN)); })(); }\n" + "#iProfileP <<- NULL;\n" + "if(file.exists(\"" + Main.profilePFile.getAbsolutePath() + "\")){\n" + "iProfileP <<- as.matrix(read.table(\"" + Main.profilePFile.getAbsolutePath() + "\",row.names=1,header=F,stringsAsFactors=FALSE));\n" + "(function(){ colnames(iProfileP) <<- seq_len(ncol(iProfileP)); })(); }\n" + "#iProfilePnet <<- NULL;\n" + "if(file.exists(\"" + Main.profilePnetFile.getAbsolutePath() + "\")){\n" + "iProfilePnet <<- as.matrix(read.table(\"" + Main.profilePnetFile.getAbsolutePath() + "\",row.names=1,header=F,stringsAsFactors=FALSE));\n" + "(function(){ colnames(iProfilePnet) <<- seq_len(ncol(iProfilePnet)); })(); }\n" + "#iProfileG <<- NULL;\n" + "if(file.exists(\"" + Main.profileGFile.getAbsolutePath() + "\")){\n" + "iProfileG <<- as.matrix(read.table(\"" + Main.profileGFile.getAbsolutePath() + "\",row.names=1,header=F,stringsAsFactors=FALSE));\n" + "(function(){ colnames(iProfileG) <<- seq_len(ncol(iProfileG)); })(); }\n" + "#iMatrix <<- NULL;\n" + "if(file.exists(\"" + Main.iMatrixFile.getAbsolutePath() + "\"))\n" + "iMatrix <<- as.matrix(read.table(\"" + Main.iMatrixFile.getAbsolutePath() + "\",header=T,stringsAsFactors=FALSE));\n" + "scale.interaction.profile <- function(x,length.out=100)\n" + "{\n" + "\tx <- x[!is.na(x)];\n" + "\tlen <- length(x)/length.out;\n" + "\tidx <- sapply(seq_len(length.out-1),function(i) c(ceiling(i*len),floor((i+1)*len)));\n" + "\tidx <- cbind(c(1,floor(len)),idx);\n" + "\tidx <- apply(idx,2,function(pair) c(pair[1],max(pair[1],pair[2])));\n" + "\t\n" + "\tres <- apply(idx,2,function(ix) mean(x[ix[1]:ix[2]]));\n" + "\treturn(res);\n" + "}\n" + "\n" + "scale.interaction.profile.matrix <- function(m,length.out=100)\n" + "{\n" + "\tres <- apply(m,1,scale.interaction.profile,length.out);\n" + "\tres <- t(res);\n" + "\treturn(res);\n" + "}\n" + "read.ncRNA <- function(nc.line)\n" + "{\n" + "name <- as.character(nc.line[1]);\n" + "x <- as.numeric(nc.line[2]);\n" + "names(x) <- NULL;\n" + "ncRNAs[[name]]$start <<- x;\n" + "x <- as.numeric(nc.line[3]);\n" + "names(x) <- NULL;\n" + "ncRNAs[[name]]$end <<- x;\n" + "x <- nc.line[4];\n" + "names(x) <- NULL;\n" + "ncRNAs[[name]]$strand <<- x;\n" + "x <- as.numeric(nc.line[5]);\n" + "names(x) <- NULL;\n" + "ncRNAs[[name]]$score <<- x;\n" + "x <- nc.line[6];\n" + "names(x) <- NULL;\n" + "ncRNAs[[as.character(nc.line[1])]]$class <<- x;\n" + "x <- unlist(strsplit(nc.line[7],\";\"));\n" + "names(x) <- NULL;\n" + "ncRNAs[[name]]$genes <<- x;\n" + "x <- unlist(strsplit(nc.line[8],\";\"));\n" + "names(x) <- NULL;\n" + "ncRNAs[[name]]$terminators <<- x;\n" + "x <- unlist(strsplit(nc.line[9],\";\"));\n" + "names(x) <- NULL;\n" + "ncRNAs[[name]]$sidd.sites <<- x;\n" + "x <- unlist(strsplit(nc.line[10],\";\"));\n" + "names(x) <- NULL;\n" + "ncRNAs[[name]]$pc.matches <<- x;\n" + "x <- unlist(strsplit(nc.line[12],\";\"));\n" + "names(x) <- NULL;\n" + "ncRNAs[[name]]$pred.transcripts <<- x;\n" + "}\n" + "ncRNAs <<- list();\n" + "nc.tab <- read.table(\"" + this.countnornacNCRNAFile.getAbsolutePath() + "\",header=FALSE,stringsAsFactors=FALSE,sep=\"\\t\");\n" + "invisible(apply(nc.tab,1,read.ncRNA));\n" + "(function(){names(ncRNAs) <<- as.character(nc.tab[,1]);})()\n" + "cat(\"done\\n\");\n" + "if(require(Biostrings)==FALSE)" + "{cat(\"Biostrings package not found!\\nTo use sequence functions install Biostrings or Bioconductor:\\nsource(\\\"http://bioconductor.org/biocLite.R\\\")\\nbiocLite(\\\"Biostrings\\\")\\n\");\n" + "}else" + "{genome <<- DNAString(genome);}\n" + "getSequences <<- function(features,upstream=0,downstream=0){\n" + "seqs<-list();\n" + "#non-ncRNA feature\n" + "if(is.data.frame(features)){\n" + "seqs<-apply(features,1,function(f){if(f[\"strand\"]==\"-\"){up<-(downstream);down<-(upstream);}else{up<-upstream;down<-downstream;}\nseq<-DNAString(subXString(genome,as.numeric(f[\"start\"])-up,as.numeric(f[\"end\"])+down));if(f[\"strand\"]==\"-\")seq<-reverseComplement(seq);return(as.character(seq));});\n" + "}else{\n" + "seqs<-unlist(lapply(features,function(nc){if(nc$strand==\"-\"){up<-(downstream);down<-(upstream);}else{up<-upstream;down<-downstream;}\nseq<-DNAString(subXString(genome,as.numeric(nc$start)-up,as.numeric(nc$end)+down));if(nc$strand==\"-\")seq<-reverseComplement(seq);return(as.character(seq));}));\n" + "}\n" + "seqs<-DNAStringSet(seqs);\n" + "return(seqs);\n" + "};\n" + "if(require(scatterplot3d)==FALSE)" + "{cat(\"scatterplot3d package not found!\\nTo use iProfilePGplot function install scatterplot3d:\\ninstall.packages(\\\"scatterplot3d\\\")\\n\");}\n" + "iProfilePGplot <<- function(indexOrName){\n" + "if(is.numeric(indexOrName)) name <- rownames(iProfileP)[indexOrName]\n" + "else name <- indexOrName\n" + "profpos <- seq_len(length(iProfileP[indexOrName,!is.na(iProfileP[indexOrName,])]));\n" + "profP <- iProfileP[indexOrName,profpos];\n" + "profG <- iProfileG[indexOrName,profpos];\n" + "dplot <- scatterplot3d(profpos,profG,profP,type=\"h\",pch=\"\",highlight.3d=T,xlab=\"position[nt]\",ylab=\"iProfileG\",zlab=\"iProfileP\",main=name);\n" + "dplot$points3d(profpos,seq.int(0,0,length.out=length(profP)),profP,type=\"l\");\n" + "};\n" + "select.interactions <<- function(hunters=NULL, targets=NULL, energy.threshold=0)\n" + "{\n" + "\tif(is.null(hunters))\n" + "\t{\n" + "\t\thunters <- rep(T,nrow(interactions))\n" + "\t}\n" + "\telse\n" + "\t{\n" + "\t\thunters <- interactions[,\"hunterID\"] %in% hunters\n" + "\t}\n" + "\t\n" + "\tif(is.null(targets))\n" + "\t{\n" + "\t\ttargets <- rep(T,nrow(interactions))\n" + "\t}\n" + "\telse\n" + "\t{\n" + "\t\ttargets <- interactions[,\"targetID\"] %in% targets\n" + "\t}\n" + "\t\n" + "\tenergy <- interactions[,\"energy\"]<=energy.threshold\n" + "\t\n" + "\treturn( interactions[hunters & targets & energy,] )\n" + "};\n" + "intarna.settings <<- list(" + "window=" + Config.getInt("intarnaLengthSwitch") + "," + "seed.length=" + Config.getInt("intarnaSeedLength") + "," + "seed.mm=" + Config.getInt("intarnaSeedMM") + ");" + "intarna <<- function(hunter,target,use.window=T,full.output=F,hunter.upstream=0,hunter.downstream=0,target.upstream=0,target.downstream=0,sample.hunter=F,sample.target=F)\n" + "{\n" + "\thunter.is.seq <- class(hunter)[1] == \"DNAStringSet\"\n" + "\ttarget.is.seq <- class(target)[1] == \"DNAStringSet\"\n" + "\t\n" + "\thunter.seq <- hunter\n" + "\ttarget.seq <- target\n" + "\t\n" + "\tif(!hunter.is.seq)\n" + "\t{\n" + "\t\tif(hunter %in% rownames(nc.transcripts))\n" + "\t\t\thunter.seq <- getSequences(nc.transcripts[hunter,],upstream=hunter.upstream,downstream=hunter.downstream)\n" + "\t\tif(hunter %in% names(ncRNAs))\n" + "\t\t\thunter.seq <- getSequences(ncRNAs[[hunter]],upstream=hunter.upstream,downstream=hunter.downstream)\n" + "\t\tif(hunter %in% rownames(genes))\n" + "\t\t\thunter.seq <- getSequences(genes[hunter,],upstream=hunter.upstream,downstream=hunter.downstream)\n" + "\t}\n" + "\t\n" + "\tif(!target.is.seq)\n" + "\t{\n" + "\t\tif(target %in% rownames(nc.transcripts))\n" + "\t\t\ttarget.seq <- getSequences(nc.transcripts[target,],upstream=target.upstream,downstream=target.downstream)\n" + "\t\tif(target %in% names(ncRNAs))\n" + "\t\t\ttarget.seq <- getSequences(ncRNAs[[target]],upstream=target.upstream,downstream=target.downstream)\n" + "\t\tif(target %in% rownames(genes))\n" + "\t\t\ttarget.seq <- getSequences(genes[target,],upstream=target.upstream,downstream=target.downstream)\n" + "\t}\n" + "\t\n" + "\tif(sample.hunter)\n" + "\t{\n" + "\t\thunter.seq <- DNAStringSet(sample(hunter.seq[[1]]))\n" + "\t}\n" + "\t\n" + "\t\n" + "\tif(sample.target)\n" + "\t{\n" + "\t\ttarget.seq <- DNAStringSet(sample(target.seq[[1]]))\n" + "\t}\n" + "\t\n" + "\tcmd <- paste(\"IntaRNA\",\"-U\",\"-P\",\"-o\",\"-p\",intarna.settings$seed.length,\"-u\",intarna.settings$seed.mm)\n" + "\t\n" + "\tshort <- length(hunter.seq[[1]])<intarna.settings$window || length(target.seq[[1]])<intarna.settings$window\n" + "\tif(use.window && !short)\n" + "\t\tcmd <- paste(cmd,\"-w\",intarna.settings$window)\n" + "\t\n" + "\tcmd <- paste(cmd,target.seq,hunter.seq)\n" + "\t\n" + "\tres <- system(cmd,intern=T)\n" + "\t\n" + "\tret <- list()\n" + "\tl <- length(res)\n" + "\tret$full <- NA\n" + "\tif(full.output) ret$full <- res\n" + "\tret$hunter <- hunter\n" + "\tret$target <- target\n" + "\tret$pos.target <- clever.as.numeric(res[l-11])\n" + "\tret$pos.target.seed <- clever.as.numeric(res[l-10])\n" + "\tret$pos.hunter <- clever.as.numeric(res[l-8])\n" + "\tret$pos.hunter.seed <- clever.as.numeric(res[l-7])\n" + "\tret$energy <- clever.as.numeric(res[l-1])\n" + "\tif(length(ret$energy)==0) ret$energy<-0\n" + "\treturn(ret)\n" + "}\n" + "clever.as.numeric <<- function(string)\n" + "{\n" + "\tif(!is.character(string) || length(string)!=1)\n" + "\t\tstop(\"Input has to be a character vector of length 1.\n\")\n" + "\tnum <- c(\"-\",\"+\",\".\",\"0\",\"1\",\"2\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\",\"9\")\n" + "\tres <- strsplit(string,\"\")[[1]]\n" + "\tres[!sapply(res,function(ch)ch%in%num)] <- \" \"\n" + "\tsapply(which(res == \".\"), function(i) if(i==length(res) || res[i+1]==\" \") res[i]<<-\" \")\n" + "\tres <- paste(res,sep=\"\",collapse=\"\")\n" + "\tres <- strsplit(res,\"\\\\s+\")[[1]]\n" + "\tsuppressWarnings(res <- as.numeric(res))\n" + "\tres <- res[!is.na(res)]\n" + "\treturn(res)\n" + "}\n" + "feature.length <<- function(f) as.numeric(f[\"end\"])-as.numeric(f[\"start\"])+1\n" + "ls(.GlobalEnv);";
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.countnornacRProfile));
        bw.write(script);
        bw.close();
    }
}

