/*
 * Decompiled with CFR 0.152.
 */
package efault;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Config {
    private static String defaultConfigFile = "# nocoRNAc Config File; v1.23; 2011-12-06\n\n## most important parameters\n\ntranstermConfidenceCutoff = 70\nsiddEnergyCutoff = 4.0\ntermDownstreamRegionSize = 25\npcUpstreamRegionSize = 25\nsiddUpstreamRegionSize = 25\nminTranscriptLength = 30\nmaxTranscriptLength = 600\nnoSenseGeneOverlappingTranscripts = 1\n\n##\n\n## further parameters\n\ncommentChar = #\ndataPath = data/\ntranstermPath = progs/transterm\n\nsiddRelativeStart = 0\n\nerpinPath = progs/erpin\nerpinSourceName = erpin\n\ninfernalPath = progs/infernal\ncmsearchEValueCutoff = 0.01\ncmsearchSourceName = cmsearch\ncmsearchOnly = 1\n# 1: use Rfam TC cutoff for each seed 0: use GA cutoff instead\ncmsearchTCcutoff = 1\ncmsearchProkaryoticOnly = 1\n\nallowNonTerminatorTranscripts = 0\nnoTerminatorSelection = 0\nmergeOverlappingTranscripts = 1\nforceStrandSpecification = 1\ntranscriptPredictionIgnoreStrand = 0\n\nplotFlankingRegionSize = 200\n\nfilterForGFF = 1\n\n##intaRNA\nintarnaPath = progs/intarna\n\n#for longer ncRNAs or mRNAs a sliding window is used\nintarnaLengthSwitch = 150\n\n#If set to '1' and if the shortest target is shorter than 'intarnaLengthSwitch',\n#then 'intarnaLengthSwitch' will be set to the length of the shortest target.\n#If set to '0', targets shorter than 'intarnaLengthSwitch' are not processed.\nintarnaAdjustLengthSwitch = 1\n\n#min length of seed region\nintarnaSeedLength = 8\n\n#max number of mismatches in seed\nintarnaSeedMM = 1\n\n#max pairing distance of base pairs (will not be used, I think => L = window length)\n#intarnaL = 100\n\n#do not delete original output files\nintarnaPreserveOutput = 1\n\n#never mind\nintarnaStrandBracket = <\n\n##interaction network dot/gml export\n\n#determine thresholds automatically?...\nautoThres = 1\n#percentile-threshold for very good interaction energy\nveryGoodEnergyPerc = 0.5\n#percentile-threshold for very good interaction length\nveryGoodLengthPerc = 0.5\n#percentile-threshold for good interaction energy\ngoodEnergyPerc = 1.0\n#percentile-threshold for good interaction length\ngoodLengthPerc = 1.0\n\n#...or use the following fixed thresholds? (autoThres=0)\n#threshold for very good interaction energy\nveryGoodEnergyThres = -25.0\n#threshold for very good interaction length\nveryGoodLengthThres = 50\n#threshold for good interaction energy\ngoodEnergyThres = -20\n#threshold for good interaction length\ngoodLengthThres = 10\n\n#color of very good interaction energy edges (default = red)\nveryGoodEnergyCol = #C6241A\n#color of very good interaction length edges (default = blue)\nveryGoodLengthCol = #1410D0\n#color of good interaction energy and length edges (default = pinc)\ngoodEnergyAndLengthCol = #8B08B9\n#color of sense antisense pairs (default = black)\nsenseAntisenseCol = #000000\n\n\n##SIDD settings\n#default value for assumed superhelix density (sigma) [ ]\nDEFAULT_SUPERHELIX_DENSITY = -0.055\n\n#torsional stiffness (C) [kcal/rad^2]\nTORSIONAL_STIFFNESS = 1.910\n\n#constant factor of coefficient K = const* RT/N\nK_CONSTANT_PART = 2200.0\n\n#initial energy of a run separation (a) [kcal/mol]\nINIT_SEPARATION_ENERGY = 10.160\n\n#default value for absolute temperature (T) [K]\nDEFAULT_TEMPERATURE = 310\n\n#gas constant (R) [kcal/K*mol]\nGAS_CONSTANT = 0.001987206501\n\n#helical repeat (A) [bases/turn]\nHELICAL_REPEAT = 10.4\n\n#default value for enrgy threshold (theta) [kcal]\nDEFAULT_ENERGY_THRESHOLD = 11.000\n\n#default value for small window size (W) [bases]\nDEFAULT_SMALL_WINDOW_SIZE = 200\n\n#default big window size (N) [bases]\nDEFAULT_BIG_WINDOW_SIZE = 5000\n\n#default big window shift (d0) [bases]\nDEAFAULT_BIG_WINDOW_SHIFT = 500\n\n#thermodynamics [kcal/mol] 0.01 M NaCl Klump\nsiddG_AA = 0.271\nsiddG_TT = 0.271\nsiddG_AT = 0.079\nsiddG_TA = 0.079\nsiddG_CA = 0.754\nsiddG_TG = 0.754\nsiddG_GT = 0.754\nsiddG_AC = 0.754\nsiddG_CT = 0.641\nsiddG_AG = 0.641\nsiddG_GA = 0.641\nsiddG_TC = 0.641\nsiddG_CG = 1.586\nsiddG_GC = 1.586\nsiddG_GG = 1.108\nsiddG_CC = 1.108\n\n#old thermodynamics\nthermoG_AA = -1.00\nthermoG_TT = -1.00\nthermoG_AT = -0.88\nthermoG_TA = -0.58\nthermoG_CA = -1.45\nthermoG_TG = -1.45\nthermoG_GT = -1.44\nthermoG_AC = -1.44\nthermoG_CT = -1.28\nthermoG_AG = -1.28\nthermoG_GA = -1.30\nthermoG_TC = -1.30\nthermoG_CG = -2.17\nthermoG_GC = -2.24\nthermoG_GG = -1.84\nthermoG_CC = -1.84\n\nnonProkaryoticRfam = miRNA,snRNA,intron,IRES,RF00006,RF00008,RF00009,RF00024,RF00025,RF00030,RF00032,RF00036,RF00037,RF00061,RF00094,RF00100,RF00102,RF00109,RF00161,RF00163,RF00164,RF00165,RF00171,RF00172,RF00175,RF00176,RF00179,RF00180,RF00182,RF00183,RF00184,RF00185,RF00192,RF00193,RF00194,RF00196,RF00198,RF00199,RF00207,RF00214,RF00215,RF00220,RF00227,RF00232,RF00233,RF00252,RF00259,RF00260,RF00290,RF00362,RF00374,RF00375,RF00376,RF00384,RF00385,RF00386,RF00389,RF00390,RF00434,RF00436,RF00437,RF00453,RF00454,RF00459,RF00460,RF00463,RF00465,RF00467,RF00468,RF00469,RF00470,RF00480,RF00481,RF00485,RF00491,RF00496,RF00498,RF00499,RF00500,RF00501,RF00502,RF00510,RF00523,RF00524,RF00525,RF00550,RF00551,RF00617,RF00620,RF00621,RF00622,RF00626,RF00635,RF00636,RF01046,RF01047,RF01050,RF01052,RF01072,RF01073,RF01074,RF01075,RF01076,RF01077,RF01078,RF01079,RF01080,RF01081,RF01082,RF01083,RF01084,RF01085,RF01088,RF01090,RF01091,RF01092,RF01093,RF01094,RF01095,RF01096,RF01097,RF01098,RF01099,RF01100,RF01101,RF01102,RF01103,RF01104,RF01105,RF01106,RF01107,RF01108,RF01109,RF01110,RF01111,RF01112,RF01113,RF01114,RF01115,RF01313,RF01380,RF01381,RF01382,RF01383,RF01414,RF01415,RF01417,RF01418,RF01453,RF01454,RF01455";
    private static String configFileName = "config.conf";
    private static File configFile = new File(configFileName);
    private static Map<String, String> values = Config.readConfigFile();

    public static String getString(String name) {
        String value = values.get(name);
        if (value == null || value.length() == 0) {
            throw new RuntimeException("No value found for config file entry '" + name + "'. The config file seems to be corrupted.");
        }
        return value;
    }

    public static int getInt(String name) {
        String value = values.get(name);
        if (value != null) {
            int res = 0;
            try {
                res = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Invalid value ('" + value + "') for config file entry '" + name + "'. Integer expected! The config file seems to be corrupted.");
            }
            return res;
        }
        throw new RuntimeException("No value found for config file entry '" + name + "'. The config file seems to be corrupted.");
    }

    public static boolean getBoolean(String name) {
        String value = values.get(name);
        if (value != null) {
            int res = 0;
            try {
                res = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Invalid value ('" + value + "') for config file entry '" + name + "'. Integer (1 or 0) expected! The config file seems to be corrupted.");
            }
            if (res == 1) {
                return true;
            }
            if (res == 0) {
                return false;
            }
            throw new NumberFormatException("Invalid value ('" + value + "') for config file entry '" + name + "'. Integer (1 or 0) expected! The config file seems to be corrupted.");
        }
        throw new RuntimeException("No value found for config file entry '" + name + "'. The config file seems to be corrupted.");
    }

    public static double getDouble(String name) {
        String value = values.get(name);
        if (value != null) {
            double res = 0.0;
            try {
                res = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Invalid value ('" + value + "') for config file entry '" + name + "'. Double expected! The config file seems to be corrupted.");
            }
            return res;
        }
        throw new RuntimeException("No value found for config file entry '" + name + "'. The config file seems to be corrupted.");
    }

    public static char getChar(String name) {
        String value = values.get(name);
        if (value == null || value.length() == 0) {
            throw new RuntimeException("No value found for config file entry '" + name + "'. The config file seems to be corrupted.");
        }
        return value.charAt(0);
    }

    private static Map<String, String> readConfigFile() {
        if (!configFile.exists()) {
            System.out.println("No configuration file found! Creating configuration file with default values...");
            Config.writeConfigFile();
        }
        HashMap<String, String> res = new HashMap<String, String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(configFile));
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() != 0 && line.charAt(0) != '#') {
                    String[] nameValue = line.split("=");
                    String name = nameValue[0].trim();
                    String value = nameValue[1].trim();
                    res.put(name, value);
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            System.err.println("Something went wrong when reading the config file. If the problem persists, remove the broken config file and start nocoRNAc. A configuration file with default values will be created then.");
            e.printStackTrace();
        }
        return res;
    }

    private static void writeConfigFile() {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(configFile));
            bw.write(defaultConfigFile);
            bw.close();
        }
        catch (IOException e) {
            System.err.println("Cannot write configuration file!");
            e.printStackTrace();
        }
    }
}

