/*
 * Decompiled with CFR 0.152.
 */
package efault;

import countnornac.CountNoRNAcStarter;
import efault.Aux;
import efault.CommandLine;
import efault.Config;
import efault.NCRNAPlotter;
import genomic.AbstractSequenceFeature;
import genomic.Gene;
import genomic.Genome;
import genomic.NCRNA;
import genomic.NCRNAAnnotater;
import genomic.NCRNATableParser;
import genomic.NCRNATranscript;
import genomic.ProteinTableParser;
import genomic.SequenceFeatureTools;
import genomic.TUAnnotater;
import interact.GraphFileExporter;
import interact.IntaRNAParser;
import interact.IntarnaScanner;
import interact.InteractionMatrixBuilder;
import interact.InteractionProfiler;
import interact.TranskriptInteraction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import promoter.PCFinder;
import promoter.PCMatch;
import promoter.PCMatchClassifier;
import promoter.PCPattern;
import promoter.PCPatternParser;
import promoter.PCTableParser;
import rfam.CMSearchScanner;
import rfam.QueryParser;
import rfam.RfamHit;
import rfam.RfamHitIO;
import rfam.RfamSeed;
import rfam.RfamSeedParser;
import rfam.RfamTest;
import rfam.RfamTestParser;
import seq.DNASequence;
import seq.FASTAEntry;
import seq.FASTAParser;
import sidd.SIDDGenomeProfiler;
import sidd.SIDDProfileAnalyzer;
import sidd.SIDDProfileReader;
import sidd.SIDDSite;
import sidd.SIDDSiteClassifier;
import sidd.SIDDTableParser;
import term.TermTableParser;
import term.Terminator;
import term.TerminatorClassifier;
import term.TransTermParser;
import term.TransTermScanner;

public class Main {
    public static String version = "v1.23";
    public static String builddate = "built: 2011-12-06 08:25 UTC";
    public static int numCPUs;
    public static File dataDir;
    public static File genomeDir;
    public static Genome genome;
    public static File genomeFile;
    public static List<NCRNA> ncRNAs;
    public static List<Gene> genes;
    private static CommandLine comLine;
    private static final String siddProfileFileName = "siddProfile.out";
    public static File siddProfileFile;
    private static final String siddSitesFileName = "siddSites.out";
    public static File siddSitesFile;
    private static final String terminatorsFileName = "terminators.out";
    public static File terminatorsFile;
    private static final String rFamHitsFileName = "rfamhits.out";
    public static File rFamHitsFile;
    private static final String pcMatchesFileName = "pcMatches.out";
    public static File pcMatchesFile;
    private static final String interactionsFileName = "interactions.out";
    public static File interactionsFile;
    private static final String profileNFileName = "iProfileN.tsv";
    public static File profileNFile;
    private static final String profileGFileName = "iProfileG.tsv";
    public static File profileGFile;
    private static final String profilePFileName = "iProfileP.tsv";
    public static File profilePFile;
    private static final String profilePnetFileName = "iProfilePnet.tsv";
    public static File profilePnetFile;
    private static final String iMatrixFileName = "iMatrix.tsv";
    public static File iMatrixFile;

    public static void main(String[] args) {
        block81: {
            boolean debug = false;
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equalsIgnoreCase("-debug")) {
                    debug = true;
                }
                ++n2;
            }
            try {
                List<TranskriptInteraction> interactions;
                List<AbstractSequenceFeature> potentialHuntersAndTargets;
                String filename;
                long timeStart = System.currentTimeMillis();
                System.out.println("nocoRNAc " + version + " " + builddate);
                comLine = new CommandLine(args);
                numCPUs = 1;
                if (comLine.isSet(19)) {
                    try {
                        numCPUs = Integer.parseInt(comLine.getValue(19));
                    }
                    catch (Exception e) {
                        throw new Error(String.valueOf(comLine.getName(19)) + " has to be a positive integer.");
                    }
                }
                if (numCPUs < 1) {
                    throw new Error(String.valueOf(comLine.getName(19)) + " has to be a positive integer.");
                }
                if (args.length == 0) {
                    System.out.println("java [-Xmx1G] -jar nocoRNAc.jar [OPTIONS]");
                    System.out.println("Type 'java -jar nocoRNAc.jar -help' for a list of parameters.");
                    return;
                }
                if (comLine.isSet(8)) {
                    System.out.println("java [-Xmx1G] -jar nocoRNAc.jar [OPTIONS]");
                    System.out.println(comLine.toHelpString());
                    System.out.println("See the documentation for details.");
                    return;
                }
                if (comLine.isSet(7)) {
                    System.out.println("nocoRNAc " + version);
                    return;
                }
                if (!comLine.isSet(0)) {
                    throw new Error("No genome fasta file given!");
                }
                genes = !comLine.isSet(14) ? new LinkedList<Gene>() : ProteinTableParser.parseProteinTable(comLine.getValue(14));
                dataDir = new File(Config.getString("dataPath"));
                if (!dataDir.exists()) {
                    dataDir.mkdir();
                }
                FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader(comLine.getValue(0)))).get(0);
                genome = new Genome(genomeFasta.getID(), genomeFasta.getSequence());
                genomeFile = new File(comLine.getValue(0));
                genomeDir = comLine.isSet(30) ? new File(dataDir, comLine.getValue(30)) : new File(dataDir, Main.getCleanedGenomeName(genome.getID()));
                if (!genomeDir.exists()) {
                    genomeDir.mkdir();
                }
                if (!comLine.isSet(1)) {
                    System.err.println("No ncRNA loci given. Predicting transcripts in the whole genome.");
                    ncRNAs = new LinkedList<NCRNA>();
                    ncRNAs.add(new NCRNA(genome.getID(), genome.getStart(), genome.getEnd(), '.', 0.0));
                } else {
                    ncRNAs = NCRNATableParser.parseNCRNATable(comLine.getValue(1));
                }
                System.out.println("Genome directory: " + genomeDir.getAbsolutePath());
                siddProfileFile = new File(genomeDir, siddProfileFileName);
                siddSitesFile = new File(genomeDir, siddSitesFileName);
                terminatorsFile = new File(genomeDir, terminatorsFileName);
                pcMatchesFile = new File(genomeDir, pcMatchesFileName);
                rFamHitsFile = new File(genomeDir, rFamHitsFileName);
                interactionsFile = new File(genomeDir, interactionsFileName);
                profileNFile = new File(genomeDir, profileNFileName);
                profileGFile = new File(genomeDir, profileGFileName);
                profilePFile = new File(genomeDir, profilePFileName);
                profilePnetFile = new File(genomeDir, profilePnetFileName);
                iMatrixFile = new File(genomeDir, iMatrixFileName);
                if (comLine.isSet(28)) {
                    Aux.doStuff();
                }
                if (comLine.isSet(2)) {
                    System.out.println("Calculating SIDD profile...");
                    if (siddProfileFile.exists() && !comLine.isSet(11)) {
                        System.err.println("SIDD profile already exists for this genome. Set '" + comLine.getName(11) + "' to recompute.");
                    } else {
                        Main.siddGenomeProfiling(genome, siddProfileFile);
                    }
                }
                if (comLine.isSet(3)) {
                    System.out.println("Detecting SIDD sites...");
                    if (!siddProfileFile.exists()) {
                        throw new Error("No SIDD Profile found for this genome. Use '" + comLine.getName(2) + "' to calculate SIDD profile.");
                    }
                    if (siddSitesFile.exists() && !comLine.isSet(11)) {
                        System.err.println("SIDD sites already computed for this genome. Set '" + comLine.getName(11) + "' to recompute.");
                    } else {
                        Main.siddSites();
                    }
                }
                if (comLine.isSet(4)) {
                    System.out.println("Detecting terminator signals...");
                    if (terminatorsFile.exists() && !comLine.isSet(11)) {
                        System.err.println("Terminators already computed for this genome. Set '" + comLine.getName(11) + "' to recompute.");
                    } else {
                        Main.terminators(new File(comLine.getValue(0)));
                    }
                }
                if (comLine.isSet(34)) {
                    filename = comLine.getValue(34);
                    System.out.println("Importing TransTermHP output to genome folder...");
                    if (terminatorsFile.exists() && !comLine.isSet(11)) {
                        System.err.println("Terminators already computed for this genome. Set '" + comLine.getName(11) + "' to replace them.");
                    } else {
                        TransTermParser ttp = new TransTermParser(filename);
                        ttp.parse();
                        LinkedList<Terminator> linkedList = ttp.getTerminators();
                        SequenceFeatureTools.writeSequenceFeatures(linkedList, terminatorsFile.getAbsolutePath());
                        System.out.println("Result written to " + terminatorsFile.getAbsolutePath());
                    }
                }
                if (comLine.isSet(15)) {
                    System.out.println("Detecting sigma factor binding sites...");
                    if (pcMatchesFile.exists() && !comLine.isSet(11)) {
                        System.err.println("Sigma factor binding sites already computed for this genome. Set '" + comLine.getName(11) + "' to recompute.");
                    } else {
                        List<PCPattern> pcPatterns = PCPatternParser.parsePCPatterns(comLine.getValue(15));
                        Main.pcMatches(pcPatterns);
                    }
                }
                if (comLine.isSet(5) || comLine.isSet(10)) {
                    boolean bl;
                    System.out.println("Scanning for Rfam motifs...");
                    if (!comLine.isSet(12)) {
                        throw new Error("Rfam seed file required to perform Rfam scan. Use '" + comLine.getName(12) + "' to pass Rfam seed file.");
                    }
                    List<RfamSeed> seeds = RfamSeedParser.parseRfamSeeds(comLine.getValue(12));
                    String[] queries = new String[]{};
                    if (!comLine.isSet(10)) {
                        if (!comLine.isSet(5)) {
                            throw new Error("No Rfam queries passed to the program. Use '" + comLine.getName(5) + "' to pass queries. Use '" + comLine.getName(10) + "' to scan for all seeds.");
                        }
                        queries = QueryParser.parseQueries(new File(comLine.getValue(5)));
                    }
                    boolean bl2 = false;
                    if (comLine.isSet(13) && rFamHitsFile.exists()) {
                        bl = true;
                    }
                    if (rFamHitsFile.exists() && !comLine.isSet(11) && !bl) {
                        System.err.println("Rfam hits already computed for this genome. Set '" + comLine.getName(11) + "' to recompute or '" + comLine.getName(13) + "' to append new hits.");
                    } else {
                        Main.rFamScan(seeds, queries, bl);
                    }
                }
                if (comLine.isSet(20)) {
                    String[] stringArray2;
                    String query;
                    int n3;
                    int n4;
                    String[] stringArray3;
                    System.out.println("Predicting RNA-RNA interactions...");
                    if (!comLine.isSet(22) || !comLine.isSet(23)) {
                        throw new Error("Hunter and/or target IDs not provided! Use '" + comLine.getName(22) + "' and '" + comLine.getName(23) + "' to pass files containing lists of hunter and target IDs.");
                    }
                    String[] ids = new String[]{};
                    ids = QueryParser.parseQueries(new File(comLine.getValue(22)));
                    LinkedList<AbstractSequenceFeature> hunters = new LinkedList<AbstractSequenceFeature>();
                    for (AbstractSequenceFeature abstractSequenceFeature : ncRNAs) {
                        stringArray3 = ids;
                        n4 = ids.length;
                        n3 = 0;
                        while (n3 < n4) {
                            query = stringArray3[n3];
                            if (abstractSequenceFeature.getID().equalsIgnoreCase(query)) {
                                hunters.add(abstractSequenceFeature);
                            }
                            ++n3;
                        }
                    }
                    for (AbstractSequenceFeature abstractSequenceFeature : genes) {
                        stringArray3 = ids;
                        n4 = ids.length;
                        n3 = 0;
                        while (n3 < n4) {
                            query = stringArray3[n3];
                            if (abstractSequenceFeature.getID().equalsIgnoreCase(query)) {
                                hunters.add(abstractSequenceFeature);
                            }
                            ++n3;
                        }
                    }
                    ids = QueryParser.parseQueries(new File(comLine.getValue(23)));
                    LinkedList<AbstractSequenceFeature> linkedList = new LinkedList<AbstractSequenceFeature>();
                    for (AbstractSequenceFeature abstractSequenceFeature : ncRNAs) {
                        stringArray2 = ids;
                        int n5 = ids.length;
                        n4 = 0;
                        while (n4 < n5) {
                            String query2 = stringArray2[n4];
                            if (abstractSequenceFeature.getID().equalsIgnoreCase(query2)) {
                                linkedList.add(abstractSequenceFeature);
                            }
                            ++n4;
                        }
                    }
                    for (AbstractSequenceFeature abstractSequenceFeature : genes) {
                        stringArray2 = ids;
                        int n6 = ids.length;
                        n4 = 0;
                        while (n4 < n6) {
                            String query3 = stringArray2[n4];
                            if (abstractSequenceFeature.getID().equalsIgnoreCase(query3)) {
                                linkedList.add(abstractSequenceFeature);
                            }
                            ++n4;
                        }
                    }
                    boolean bl = comLine.isSet(21);
                    if (interactionsFile.exists() && !comLine.isSet(11) || bl) {
                        System.err.println("RNA-RNA interactions already computed for this genome. Set '" + comLine.getName(11) + "' to recompute or '" + comLine.getName(21) + "' to append new hits.");
                    } else {
                        Main.intarnaScan(hunters, linkedList, bl);
                    }
                }
                if (comLine.isSet(25)) {
                    filename = comLine.getValue(25);
                    System.out.println("Importing intaRNA output to genome folder...");
                    if (interactionsFile.exists() && !comLine.isSet(11) && !comLine.isSet(21)) {
                        System.err.println("Interaction predictions already exists for this genome. Set '" + comLine.getName(11) + "' to overwrite the results or '" + comLine.getName(21) + "' to append the imported interactions.");
                    } else {
                        List<AbstractSequenceFeature> potentialHuntersAndTargets2 = genes;
                        potentialHuntersAndTargets2.addAll(ncRNAs);
                        IntaRNAParser intaRNAParser = new IntaRNAParser(filename, potentialHuntersAndTargets2, potentialHuntersAndTargets2);
                        intaRNAParser.parseAndAnnotate();
                        List<TranskriptInteraction> list = intaRNAParser.getInteractions();
                        if (comLine.isSet(21) && interactionsFile.exists()) {
                            list.addAll(TranskriptInteraction.readTranscriptInteractions(potentialHuntersAndTargets2, interactionsFile));
                        }
                        TranskriptInteraction.writeTranscriptInteractions(list, interactionsFile.getAbsolutePath());
                        System.out.println("Result written to " + interactionsFile.getAbsolutePath());
                    }
                }
                if (comLine.isSet(24)) {
                    if (!interactionsFile.exists()) {
                        throw new Error("No interactions found in the genome folder. Predict interactions first.");
                    }
                    System.out.println("Creating DOT file...");
                    potentialHuntersAndTargets = genes;
                    potentialHuntersAndTargets.addAll(ncRNAs);
                    interactions = TranskriptInteraction.readTranscriptInteractions(potentialHuntersAndTargets, interactionsFile);
                    File file = new File(genomeDir, "interactions.dot");
                    GraphFileExporter.writeDotFile(interactions, file.getAbsolutePath());
                    System.out.println("Result written to " + file.getAbsolutePath());
                }
                if (comLine.isSet(26)) {
                    if (!interactionsFile.exists()) {
                        throw new Error("No interactions found in the genome folder. Predict interactions first.");
                    }
                    System.out.println("Creating GML file...");
                    potentialHuntersAndTargets = genes;
                    potentialHuntersAndTargets.addAll(ncRNAs);
                    interactions = TranskriptInteraction.readTranscriptInteractions(potentialHuntersAndTargets, interactionsFile);
                    File file = new File(genomeDir, "interactions.gml");
                    GraphFileExporter.writeGMLFile(interactions, file.getAbsolutePath());
                    System.out.println("Result written to " + file.getAbsolutePath());
                }
                if (comLine.isSet(31)) {
                    Main.compare2Annotation(comLine.getValue(31));
                }
                if (comLine.isSet(32) || comLine.isSet(33)) {
                    Main.calculateInteractionProfilesAndMatrix(comLine.isSet(32), comLine.isSet(33));
                }
                if (comLine.isSet(29)) {
                    Main.countNoRNAc();
                }
                if (comLine.isSet(6)) {
                    Main.gffOut(comLine.getValue(6));
                }
                if (comLine.isSet(18) || comLine.isSet(27)) {
                    if (!siddProfileFile.exists()) {
                        System.err.println("No SIDD Profile found. Cannot generate SIDD plots for ncRNA regions.");
                    } else {
                        File plotids;
                        String para;
                        if (comLine.isSet(18)) {
                            para = comLine.getValue(18);
                            if (para.equalsIgnoreCase("all")) {
                                Main.ncRNAPlots(null, true);
                            } else {
                                plotids = new File(para);
                                if (plotids.exists()) {
                                    Main.ncRNAPlots(QueryParser.parseQueries(plotids), true);
                                } else {
                                    Main.ncRNAPlots(para.split(","), true);
                                }
                            }
                        }
                        if (comLine.isSet(27)) {
                            para = comLine.getValue(27);
                            if (para.equalsIgnoreCase("all")) {
                                Main.ncRNAPlots(null, false);
                            } else {
                                plotids = new File(para);
                                if (plotids.exists()) {
                                    Main.ncRNAPlots(QueryParser.parseQueries(plotids), false);
                                } else {
                                    Main.ncRNAPlots(para.split(","), false);
                                }
                            }
                        }
                    }
                }
                double timeTaken = (double)(System.currentTimeMillis() - timeStart) / 1000.0;
                System.out.println("All done! " + timeTaken + " s");
            }
            catch (Throwable t) {
                System.err.println("An error occurred: ");
                System.err.println(t.toString());
                if (!debug) break block81;
                t.printStackTrace();
            }
        }
    }

    private static String getCleanedGenomeName(String dirtyName) {
        int maxLength = 31;
        StringBuffer res = new StringBuffer();
        dirtyName = dirtyName.trim().split("[\\s]+")[0];
        String[] cleanParts = dirtyName.split("[\\W]+");
        int i = 0;
        while (i < cleanParts.length - 1) {
            res.append(cleanParts[i]);
            res.append('_');
            ++i;
        }
        res.append(cleanParts[cleanParts.length - 1]);
        if (res.length() > maxLength) {
            res.setLength(maxLength);
        }
        return res.toString();
    }

    private static void siddGenomeProfiling(Genome genome, File output) throws Exception {
        SIDDGenomeProfiler genomeSIDD = new SIDDGenomeProfiler(genome);
        genomeSIDD.runProfiler();
        double[] Gx = genomeSIDD.getGx();
        System.out.println("Writing output to file...");
        BufferedWriter siddProfileW = new BufferedWriter(new FileWriter(output));
        int i = 0;
        while (i < Gx.length) {
            siddProfileW.append(String.valueOf(Math.rint(Gx[i] * 100.0) / 100.0) + "\n");
            ++i;
        }
        siddProfileW.close();
    }

    private static void siddSites() throws Exception {
        SIDDProfileReader spr = new SIDDProfileReader(siddProfileFile.getAbsolutePath(), genome.getLength());
        spr.readProfile();
        List<SIDDSite> sidds = SIDDProfileAnalyzer.extractSIDDSites(spr.getGx(), Config.getDouble("siddEnergyCutoff"));
        SequenceFeatureTools.writeSequenceFeatures(sidds, siddSitesFile.getAbsolutePath());
    }

    private static void terminators(File genomeFile) throws Exception {
        TransTermScanner transTerm = new TransTermScanner(genomeFile);
        transTerm.scan();
        List<Terminator> terms = transTerm.getTerminators();
        SequenceFeatureTools.writeSequenceFeatures(terms, terminatorsFile.getAbsolutePath());
    }

    private static void pcMatches(List<PCPattern> pcPatterns) throws Exception {
        PCFinder pcf = new PCFinder(genome, ncRNAs, pcPatterns);
        pcf.findConsensusMatches();
        SequenceFeatureTools.writeSequenceFeatures(pcf.getProms(), pcMatchesFile.getAbsolutePath());
    }

    private static void rFamScan(List<RfamSeed> seeds, String[] queries, boolean append) throws Exception {
        CMSearchScanner cmsearchS = new CMSearchScanner(seeds, genomeFile);
        cmsearchS.scan(queries);
        LinkedList<RfamHit> hits = new LinkedList<RfamHit>();
        if (append) {
            hits = RfamHitIO.readRfamHits(rFamHitsFile);
        }
        hits.addAll(cmsearchS.getHits());
        RfamHitIO.writeRfamHits(hits, rFamHitsFile);
    }

    private static void intarnaScan(List<AbstractSequenceFeature> hunters, List<AbstractSequenceFeature> targets, boolean append) throws Exception {
        IntarnaScanner iscanner = new IntarnaScanner(genome, targets, hunters);
        iscanner.scan();
        List<TranskriptInteraction> inters = new LinkedList<TranskriptInteraction>();
        if (append) {
            List<AbstractSequenceFeature> potentialHuntersAndTargets = genes;
            potentialHuntersAndTargets.addAll(ncRNAs);
            inters = TranskriptInteraction.readTranscriptInteractions(potentialHuntersAndTargets, interactionsFile);
        }
        inters.addAll(iscanner.getInteractions());
        TranskriptInteraction.writeTranscriptInteractions(inters, interactionsFile.getAbsolutePath());
    }

    private static void gffOut(String outfilename) throws Exception {
        List<NCRNATranscript> tus = Main.annotateClassifyPredict();
        List<Object> terms = new LinkedList();
        if (terminatorsFile.exists()) {
            terms = TermTableParser.parseTermTable(terminatorsFile.getAbsolutePath());
        }
        List<Object> sidds = new LinkedList();
        if (siddSitesFile.exists()) {
            sidds = SIDDTableParser.parseSIDDTable(siddSitesFile.getAbsolutePath());
        }
        List<Object> pcMatches = new LinkedList();
        if (pcMatchesFile.exists()) {
            pcMatches = PCTableParser.parseSIDDTable(pcMatchesFile.getAbsolutePath());
        }
        List<Object> rfamHits = new LinkedList();
        if (rFamHitsFile.exists()) {
            rfamHits = RfamHitIO.readRfamHits(rFamHitsFile);
        }
        int transtermConfidenceCutoff = Config.getInt("transtermConfidenceCutoff");
        double siddEnergyCutoff = Config.getDouble("siddEnergyCutoff");
        boolean filterForGFF = Config.getBoolean("filterForGFF");
        System.out.println("Writing results to GFF...");
        BufferedWriter bw = new BufferedWriter(new FileWriter(outfilename));
        bw.write("##gff-version 3");
        bw.newLine();
        bw.write("##source-version nocoRNAc " + version);
        bw.newLine();
        Date date = new Date();
        bw.write("##date " + date.toGMTString());
        bw.newLine();
        for (NCRNA nCRNA : ncRNAs) {
            bw.write(nCRNA.toGFFString());
            bw.newLine();
        }
        for (Gene gene : genes) {
            bw.write(gene.toGFFString());
            bw.newLine();
        }
        for (Terminator terminator : terms) {
            if (filterForGFF && terminator.getConfidence() < transtermConfidenceCutoff) continue;
            bw.write(terminator.toGFFString());
            bw.newLine();
        }
        for (SIDDSite sIDDSite : sidds) {
            if (filterForGFF && !(sIDDSite.getMinIncEnergy() <= siddEnergyCutoff)) continue;
            bw.write(sIDDSite.toGFFString());
            bw.newLine();
        }
        for (PCMatch pCMatch : pcMatches) {
            bw.write(pCMatch.toGFFString());
            bw.newLine();
        }
        for (RfamHit rfamHit : rfamHits) {
            bw.write(rfamHit.toGFFString());
            bw.newLine();
        }
        for (NCRNATranscript nCRNATranscript : tus) {
            bw.write(nCRNATranscript.toGFFString());
            bw.newLine();
        }
        bw.close();
        Main.statistics();
    }

    private static void statistics() throws Exception {
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        NCRNA currNCRNA = null;
        NCRNA prevNCRNA = null;
        int upsies = 0;
        int ncRNAsTotal = 0;
        int ncRNAsContTerms = 0;
        int ncRNAsContTermsShared = 0;
        int ncRNAsContSIDD = 0;
        int ncRNAsContSIDDShared = 0;
        int ncRNAsContPCM = 0;
        int ncRNAsContPCMShared = 0;
        int ncRNAsContTermsAndSIDD = 0;
        int ncRNAsContNothingButGene = 0;
        int ncRNAsOverGene = 0;
        int antisenseDueToTerm = 0;
        int antisenseDueToTermShared = 0;
        int antisenseDueToSIDD = 0;
        int antisenseDueToSIDDShared = 0;
        int antisenseDueToPCM = 0;
        int antisenseDueToPCMShared = 0;
        int antisenseDueToTermAndSIDD = 0;
        int antisenseDueToTermAndSIDDAndPCM = 0;
        block0: while (ncIt.hasNext()) {
            prevNCRNA = currNCRNA;
            currNCRNA = ncIt.next();
            if (prevNCRNA != null && currNCRNA != null && currNCRNA.numOverlappingBases(prevNCRNA) > 0) {
                ++upsies;
            }
            currNCRNA.classifyTermination();
            currNCRNA.classifySIDDSites();
            currNCRNA.classifyPCMatches();
            ++ncRNAsTotal;
            if (currNCRNA.numGenes() > 0) {
                ++ncRNAsOverGene;
            }
            if (currNCRNA.getTerminationClass() == 'T') {
                ++ncRNAsContTerms;
            }
            if (currNCRNA.getTerminationClass() == 't') {
                ++ncRNAsContTerms;
                ++ncRNAsContTermsShared;
            }
            if (currNCRNA.getTerminationClass() == 'A') {
                ++antisenseDueToTerm;
                ++ncRNAsContTerms;
            }
            if (currNCRNA.getTerminationClass() == 'a') {
                ++ncRNAsContTerms;
                ++ncRNAsContTermsShared;
                ++antisenseDueToTerm;
                ++antisenseDueToTermShared;
            }
            if (currNCRNA.getSiddClass() == 'S') {
                ++ncRNAsContSIDD;
            }
            if (currNCRNA.getSiddClass() == 's') {
                ++ncRNAsContSIDD;
                ++ncRNAsContSIDDShared;
            }
            if (currNCRNA.getSiddClass() == 'A') {
                ++antisenseDueToSIDD;
                ++ncRNAsContSIDD;
            }
            if (currNCRNA.getSiddClass() == 'a') {
                ++ncRNAsContSIDD;
                ++ncRNAsContSIDDShared;
                ++antisenseDueToSIDD;
                ++antisenseDueToSIDDShared;
            }
            if (currNCRNA.getPcClass() == 'P') {
                ++ncRNAsContPCM;
            }
            if (currNCRNA.getPcClass() == 'p') {
                ++ncRNAsContPCM;
                ++ncRNAsContPCMShared;
            }
            if (currNCRNA.getPcClass() == 'A') {
                ++antisenseDueToPCM;
                ++ncRNAsContPCM;
            }
            if (currNCRNA.getPcClass() == 'a') {
                ++ncRNAsContPCM;
                ++ncRNAsContPCMShared;
                ++antisenseDueToPCM;
                ++antisenseDueToPCMShared;
            }
            if (currNCRNA.getTerminationClass() != 'X' && currNCRNA.getTerminationClass() != 'G' && currNCRNA.getSiddClass() != 'X' && currNCRNA.getSiddClass() != 'G') {
                ++ncRNAsContTermsAndSIDD;
            }
            if (!(currNCRNA.getTerminationClass() != 'A' && currNCRNA.getTerminationClass() != 'a' || currNCRNA.getSiddClass() != 'A' && currNCRNA.getSiddClass() != 'a')) {
                ++antisenseDueToTermAndSIDD;
            }
            if (!(currNCRNA.getTerminationClass() != 'A' && currNCRNA.getTerminationClass() != 'a' || currNCRNA.getSiddClass() != 'A' && currNCRNA.getSiddClass() != 'a' || currNCRNA.getPcClass() != 'A' && currNCRNA.getPcClass() != 'a')) {
                ++antisenseDueToTermAndSIDDAndPCM;
            }
            if (currNCRNA.getGeneClass() == 'G' && currNCRNA.getTerminationClass() == 'X' && currNCRNA.getSiddClass() == 'X' && currNCRNA.getPcClass() == 'X') {
                ++ncRNAsContNothingButGene;
            }
            if (currNCRNA.getTerminationClass() != 'X') {
                currNCRNA.getSiddClass();
            }
            currNCRNA.getScore();
            if (currNCRNA.numGenes() != 1) continue;
            for (NCRNATranscript tu : currNCRNA.getPredictedNCRNATranscripts()) {
                if (tu.getStrand() != currNCRNA.getGenes().get(0).getStrand()) continue block0;
            }
        }
        int tusTotal = 0;
        int tusOverGene = 0;
        int tusAS = 0;
        LinkedList<NCRNATranscript> tus = new LinkedList<NCRNATranscript>();
        for (NCRNA nc : ncRNAs) {
            tus.addAll(nc.getPredictedNCRNATranscripts());
        }
        tusTotal = tus.size();
        for (NCRNATranscript tu : tus) {
            if (tu.numGenes() <= 0) continue;
            ++tusOverGene;
            if (tu.numASGenes() <= 0) continue;
            ++tusAS;
        }
        System.out.println();
        System.out.println("Statistics:");
        System.out.println(String.valueOf(ncRNAsTotal) + " ncRNA loci in total");
        System.out.println(String.valueOf(ncRNAsContTerms) + " ncRNA loci containing a terminator - " + ncRNAsContTermsShared + " shared");
        System.out.println(String.valueOf(ncRNAsContSIDD) + " ncRNA loci containing a SIDDSite - " + ncRNAsContSIDDShared + " shared");
        System.out.println(String.valueOf(ncRNAsContPCM) + " ncRNA loci containing a TFBS match - " + ncRNAsContPCMShared + " shared");
        System.out.println(String.valueOf(ncRNAsContTermsAndSIDD) + " ncRNA loci containing a terminator and a SIDDSite");
        System.out.println();
        System.out.println(String.valueOf(ncRNAsOverGene) + " ncRNA loci overlapping a protein coding gene");
        System.out.println(String.valueOf(antisenseDueToTerm) + " ncRNA loci antisense due to terminator - " + antisenseDueToTermShared + " shared");
        System.out.println(String.valueOf(antisenseDueToSIDD) + " ncRNA loci antisense due to SIDDSite - " + antisenseDueToSIDDShared + " shared");
        System.out.println(String.valueOf(antisenseDueToPCM) + " ncRNA loci antisense due to TFBS - " + antisenseDueToPCMShared + " shared");
        System.out.println(String.valueOf(antisenseDueToTermAndSIDD) + " ncRNA loci antisense due to terminator and SIDDSite");
        System.out.println(String.valueOf(antisenseDueToTermAndSIDDAndPCM) + " ncRNA loci antisense due to terminator and SIDDSite and TFBS");
        System.out.println(String.valueOf(ncRNAsContNothingButGene) + " gene overlapping ncRNA loci containing no features");
        System.out.println();
        System.out.println(String.valueOf(tusTotal) + " predicted ncRNA transcripts in total");
        System.out.println(String.valueOf(tusOverGene) + " predicted ncRNA transcripts overlapping a protein coding gene");
        System.out.println(String.valueOf(tusAS) + " predicted ncRNA transcripts antisense to a protein coding gene");
    }

    private static void compare2Annotation(String rfamgfffilename) throws Exception {
        int tmpOverlap;
        boolean halfoverlap;
        boolean covered;
        boolean overlap;
        List<NCRNATranscript> tUnits = Main.annotateClassifyPredict();
        System.out.println("Comparing predicted ncRNA loci and predicted ncRNA transcripts to annotation...");
        List<RfamTest> rfamTests = RfamTestParser.parseRfamTestsNew(rfamgfffilename);
        int overlapNC = 0;
        int halfoverlapNC = 0;
        int coveredNC = 0;
        int overlapTU = 0;
        int halfoverlapTU = 0;
        int coveredTU = 0;
        int fpNC = 0;
        int tpNC = 0;
        int fnNC = 0;
        int fpTU = 0;
        int tpTU = 0;
        int fnTU = 0;
        int tuStrandSpecifics = 0;
        Iterator<RfamTest> testIt = rfamTests.iterator();
        Iterator<NCRNA> ncIt = ncRNAs.iterator();
        HashSet<NCRNA> ncsWithRfamAnno = new HashSet<NCRNA>();
        HashSet<RfamTest> rfamsWithNC = new HashSet<RfamTest>();
        System.out.println("List of predicted ncRNA loci mapping to an annotation:");
        while (testIt.hasNext()) {
            RfamTest currRfam = testIt.next();
            overlap = false;
            covered = false;
            halfoverlap = false;
            for (NCRNA currNCRNA : ncRNAs) {
                tmpOverlap = currNCRNA.numOverlappingBases(currRfam);
                if (tmpOverlap > 0) {
                    overlap = true;
                    if ((double)tmpOverlap >= Math.min((double)currNCRNA.getLength() * 0.5, (double)currRfam.getLength() * 0.5)) {
                        halfoverlap = true;
                    }
                    ncsWithRfamAnno.add(currNCRNA);
                    rfamsWithNC.add(currRfam);
                    currNCRNA.addAnnotation(currRfam);
                    System.out.print(String.valueOf(currNCRNA.getID()) + " ");
                    tpNC += tmpOverlap;
                    fpNC += currNCRNA.getLength() - tmpOverlap;
                    fnNC += currRfam.getLength() - tmpOverlap;
                }
                if (currRfam.getStart() < currNCRNA.getStart() || currRfam.getEnd() > currNCRNA.getEnd()) continue;
                covered = true;
            }
            if (overlap) {
                ++overlapNC;
            }
            if (covered) {
                ++coveredNC;
            }
            if (halfoverlap) {
                ++halfoverlapNC;
            }
            if (overlap) {
                System.out.println("-> " + currRfam.getID());
            }
            if (overlap) continue;
            fnNC += currRfam.getLength();
        }
        System.out.println("List of predicted ncRNA transcripts mapping to an annotation:");
        for (RfamTest currRfam : rfamTests) {
            overlap = false;
            boolean strandUnspecificOverlap = false;
            covered = false;
            halfoverlap = false;
            char tmpStrand = '?';
            boolean tuStrandSpecific = true;
            Iterator<NCRNATranscript> tuIt = tUnits.iterator();
            Object outNC = null;
            while (tuIt.hasNext()) {
                NCRNATranscript currTU = tuIt.next();
                tmpOverlap = currTU.numOverlappingBases(currRfam);
                if (tmpOverlap > 0) {
                    if (tmpStrand == '?') {
                        tmpStrand = currTU.getStrand();
                    } else if (tmpStrand != currTU.getStrand()) {
                        tuStrandSpecific = false;
                    }
                    if (currTU.getStrand() != currRfam.getStrand()) {
                        System.out.print(String.valueOf(currTU.getID()) + "* ");
                        strandUnspecificOverlap = true;
                        continue;
                    }
                    overlap = true;
                    if ((double)tmpOverlap >= Math.min((double)currTU.getLength() * 0.5, (double)currRfam.getLength() * 0.5)) {
                        halfoverlap = true;
                    }
                    System.out.print(String.valueOf(currTU.getID()) + " ");
                    tpTU += tmpOverlap;
                    fpTU += currTU.getLength() - tmpOverlap;
                    fnTU += currRfam.getLength() - tmpOverlap;
                }
                if (currRfam.getStart() < currTU.getStart() || currRfam.getEnd() > currTU.getEnd()) continue;
                covered = true;
            }
            if (overlap) {
                ++overlapTU;
            }
            if (halfoverlap) {
                ++halfoverlapTU;
            }
            if (tuStrandSpecific && halfoverlap) {
                ++tuStrandSpecifics;
            }
            if (covered) {
                ++coveredTU;
            }
            if ((overlap || strandUnspecificOverlap) && !covered) {
                System.out.println("-> " + currRfam.getID());
            }
            if (overlap && covered) {
                System.out.println("-> " + currRfam.getID() + "*");
            }
            if (overlap) continue;
            fnTU += currRfam.getLength();
        }
        int intergenicNCsNoAnnoButWithSiddTerm = 0;
        for (NCRNA nc : ncRNAs) {
            if (ncsWithRfamAnno.contains(nc) || nc.numGenes() != 0 || nc.numTerminators() <= 0 || nc.numSIDDSites() <= 0) continue;
            ++intergenicNCsNoAnnoButWithSiddTerm;
        }
        int intergenicNCsNoAnno = 0;
        for (NCRNA nc : ncRNAs) {
            if (ncsWithRfamAnno.contains(nc) || nc.numGenes() != 0) continue;
            ++intergenicNCsNoAnno;
        }
        System.out.println("number of annotations: " + rfamTests.size());
        System.out.println("annotations overlapping a ncRNA locus: " + overlapNC);
        System.out.println("annotations covered by a ncRNA locus: " + coveredNC);
        System.out.println("annotations overlapping a predicted ncRNA transcript: " + overlapTU);
        System.out.println("annotations covered by a predicted ncRNA transcript: " + coveredTU);
    }

    /*
     * WARNING - void declaration
     */
    private static void calculateInteractionProfilesAndMatrix(boolean calcProfiles, boolean calcMatrix) throws Exception {
        int n;
        BufferedWriter bw;
        System.out.println("Interaction analysis...");
        if (!interactionsFile.exists()) {
            System.out.println("No interactions file found for current genome.");
            return;
        }
        System.out.println("\tReading and assigning interactions...");
        LinkedList<AbstractSequenceFeature> partners = new LinkedList<AbstractSequenceFeature>(ncRNAs);
        partners.addAll(genes);
        List<TranskriptInteraction> interactions = TranskriptInteraction.readTranscriptInteractions(partners, interactionsFile);
        if (calcProfiles) {
            double[] dArray;
            double[] tmpProfile;
            int i;
            int d;
            int n2;
            int[] nArray;
            int[] tmpProfileI;
            System.out.println("\tCalculating interaction profiles...");
            InteractionProfiler.profileInteractions(interactions);
            System.out.println("Writing interaction profiles to " + genomeDir.getAbsolutePath());
            int longestLength = 0;
            for (AbstractSequenceFeature sf : partners) {
                if (sf.getInteractionProfileG() == null) continue;
                longestLength = Math.max(longestLength, sf.getLength());
            }
            bw = new BufferedWriter(new FileWriter(profileNFile));
            for (AbstractSequenceFeature abstractSequenceFeature : genes) {
                tmpProfileI = abstractSequenceFeature.getInteractionProfileN();
                if (tmpProfileI == null) continue;
                bw.write(abstractSequenceFeature.getID());
                nArray = tmpProfileI;
                n = tmpProfileI.length;
                n2 = 0;
                while (n2 < n) {
                    d = nArray[n2];
                    bw.write("\t" + d);
                    ++n2;
                }
                i = 0;
                while (i < longestLength - abstractSequenceFeature.getLength()) {
                    bw.write("\tNA");
                    ++i;
                }
                bw.newLine();
            }
            for (AbstractSequenceFeature abstractSequenceFeature : ncRNAs) {
                tmpProfileI = abstractSequenceFeature.getInteractionProfileN();
                if (tmpProfileI == null) continue;
                bw.write(abstractSequenceFeature.getID());
                nArray = tmpProfileI;
                n = tmpProfileI.length;
                n2 = 0;
                while (n2 < n) {
                    d = nArray[n2];
                    bw.write("\t" + d);
                    ++n2;
                }
                i = 0;
                while (i < longestLength - abstractSequenceFeature.getLength()) {
                    bw.write("\tNA");
                    ++i;
                }
                bw.newLine();
            }
            bw.close();
            bw = new BufferedWriter(new FileWriter(profileGFile));
            for (AbstractSequenceFeature abstractSequenceFeature : genes) {
                tmpProfile = abstractSequenceFeature.getInteractionProfileG();
                if (tmpProfile == null) continue;
                bw.write(abstractSequenceFeature.getID());
                dArray = tmpProfile;
                int n3 = tmpProfile.length;
                n = 0;
                while (n < n3) {
                    double d2 = dArray[n];
                    bw.write("\t" + d2);
                    ++n;
                }
                i = 0;
                while (i < longestLength - abstractSequenceFeature.getLength()) {
                    bw.write("\tNA");
                    ++i;
                }
                bw.newLine();
            }
            for (AbstractSequenceFeature abstractSequenceFeature : ncRNAs) {
                tmpProfile = abstractSequenceFeature.getInteractionProfileG();
                if (tmpProfile == null) continue;
                bw.write(abstractSequenceFeature.getID());
                dArray = tmpProfile;
                int n4 = tmpProfile.length;
                n = 0;
                while (n < n4) {
                    double d3 = dArray[n];
                    bw.write("\t" + d3);
                    ++n;
                }
                i = 0;
                while (i < longestLength - abstractSequenceFeature.getLength()) {
                    bw.write("\tNA");
                    ++i;
                }
                bw.newLine();
            }
            bw.close();
            bw = new BufferedWriter(new FileWriter(profilePFile));
            for (AbstractSequenceFeature abstractSequenceFeature : genes) {
                tmpProfile = abstractSequenceFeature.getInteractionProfileZ();
                if (tmpProfile == null) continue;
                bw.write(abstractSequenceFeature.getID());
                dArray = tmpProfile;
                int n5 = tmpProfile.length;
                n = 0;
                while (n < n5) {
                    double d4 = dArray[n];
                    bw.write("\t" + d4);
                    ++n;
                }
                i = 0;
                while (i < longestLength - abstractSequenceFeature.getLength()) {
                    bw.write("\tNA");
                    ++i;
                }
                bw.newLine();
            }
            for (AbstractSequenceFeature abstractSequenceFeature : ncRNAs) {
                tmpProfile = abstractSequenceFeature.getInteractionProfileZ();
                if (tmpProfile == null) continue;
                bw.write(abstractSequenceFeature.getID());
                dArray = tmpProfile;
                int n6 = tmpProfile.length;
                n = 0;
                while (n < n6) {
                    double d5 = dArray[n];
                    bw.write("\t" + d5);
                    ++n;
                }
                i = 0;
                while (i < longestLength - abstractSequenceFeature.getLength()) {
                    bw.write("\tNA");
                    ++i;
                }
                bw.newLine();
            }
            bw.close();
            bw = new BufferedWriter(new FileWriter(profilePnetFile));
            for (AbstractSequenceFeature abstractSequenceFeature : genes) {
                tmpProfile = abstractSequenceFeature.getInteractionProfileZnet();
                if (tmpProfile == null) continue;
                bw.write(abstractSequenceFeature.getID());
                dArray = tmpProfile;
                int n7 = tmpProfile.length;
                n = 0;
                while (n < n7) {
                    double d6 = dArray[n];
                    bw.write("\t" + d6);
                    ++n;
                }
                i = 0;
                while (i < longestLength - abstractSequenceFeature.getLength()) {
                    bw.write("\tNA");
                    ++i;
                }
                bw.newLine();
            }
            for (AbstractSequenceFeature abstractSequenceFeature : ncRNAs) {
                tmpProfile = abstractSequenceFeature.getInteractionProfileZnet();
                if (tmpProfile == null) continue;
                bw.write(abstractSequenceFeature.getID());
                dArray = tmpProfile;
                int n8 = tmpProfile.length;
                n = 0;
                while (n < n8) {
                    double d7 = dArray[n];
                    bw.write("\t" + d7);
                    ++n;
                }
                i = 0;
                while (i < longestLength - abstractSequenceFeature.getLength()) {
                    bw.write("\tNA");
                    ++i;
                }
                bw.newLine();
            }
            bw.close();
        }
        if (calcMatrix) {
            void var8_30;
            System.out.println("\tCalculating interaction matrix...");
            InteractionMatrixBuilder imb = new InteractionMatrixBuilder(interactions);
            imb.buildMatrix();
            double[][] matrix = imb.getMatrix();
            String[] names = imb.getNames();
            System.out.println("Writing interaction matrix to " + genomeDir.getAbsolutePath());
            bw = new BufferedWriter(new FileWriter(iMatrixFile));
            bw.write("ID");
            String[] stringArray = names;
            int n9 = names.length;
            int n10 = 0;
            while (n10 < n9) {
                String string = stringArray[n10];
                bw.write("\t" + string);
                ++n10;
            }
            boolean bl = false;
            while (var8_30 < names.length) {
                bw.write("\n");
                bw.write(names[var8_30]);
                double[] dArray = matrix[var8_30];
                n = dArray.length;
                int n11 = 0;
                while (n11 < n) {
                    double d = dArray[n11];
                    bw.write("\t" + d);
                    ++n11;
                }
                ++var8_30;
            }
            bw.close();
        }
    }

    private static void countNoRNAc() throws Exception {
        Main.annotateClassifyPredict();
        CountNoRNAcStarter cnc = new CountNoRNAcStarter();
        cnc.start();
    }

    private static void ncRNAPlots(String[] IDs, boolean asPdf) throws Exception {
        Main.annotateClassifyPredict();
        System.out.println("Writing plots to: " + genomeDir.getAbsolutePath());
        NCRNAPlotter plotter = new NCRNAPlotter(asPdf);
        plotter.plotNCRNAs(IDs);
    }

    private static List<NCRNATranscript> annotateClassifyPredict() throws Exception {
        LinkedList<Terminator> terms = new LinkedList();
        if (terminatorsFile.exists()) {
            terms = TermTableParser.parseTermTable(terminatorsFile.getAbsolutePath());
        }
        LinkedList<SIDDSite> sidds = new LinkedList();
        if (siddSitesFile.exists()) {
            sidds = SIDDTableParser.parseSIDDTable(siddSitesFile.getAbsolutePath());
        }
        LinkedList<PCMatch> pcMatches = new LinkedList();
        if (pcMatchesFile.exists()) {
            pcMatches = PCTableParser.parseSIDDTable(pcMatchesFile.getAbsolutePath());
        }
        LinkedList<RfamHit> rfamHits = new LinkedList();
        if (rFamHitsFile.exists()) {
            rfamHits = RfamHitIO.readRfamHits(rFamHitsFile);
        }
        TerminatorClassifier termClass = new TerminatorClassifier(terms);
        termClass.classifyGeneContext(genes);
        SIDDSiteClassifier siddClass = new SIDDSiteClassifier(sidds);
        siddClass.classifyGeneContext(genes);
        PCMatchClassifier pcClass = new PCMatchClassifier(pcMatches);
        pcClass.classifyGeneContext(genes);
        NCRNAAnnotater ncAnno = new NCRNAAnnotater(ncRNAs);
        ncAnno.annotateWithGenes(genes);
        ncAnno.annotateWithTerminators(terms);
        ncAnno.annotateWithSIDDSites(sidds);
        ncAnno.annotateWithPCMatches(pcMatches);
        ncAnno.annotateWithRfamHits(rfamHits);
        Iterator<NCRNA> ncrnaIt = ncRNAs.iterator();
        System.out.println("Classifying ncRNA regions...");
        while (ncrnaIt.hasNext()) {
            NCRNA currNC = ncrnaIt.next();
            currNC.classifyTermination();
            currNC.classifySIDDSites();
            currNC.classifyPCMatches();
        }
        System.out.println("Predicting ncRNA transcripts...");
        LinkedList<NCRNATranscript> tus = new LinkedList<NCRNATranscript>();
        for (NCRNA nc : ncRNAs) {
            nc.predictNCRNATranscripts();
            tus.addAll(nc.getPredictedNCRNATranscripts());
        }
        new TUAnnotater(tus).annotateWithGenes(genes);
        return tus;
    }
}

