/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import efault.Config;
import genomic.ArrayProbe;
import genomic.Gene;
import genomic.NCRNA;
import java.util.Collections;
import java.util.List;
import promoter.PCMatch;
import rfam.RfamHit;
import sidd.SIDDSite;
import term.Terminator;

public class NCRNAAnnotater {
    private static final int termDownstreamRegionSize = Config.getInt("termDownstreamRegionSize");
    private static final int pcUpstreamRegionSize = Config.getInt("pcUpstreamRegionSize");
    private static final int siddUpstreamRegionSize = Config.getInt("siddUpstreamRegionSize");
    private static final int transtermConfidenceCutoff = Config.getInt("transtermConfidenceCutoff");
    private static final double siddEnergyCutoff = Config.getDouble("siddEnergyCutoff");
    private List<NCRNA> ncRNAs;

    public NCRNAAnnotater(List<NCRNA> ncRNAs) {
        this.ncRNAs = ncRNAs;
    }

    /*
     * Unable to fully structure code
     */
    public void annotateWithTerminators(List<Terminator> terms) {
        if (this.ncRNAs.size() == 0) {
            return;
        }
        ncRNAit = this.ncRNAs.listIterator();
        Collections.sort(this.ncRNAs);
        Collections.sort(terms);
        while (ncRNAit.hasNext()) {
            ncRNAit.next().clearTerminators();
        }
        ncRNAit = this.ncRNAs.listIterator();
        firstNCRNAtoCheck = 0;
        currNCRNA = ncRNAit.next();
        for (Terminator currTerm : terms) {
            block9: {
                if (currTerm.getConfidence() >= NCRNAAnnotater.transtermConfidenceCutoff) ** GOTO lbl19
                continue;
lbl-1000:
                // 1 sources

                {
                    if (!ncRNAit.hasNext()) {
                        return;
                    }
                    ++firstNCRNAtoCheck;
                    currNCRNA = ncRNAit.next();
lbl19:
                    // 2 sources

                    ** while (currTerm.getStart() > currNCRNA.getEnd() + NCRNAAnnotater.termDownstreamRegionSize)
                }
lbl20:
                // 1 sources

                if (currTerm.getEnd() < currNCRNA.getStart() - NCRNAAnnotater.termDownstreamRegionSize) continue;
                while (currTerm.getEnd() >= currNCRNA.getStart() - NCRNAAnnotater.termDownstreamRegionSize) {
                    if (currTerm.getStart() <= currNCRNA.getEnd() + NCRNAAnnotater.termDownstreamRegionSize) {
                        currNCRNA.addTerminator(currTerm);
                    }
                    if (ncRNAit.hasNext()) {
                        currNCRNA = ncRNAit.next();
                        continue;
                    }
                    break block9;
                }
                break block9;
                while (true) {
                    ncRNAit.previous();
                    break;
                }
            }
            if (ncRNAit.nextIndex() != firstNCRNAtoCheck) ** continue;
            currNCRNA = ncRNAit.next();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void annotateWithSIDDSites(List<SIDDSite> sidds) {
        if (this.ncRNAs.size() == 0) {
            return;
        }
        ncRNAit = this.ncRNAs.listIterator();
        Collections.sort(this.ncRNAs);
        Collections.sort(sidds);
        while (ncRNAit.hasNext()) {
            ncRNAit.next().clearSIDDSites();
        }
        ncRNAit = this.ncRNAs.listIterator();
        firstNCRNAtoCheck = 0;
        currNCRNA = ncRNAit.next();
        for (SIDDSite currSidd : sidds) {
            block9: {
                if (!(currSidd.getMinIncEnergy() > NCRNAAnnotater.siddEnergyCutoff)) ** GOTO lbl19
                continue;
lbl-1000:
                // 1 sources

                {
                    if (!ncRNAit.hasNext()) {
                        return;
                    }
                    ++firstNCRNAtoCheck;
                    currNCRNA = ncRNAit.next();
lbl19:
                    // 2 sources

                    ** while (currSidd.getStart() > currNCRNA.getEnd() + NCRNAAnnotater.siddUpstreamRegionSize)
                }
lbl20:
                // 1 sources

                if (currSidd.getEnd() < currNCRNA.getStart() - NCRNAAnnotater.siddUpstreamRegionSize) continue;
                while (currSidd.getEnd() >= currNCRNA.getStart() - NCRNAAnnotater.siddUpstreamRegionSize) {
                    if (currSidd.getStart() <= currNCRNA.getEnd() + NCRNAAnnotater.siddUpstreamRegionSize) {
                        currNCRNA.addSIDDSite(currSidd);
                    }
                    if (ncRNAit.hasNext()) {
                        currNCRNA = ncRNAit.next();
                        continue;
                    }
                    break block9;
                }
                break block9;
                while (true) {
                    ncRNAit.previous();
                    break;
                }
            }
            if (ncRNAit.nextIndex() != firstNCRNAtoCheck) ** continue;
            currNCRNA = ncRNAit.next();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void annotateWithPCMatches(List<PCMatch> pcMatches) {
        if (this.ncRNAs.size() == 0) {
            return;
        }
        ncRNAit = this.ncRNAs.listIterator();
        Collections.sort(this.ncRNAs);
        Collections.sort(pcMatches);
        while (ncRNAit.hasNext()) {
            ncRNAit.next().clearPCMatches();
        }
        ncRNAit = this.ncRNAs.listIterator();
        firstNCRNAtoCheck = 0;
        currNCRNA = ncRNAit.next();
        for (PCMatch currPCM : pcMatches) {
            block9: {
                while (currPCM.getStart() > currNCRNA.getEnd() + NCRNAAnnotater.pcUpstreamRegionSize) {
                    if (!ncRNAit.hasNext()) {
                        return;
                    }
                    ++firstNCRNAtoCheck;
                    currNCRNA = ncRNAit.next();
                }
                if (currPCM.getEnd() < currNCRNA.getStart() - NCRNAAnnotater.pcUpstreamRegionSize) continue;
                while (currPCM.getEnd() >= currNCRNA.getStart() - NCRNAAnnotater.pcUpstreamRegionSize) {
                    if (currPCM.getStart() <= currNCRNA.getEnd() + NCRNAAnnotater.pcUpstreamRegionSize) {
                        currNCRNA.addPCMatch(currPCM);
                    }
                    if (ncRNAit.hasNext()) {
                        currNCRNA = ncRNAit.next();
                        continue;
                    }
                    break block9;
                }
                break block9;
                while (true) {
                    ncRNAit.previous();
                    break;
                }
            }
            if (ncRNAit.nextIndex() != firstNCRNAtoCheck) ** continue;
            currNCRNA = ncRNAit.next();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void annotateWithGenes(List<Gene> genes) {
        upDownStreamSize = 0;
        if (this.ncRNAs.size() == 0) {
            return;
        }
        ncRNAit = this.ncRNAs.listIterator();
        Collections.sort(this.ncRNAs);
        Collections.sort(genes);
        while (ncRNAit.hasNext()) {
            ncRNAit.next().clearGenes();
        }
        ncRNAit = this.ncRNAs.listIterator();
        firstNCRNAtoCheck = 0;
        currNCRNA = ncRNAit.next();
        for (Gene currGene : genes) {
            block9: {
                while (currGene.getStart() > currNCRNA.getEnd() + upDownStreamSize) {
                    if (!ncRNAit.hasNext()) {
                        return;
                    }
                    ++firstNCRNAtoCheck;
                    currNCRNA = ncRNAit.next();
                }
                if (currGene.getEnd() < currNCRNA.getStart() - upDownStreamSize) continue;
                while (currGene.getEnd() >= currNCRNA.getStart() - upDownStreamSize) {
                    if (currGene.getStart() <= currNCRNA.getEnd() + upDownStreamSize) {
                        currNCRNA.addGene(currGene);
                    }
                    if (ncRNAit.hasNext()) {
                        currNCRNA = ncRNAit.next();
                        continue;
                    }
                    break block9;
                }
                break block9;
                while (true) {
                    ncRNAit.previous();
                    break;
                }
            }
            if (ncRNAit.nextIndex() != firstNCRNAtoCheck) ** continue;
            currNCRNA = ncRNAit.next();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void annotateWithIGProbes(List<ArrayProbe> igProbes) {
        upDownStreamSize = 0;
        if (this.ncRNAs.size() == 0) {
            return;
        }
        ncRNAit = this.ncRNAs.listIterator();
        Collections.sort(this.ncRNAs);
        Collections.sort(igProbes);
        while (ncRNAit.hasNext()) {
            ncRNAit.next().clearIGProbes();
        }
        ncRNAit = this.ncRNAs.listIterator();
        firstNCRNAtoCheck = 0;
        currNCRNA = ncRNAit.next();
        for (ArrayProbe currProbe : igProbes) {
            block9: {
                while (currProbe.getStart() > currNCRNA.getEnd() + upDownStreamSize) {
                    if (!ncRNAit.hasNext()) {
                        return;
                    }
                    ++firstNCRNAtoCheck;
                    currNCRNA = ncRNAit.next();
                }
                if (currProbe.getEnd() < currNCRNA.getStart() - upDownStreamSize) continue;
                while (currProbe.getEnd() >= currNCRNA.getStart() - upDownStreamSize) {
                    if (currProbe.getStart() <= currNCRNA.getEnd() + upDownStreamSize) {
                        currNCRNA.addIGProbe(currProbe);
                    }
                    if (ncRNAit.hasNext()) {
                        currNCRNA = ncRNAit.next();
                        continue;
                    }
                    break block9;
                }
                break block9;
                while (true) {
                    ncRNAit.previous();
                    break;
                }
            }
            if (ncRNAit.nextIndex() != firstNCRNAtoCheck) ** continue;
            currNCRNA = ncRNAit.next();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void annotateWithRfamHits(List<RfamHit> rfamHit) {
        upDownStreamSize = 0;
        if (this.ncRNAs.size() == 0) {
            return;
        }
        ncRNAit = this.ncRNAs.listIterator();
        Collections.sort(this.ncRNAs);
        Collections.sort(rfamHit);
        while (ncRNAit.hasNext()) {
            ncRNAit.next().clearRfamHits();
        }
        ncRNAit = this.ncRNAs.listIterator();
        firstNCRNAtoCheck = 0;
        currNCRNA = ncRNAit.next();
        for (RfamHit currRfamHit : rfamHit) {
            block9: {
                while (currRfamHit.getStart() > currNCRNA.getEnd() + upDownStreamSize) {
                    if (!ncRNAit.hasNext()) {
                        return;
                    }
                    ++firstNCRNAtoCheck;
                    currNCRNA = ncRNAit.next();
                }
                if (currRfamHit.getEnd() < currNCRNA.getStart() - upDownStreamSize) continue;
                while (currRfamHit.getEnd() >= currNCRNA.getStart() - upDownStreamSize) {
                    if (currRfamHit.getStart() <= currNCRNA.getEnd() + upDownStreamSize) {
                        currNCRNA.addRfamHit(currRfamHit);
                    }
                    if (ncRNAit.hasNext()) {
                        currNCRNA = ncRNAit.next();
                        continue;
                    }
                    break block9;
                }
                break block9;
                while (true) {
                    ncRNAit.previous();
                    break;
                }
            }
            if (ncRNAit.nextIndex() != firstNCRNAtoCheck) ** continue;
            currNCRNA = ncRNAit.next();
        }
    }
}

