/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import efault.Main;
import genomic.ORF;
import java.util.LinkedList;
import java.util.List;
import seq.DNASequence;
import seq.SequenceTools;

public class ORFinder {
    private static int MAX_ORF_SIZE = 3000;
    private List<ORF> orfs;

    private boolean isStartCodon(int start, int end, DNASequence seq) {
        if (seq.getSubsequence(start, end).getSequenceString().equalsIgnoreCase("ATG")) {
            return true;
        }
        return seq.getSubsequence(start, end).getSequenceString().equalsIgnoreCase("GTG");
    }

    private boolean isStopCodon(int start, int end, DNASequence seq) {
        if (seq.getSubsequence(start, end).getSequenceString().equalsIgnoreCase("TAA")) {
            return true;
        }
        if (seq.getSubsequence(start, end).getSequenceString().equalsIgnoreCase("TGA")) {
            return true;
        }
        return seq.getSubsequence(start, end).getSequenceString().equalsIgnoreCase("TAG");
    }

    public void findORFs() {
        int j;
        this.orfs = new LinkedList<ORF>();
        int counter = 0;
        DNASequence seq = Main.genome.getSequence();
        int i = 0;
        while (i <= seq.getLength() - 2) {
            if (this.isStartCodon(i, i + 2, seq)) {
                j = i + 3;
                while (j <= seq.getLength() - 2 && j + 2 - i + 1 <= MAX_ORF_SIZE) {
                    if (this.isStopCodon(j, j + 2, seq)) {
                        this.orfs.add(new ORF("ORF_" + ++counter, i, j + 2, '+'));
                        break;
                    }
                    j += 3;
                }
            }
            ++i;
        }
        seq = SequenceTools.reverseComplementDNA(Main.genome.getSequence());
        i = 0;
        while (i <= seq.getLength() - 2) {
            if (this.isStartCodon(i, i + 2, seq)) {
                j = i + 3;
                while (j <= seq.getLength() - 2 && j + 2 - i + 1 <= MAX_ORF_SIZE) {
                    if (this.isStopCodon(j, j + 2, seq)) {
                        this.orfs.add(new ORF("ORF_" + ++counter, seq.getLength() - (j + 2) + 1, seq.getLength() - i + 1, '-'));
                        break;
                    }
                    j += 3;
                }
            }
            ++i;
        }
    }
}

