/*
 * Decompiled with CFR 0.152.
 */
package genomic;

import efault.Config;
import genomic.ArrayProbe;
import genomic.Gene;
import genomic.MASequenceFeature;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import seq.Sequence;
import sidd.SIDDSite;
import term.Terminator;

public class UTR
extends MASequenceFeature {
    private List<ArrayProbe> igProbes;
    private String parentGeneID;
    private boolean is5prime;

    public UTR() {
    }

    public UTR(String ID, int start, int end, char strand, String parentGeneID, boolean is5prime) {
        super(ID, start, end, strand);
        this.parentGeneID = parentGeneID;
        this.is5prime = is5prime;
    }

    @Override
    public boolean isSequenceConsitentWithFeatureType(Sequence seq) {
        return false;
    }

    @Override
    public String toGFFString() {
        return null;
    }

    public void addIGProbe(ArrayProbe probe) {
        this.igProbes.add(probe);
    }

    public void clearIGProbes() {
        this.igProbes = new LinkedList<ArrayProbe>();
    }

    public List<ArrayProbe> getIGProbes() {
        return this.igProbes;
    }

    public int numIGProbes() {
        return this.igProbes.size();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getID()) + "\t" + this.getStart() + "\t" + this.getEnd() + "\t" + this.getStrand() + "\t" + this.parentGeneID + "\t" + this.is5prime;
    }

    public String getParentGeneID() {
        return this.parentGeneID;
    }

    public boolean is5prime() {
        return this.is5prime;
    }

    /*
     * Unable to fully structure code
     */
    public static void annotateWithIGProbes(List<UTR> utrs, List<ArrayProbe> igProbes) {
        upDownStreamSize = 0;
        if (utrs.size() == 0) {
            return;
        }
        utrIt = utrs.listIterator();
        Collections.sort(utrs);
        Collections.sort(igProbes);
        while (utrIt.hasNext()) {
            utrIt.next().clearIGProbes();
        }
        utrIt = utrs.listIterator();
        firstUTRtoCheck = 0;
        currUTR = utrIt.next();
        for (ArrayProbe currProbe : igProbes) {
            block9: {
                while (currProbe.getStart() > currUTR.getEnd() + upDownStreamSize) {
                    if (!utrIt.hasNext()) {
                        return;
                    }
                    ++firstUTRtoCheck;
                    currUTR = utrIt.next();
                }
                if (currProbe.getEnd() < currUTR.getStart() - upDownStreamSize) continue;
                while (currProbe.getEnd() >= currUTR.getStart() - upDownStreamSize && currProbe.getStart() <= currUTR.getEnd() + upDownStreamSize) {
                    if (currUTR.getStrand() == currProbe.getStrand()) {
                        currUTR.addIGProbe(currProbe);
                    }
                    if (utrIt.hasNext()) {
                        currUTR = utrIt.next();
                        continue;
                    }
                    break block9;
                }
                break block9;
                while (true) {
                    utrIt.previous();
                    break;
                }
            }
            if (utrIt.nextIndex() != firstUTRtoCheck) ** continue;
            currUTR = utrIt.next();
        }
    }

    public static List<UTR> predictUTRs(List<Gene> genes, List<SIDDSite> sidds, List<Terminator> terms) {
        return UTR.predictUTRs(genes, sidds, terms, Config.getDouble("siddEnergyCutoff"), Config.getInt("transtermConfidenceCutoff"), Config.getInt("siddUpstreamRegionSize"), Config.getInt("termDownstreamRegionSize"));
    }

    public static List<UTR> predictUTRs(List<Gene> genes, List<SIDDSite> sidds, List<Terminator> terms, double siddThreshold, int termThreshold, int siddUpstreamRegionSize, int termDownstreamRegionSize) {
        LinkedList<UTR> res = new LinkedList<UTR>();
        if (genes.isEmpty()) {
            return res;
        }
        if (!sidds.isEmpty()) {
            block0: for (Gene currGene : genes) {
                SIDDSite currSIDD;
                ListIterator<SIDDSite> siddIt;
                if (currGene.getStrand() == '+') {
                    siddIt = sidds.listIterator(sidds.size());
                    while (siddIt.hasPrevious()) {
                        currSIDD = siddIt.previous();
                        if (currSIDD.getStart() > currGene.getStart()) continue;
                        if (currSIDD.getEnd() < currGene.getStart() - siddUpstreamRegionSize) break;
                        if (!(currSIDD.getMinIncEnergy() <= siddThreshold)) continue;
                        res.add(new UTR(String.valueOf(currGene.getID()) + "_5UTR", currSIDD.getStart(), currGene.getStart() - 1, currGene.getStrand(), currGene.getID(), true));
                        break;
                    }
                }
                if (currGene.getStrand() != '-') continue;
                siddIt = sidds.listIterator(0);
                while (siddIt.hasNext()) {
                    currSIDD = siddIt.next();
                    if (currSIDD.getEnd() < currGene.getEnd()) continue;
                    if (currSIDD.getStart() > currGene.getEnd() + siddUpstreamRegionSize) continue block0;
                    if (!(currSIDD.getMinIncEnergy() <= siddThreshold)) continue;
                    res.add(new UTR(String.valueOf(currGene.getID()) + "_5UTR", currGene.getEnd() + 1, currSIDD.getEnd(), currGene.getStrand(), currGene.getID(), true));
                    continue block0;
                }
            }
        }
        if (!terms.isEmpty()) {
            block3: for (Gene currGene : genes) {
                Terminator currTerm;
                ListIterator<Terminator> termIt;
                if (currGene.getStrand() == '-') {
                    termIt = terms.listIterator(terms.size());
                    while (termIt.hasPrevious()) {
                        currTerm = termIt.previous();
                        if (currTerm.getStart() > currGene.getStart() || currTerm.getStrand() != currGene.getStrand()) continue;
                        if (currTerm.getEnd() < currGene.getStart() - termDownstreamRegionSize) break;
                        if (currTerm.getConfidence() < termThreshold) continue;
                        res.add(new UTR(String.valueOf(currGene.getID()) + "_3UTR", currTerm.getStart(), currGene.getStart() - 1, currGene.getStrand(), currGene.getID(), false));
                        break;
                    }
                }
                if (currGene.getStrand() != '+') continue;
                termIt = terms.listIterator(0);
                while (termIt.hasNext()) {
                    currTerm = termIt.next();
                    if (currTerm.getEnd() < currGene.getEnd() || currTerm.getStrand() != currGene.getStrand()) continue;
                    if (currTerm.getStart() > currGene.getEnd() + termDownstreamRegionSize) continue block3;
                    if (currTerm.getConfidence() < termThreshold) continue;
                    res.add(new UTR(String.valueOf(currGene.getID()) + "_3UTR", currGene.getEnd() + 1, currTerm.getEnd(), currGene.getStrand(), currGene.getID(), false));
                    continue block3;
                }
            }
        }
        Collections.sort(res);
        return res;
    }

    public static List<UTR> predictUTRregions(List<Gene> genes, int regSize) {
        Iterator<Gene> genesIt = genes.iterator();
        LinkedList<UTR> res = new LinkedList<UTR>();
        while (genesIt.hasNext()) {
            Gene currGene = genesIt.next();
            if (currGene.getStrand() == '+') {
                res.add(new UTR(String.valueOf(currGene.getID()) + "_5UTRreg", currGene.getStart() - regSize, currGene.getStart() - 1, currGene.getStrand(), currGene.getID(), true));
                res.add(new UTR(String.valueOf(currGene.getID()) + "_3UTRreg", currGene.getEnd() + 1, currGene.getEnd() + regSize, currGene.getStrand(), currGene.getID(), false));
            }
            if (currGene.getStrand() != '-') continue;
            res.add(new UTR(String.valueOf(currGene.getID()) + "_5UTRreg", currGene.getEnd() + 1, currGene.getEnd() + regSize, currGene.getStrand(), currGene.getID(), true));
            res.add(new UTR(String.valueOf(currGene.getID()) + "_3UTRreg", currGene.getStart() - regSize, currGene.getStart() - 1, currGene.getStrand(), currGene.getID(), false));
        }
        Collections.sort(res);
        return res;
    }

    public static List<UTR> parseUTRTable(String filename) throws Exception {
        char COMMENT_CHAR = Config.getChar("commentChar");
        BufferedReader br = new BufferedReader(new FileReader(filename));
        LinkedList<UTR> utrs = new LinkedList<UTR>();
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).length() == 0) {
                line = br.readLine();
                continue;
            }
            if (line.charAt(0) == COMMENT_CHAR) {
                line = br.readLine();
                continue;
            }
            String[] lineFields = line.split("[\\s]+");
            String name = lineFields[0];
            int start = Integer.parseInt(lineFields[1]);
            int end = Integer.parseInt(lineFields[2]);
            char strand = lineFields[3].charAt(0);
            String parentGeneID = lineFields[4];
            boolean is5prime = Boolean.parseBoolean(lineFields[5]);
            utrs.add(new UTR(name, start, end, strand, parentGeneID, is5prime));
            line = br.readLine();
        }
        br.close();
        return utrs;
    }
}

