/*
 * Decompiled with CFR 0.152.
 */
package interact;

import efault.Config;
import genomic.AbstractSequenceFeature;
import interact.ThresholdProvider;
import interact.TranskriptInteraction;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;

public class GraphFileExporter {
    private static String veryGoodEnergyCol = Config.getString("veryGoodEnergyCol");
    private static String veryGoodLengthCol = Config.getString("veryGoodLengthCol");
    private static String goodEnergyAndLengthCol = Config.getString("goodEnergyAndLengthCol");
    private static String senseAntisenseCol = Config.getString("senseAntisenseCol");

    public static void writeDotFile(List<TranskriptInteraction> interactions, String filename) throws Exception {
        LinkedHashSet<AbstractSequenceFeature> hunters = new LinkedHashSet<AbstractSequenceFeature>();
        LinkedHashSet<AbstractSequenceFeature> targets = new LinkedHashSet<AbstractSequenceFeature>();
        ThresholdProvider tp = new ThresholdProvider(interactions);
        for (TranskriptInteraction i : interactions) {
            hunters.add(i.getHunter());
            targets.add(i.getTarget());
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        bw.append("# DOT file created by nocoRNAc\n# " + new Date().toGMTString() + "\n");
        bw.append("graph interactions {\n\tgraph [mindist=0.5];\n\tnode [style=filled, color=\"#9999CC\", fillcolor=\"#CCCCFF\"];\n");
        for (AbstractSequenceFeature sf : hunters) {
            bw.append("\t_" + sf.getID() + " [label=" + sf.getID() + ", shape=box, tooltip=" + sf.getID() + ", original_name=" + sf.getID() + "];\n");
        }
        for (AbstractSequenceFeature sf : targets) {
            bw.append("\t" + sf.getID() + " [label=" + sf.getID() + ", shape=ellipse, tooltip=" + sf.getID() + ", original_name=" + sf.getID() + "];\n");
        }
        for (TranskriptInteraction i : interactions) {
            String interCol = GraphFileExporter.getInteractionColor(i, tp);
            if (interCol == null) continue;
            bw.append("\t_" + i.getHunter().getID() + " -- " + i.getTarget().getID() + " [color=\"" + interCol + "\", original_name_start=" + i.getHunter().getID() + ", original_name_end=" + i.getTarget().getID() + "];\n");
        }
        bw.append("}");
        bw.close();
    }

    public static void writeGMLFile(List<TranskriptInteraction> interactions, String filename) throws Exception {
        LinkedHashSet<AbstractSequenceFeature> hunters = new LinkedHashSet<AbstractSequenceFeature>();
        LinkedHashSet<AbstractSequenceFeature> targets = new LinkedHashSet<AbstractSequenceFeature>();
        ThresholdProvider tp = new ThresholdProvider(interactions);
        System.out.println(tp.getVeryGoodEnergyThres());
        System.out.println(tp.getVeryGoodLengthThres());
        System.out.println(tp.getGoodEnergyThres());
        System.out.println(tp.getGoodLengthThres());
        for (TranskriptInteraction i : interactions) {
            hunters.add(i.getHunter());
            targets.add(i.getTarget());
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        bw.append("# GML file created by nocoRNAc\n# " + new Date().toGMTString() + "\n");
        bw.append("graph [id 0 version 0 graphics [] LabelGraphics []\n");
        for (AbstractSequenceFeature sf : hunters) {
            bw.append("node [id " + sf.hashCode() + " label \"" + sf.getID() + "\" graphics [type \"rectangle\"] LabelGraphics [type \"text\"]]\n");
        }
        for (AbstractSequenceFeature sf : targets) {
            bw.append("node [id " + sf.hashCode() + " label \"" + sf.getID() + "\" graphics [type \"oval\"] LabelGraphics [type \"text\"]]\n");
        }
        for (TranskriptInteraction i : interactions) {
            String interCol = GraphFileExporter.getInteractionColor(i, tp);
            if (interCol == null) continue;
            bw.append("edge [source " + i.getHunter().hashCode() + " target " + i.getTarget().hashCode() + " graphics [type \"line\" fill \"" + interCol + "\"] LabelGraphics [type \"text\"]]\n");
        }
        bw.append("]");
        bw.close();
    }

    private static String getInteractionColor(TranskriptInteraction interaction, ThresholdProvider tp) {
        if (interaction.isSenseAntisensePair()) {
            return senseAntisenseCol;
        }
        if (interaction.getEnergy() <= tp.getVeryGoodEnergyThres()) {
            return veryGoodEnergyCol;
        }
        if (interaction.getInteractionLength() >= tp.getVeryGoodLengthThres()) {
            return veryGoodLengthCol;
        }
        if (interaction.getEnergy() <= tp.getGoodEnergyThres() && interaction.getInteractionLength() >= tp.getGoodLengthThres()) {
            return goodEnergyAndLengthCol;
        }
        return null;
    }
}

