/*
 * Decompiled with CFR 0.152.
 */
package interact;

import genomic.AbstractSequenceFeature;
import interact.TranskriptInteraction;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import sidd.SIDDSettings;

public class InteractionMatrixBuilder {
    private List<TranskriptInteraction> interactions;
    private String[] names;
    private double[][] matrix;

    public InteractionMatrixBuilder(List<TranskriptInteraction> interactions) {
        this.interactions = interactions;
    }

    public void buildMatrix() {
        HashSet<AbstractSequenceFeature> rnasSet = new HashSet<AbstractSequenceFeature>();
        for (TranskriptInteraction ti : this.interactions) {
            rnasSet.add(ti.getHunter());
            rnasSet.add(ti.getTarget());
        }
        LinkedList rnas = new LinkedList(rnasSet);
        Comparator<AbstractSequenceFeature> lexi = new Comparator<AbstractSequenceFeature>(){

            @Override
            public int compare(AbstractSequenceFeature o1, AbstractSequenceFeature o2) {
                return o1.getID().compareTo(o2.getID());
            }
        };
        Collections.sort(rnas, lexi);
        int noe = rnas.size();
        this.names = new String[noe];
        this.matrix = new double[noe][noe];
        int i = 0;
        while (i < noe) {
            AbstractSequenceFeature tmpRNAi = (AbstractSequenceFeature)rnas.get(i);
            this.names[i] = tmpRNAi.getID();
            double Z = 0.0;
            for (TranskriptInteraction ti : tmpRNAi.getInteractions()) {
                Z += Math.exp(-(ti.getEnergy() / (SIDDSettings.GAS_CONSTANT * SIDDSettings.DEFAULT_TEMPERATURE)));
            }
            int j = 0;
            while (j < noe) {
                AbstractSequenceFeature tmpRNAj = (AbstractSequenceFeature)rnas.get(j);
                for (TranskriptInteraction ti : tmpRNAi.getInteractions()) {
                    if (ti.getHunter().equals(tmpRNAi)) {
                        if (!ti.getTarget().equals(tmpRNAj)) continue;
                        double[] dArray = this.matrix[i];
                        int n = j;
                        dArray[n] = dArray[n] + Math.exp(-(ti.getEnergy() / (SIDDSettings.GAS_CONSTANT * SIDDSettings.DEFAULT_TEMPERATURE)));
                        continue;
                    }
                    if (ti.getTarget().equals(tmpRNAi)) {
                        if (!ti.getHunter().equals(tmpRNAj)) continue;
                        double[] dArray = this.matrix[i];
                        int n = j;
                        dArray[n] = dArray[n] + Math.exp(-(ti.getEnergy() / (SIDDSettings.GAS_CONSTANT * SIDDSettings.DEFAULT_TEMPERATURE)));
                        continue;
                    }
                    System.out.println("WARNING: An RNA element has an interaction assigned in which it isn't involved! Will be ignored.");
                }
                double[] dArray = this.matrix[i];
                int n = j++;
                dArray[n] = dArray[n] / Z;
            }
            ++i;
        }
    }

    public String[] getNames() {
        return this.names;
    }

    public double[][] getMatrix() {
        return this.matrix;
    }
}

