/*
 * Decompiled with CFR 0.152.
 */
package promoter;

import efault.Config;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.LinkedList;
import java.util.List;
import promoter.PCMatch;

public class PCTableParser {
    private static final char COMMENT_CHAR = Config.getChar("commentChar");

    public static List<PCMatch> parseSIDDTable(String filename) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        LinkedList<PCMatch> sidds = new LinkedList<PCMatch>();
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).length() == 0) {
                line = br.readLine();
                continue;
            }
            if (line.charAt(0) == COMMENT_CHAR) {
                line = br.readLine();
                continue;
            }
            String[] lineFields = line.split("\\s");
            String id = lineFields[0];
            int start = Integer.parseInt(lineFields[1]);
            int end = Integer.parseInt(lineFields[2]);
            char strand = lineFields[3].charAt(0);
            String name = lineFields[4];
            sidds.add(new PCMatch(id, start, end, strand, name));
            line = br.readLine();
        }
        br.close();
        return sidds;
    }
}

