/*
 * Decompiled with CFR 0.152.
 */
package rfam;

import efault.Config;
import efault.ErrorStreamDumper;
import efault.Main;
import efault.ProcessStreamHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.LinkedList;
import java.util.List;
import rfam.CMSearchResultParser;
import rfam.CMSearchScanner;
import rfam.RfamHit;
import rfam.RfamSeed;

public class CMSearchScannerThread
extends Thread {
    private CMSearchScanner myScanner;
    private List<RfamHit> hits;
    private RfamSeed currSeed;
    private int myIndex;
    private File infernalPath;
    private File genomeFasta;
    private File tmpCM;
    private File tmpStockholm;
    private File tmpOut;
    public static double E_VALUE_CUTOFF = Config.getDouble("cmsearchEValueCutoff");
    public static boolean TC_CUTOFF = Config.getBoolean("cmsearchTCcutoff");

    public CMSearchScannerThread(CMSearchScanner scanner, File genomeFasta, int index) {
        this.myScanner = scanner;
        this.hits = new LinkedList<RfamHit>();
        this.myIndex = index;
        this.infernalPath = new File(Config.getString("infernalPath"));
        this.genomeFasta = genomeFasta;
        this.tmpCM = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/tmp" + this.myIndex + ".cm");
        this.tmpStockholm = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/tmp" + this.myIndex + ".seed");
        this.tmpOut = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/tmpcmsearch" + this.myIndex + ".out");
        this.tmpCM.deleteOnExit();
        this.tmpStockholm.deleteOnExit();
        this.tmpOut.deleteOnExit();
    }

    @Override
    public void run() {
        this.currSeed = this.myScanner.getNextSeed();
        while (this.currSeed != null) {
            try {
                System.out.println("Scanning for " + this.currSeed.getAC() + " (" + this.currSeed.getID() + ")...");
                BufferedWriter tmpFastaWriter = new BufferedWriter(new FileWriter(this.tmpStockholm));
                tmpFastaWriter.write(this.currSeed.toMinimalStockholmString());
                tmpFastaWriter.close();
                ProcessBuilder cmbuildPB = new ProcessBuilder(String.valueOf(this.infernalPath.getAbsolutePath()) + "/cmbuild", "-F", this.tmpCM.getAbsolutePath(), this.tmpStockholm.getAbsolutePath());
                cmbuildPB.redirectErrorStream(true);
                Process cmbuildP = cmbuildPB.start();
                ErrorStreamDumper errDumper = new ErrorStreamDumper(cmbuildP.getInputStream());
                errDumper.start();
                cmbuildP.waitFor();
                errDumper.join();
                cmbuildP.getInputStream().close();
                cmbuildP.getErrorStream().close();
                cmbuildP.getOutputStream().close();
                double tmpCutoff = TC_CUTOFF ? this.currSeed.getTC() : this.currSeed.getGA();
                ProcessBuilder cmsearchPB = new ProcessBuilder(String.valueOf(this.infernalPath.getAbsolutePath()) + "/cmsearch", "--noalign", "-T", Double.toString(tmpCutoff), this.tmpCM.getAbsolutePath(), this.genomeFasta.getAbsolutePath());
                Process cmsearchP = cmsearchPB.start();
                ProcessStreamHandler cmSH = new ProcessStreamHandler(cmsearchP.getInputStream(), this.tmpOut);
                errDumper = new ErrorStreamDumper(cmsearchP.getErrorStream());
                cmSH.start();
                errDumper.start();
                cmsearchP.waitFor();
                cmSH.join();
                errDumper.join();
                cmsearchP.getInputStream().close();
                cmsearchP.getOutputStream().close();
                cmsearchP.getErrorStream().close();
                this.hits.addAll(CMSearchResultParser.parse(this.tmpOut, this.currSeed));
                this.tmpCM.delete();
                this.tmpStockholm.delete();
                this.tmpOut.delete();
                if (this.myIndex == 0) {
                    System.gc();
                }
            }
            catch (Exception e) {
                System.err.println("An error occured while scanning for " + this.currSeed.getAC() + " (" + this.currSeed.getID() + "). " + e.getMessage() + "\n");
                e.printStackTrace();
            }
            this.currSeed = this.myScanner.getNextSeed();
        }
    }

    public List<RfamHit> getHits() {
        return this.hits;
    }
}

