/*
 * Decompiled with CFR 0.152.
 */
package rfam;

import efault.Config;
import efault.ErrorStreamDumper;
import efault.Main;
import efault.ProcessStreamHandler;
import genomic.Genome;
import genomic.NCRNA;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import rfam.RfamHit;
import rfam.RfamSeed;
import seq.DNASequence;
import seq.FASTAEntry;
import seq.FASTAWriter;

public class ErpinScanner {
    private List<RfamSeed> seeds;
    private List<NCRNA> ncrnas;
    private List<RfamHit> hits;
    private Genome genome;
    private List<RfamSeed> unscanableSeeds;
    private File erpinPath = new File(Config.getString("erpinPath"));
    private File[] ncrnasFasta;
    private File tmpEPN = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/tmp.epn");
    private File tmpFasta = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/seedtmp.fasta");
    private File[] tmpOut;
    private File tmpCommand = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/erpincomtmp.out");

    public ErpinScanner(List<RfamSeed> rfamSeeds, List<NCRNA> ncrnas, Genome genome) throws Exception {
        this.ncrnas = ncrnas;
        this.genome = genome;
        this.seeds = rfamSeeds;
        this.unscanableSeeds = new LinkedList<RfamSeed>();
        this.hits = new LinkedList<RfamHit>();
        int numCPUs = Main.numCPUs;
        if (ncrnas.size() < numCPUs) {
            numCPUs = 1;
        }
        this.ncrnasFasta = this.initNCRNAFastaFiles(numCPUs);
        this.tmpOut = this.initTmpOutFiles(numCPUs);
        this.tmpEPN.deleteOnExit();
        this.tmpFasta.deleteOnExit();
        this.tmpCommand.deleteOnExit();
    }

    private void writeNCRNAFasta() throws Exception {
        int seqsPerThread = (int)Math.ceil((double)this.ncrnas.size() / (double)this.ncrnasFasta.length);
        Iterator<NCRNA> ncrnaIt = this.ncrnas.iterator();
        int threadIndex = 0;
        while (threadIndex < this.ncrnasFasta.length) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.ncrnasFasta[threadIndex]));
            LinkedList<FASTAEntry> fastas = new LinkedList<FASTAEntry>();
            int i = 0;
            while (i < seqsPerThread && ncrnaIt.hasNext()) {
                NCRNA currNCRNA = ncrnaIt.next();
                fastas.add(new FASTAEntry<DNASequence>(currNCRNA.getID(), this.genome.getSequence().getSubsequence(currNCRNA.getStart(), currNCRNA.getEnd())));
                ++i;
            }
            FASTAWriter.write(bw, fastas);
            bw.close();
            ++threadIndex;
        }
    }

    private File[] initNCRNAFastaFiles(int numOfFiles) {
        File[] res = new File[numOfFiles];
        int i = 0;
        while (i < res.length) {
            res[i] = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/ncrnastmp" + i + ".fasta");
            res[i].deleteOnExit();
            ++i;
        }
        return res;
    }

    private File[] initTmpOutFiles(int numOfFiles) {
        File[] res = new File[numOfFiles];
        int i = 0;
        while (i < res.length) {
            res[i] = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/erpintmp" + i + ".out");
            res[i].deleteOnExit();
            ++i;
        }
        return res;
    }

    private String[] determineErpinOptions() throws Exception {
        ArrayList<String> res = new ArrayList<String>();
        res.add(String.valueOf(this.erpinPath.getAbsolutePath()) + "/bin/erpin");
        res.add(this.tmpEPN.getAbsolutePath());
        res.add("insertNcrnasFastaFileNameHere");
        res.add(this.getCompleteRegString(this.erpinSStoIntArray()));
        List<String> erpinComPlStrings = this.getErpincommandPlRes();
        if (erpinComPlStrings.get(0).equals("D'oh!")) {
            String[] doh = new String[]{"D'oh!"};
            return doh;
        }
        res.addAll(erpinComPlStrings);
        return res.toArray(new String[res.size()]);
    }

    private List<String> getErpincommandPlRes() throws Exception {
        LinkedList<String> res = new LinkedList<String>();
        ProcessBuilder erpincommandPlPB = new ProcessBuilder(String.valueOf(this.erpinPath.getAbsolutePath()) + "/scripts/erpincommand.pl", this.tmpEPN.getAbsolutePath());
        try {
            erpincommandPlPB.environment().put("PATH", String.valueOf(this.erpinPath.getAbsolutePath()) + "/bin");
        }
        catch (Exception e) {
            System.err.println("The appropriate environment for erpincommand.pl could not be established on this system. Erpin scans can not be performed.");
            throw e;
        }
        Process erpincommandPlP = erpincommandPlPB.start();
        ProcessStreamHandler erpinComH = new ProcessStreamHandler(erpincommandPlP.getInputStream(), this.tmpCommand);
        ErrorStreamDumper errorDumper = new ErrorStreamDumper(erpincommandPlP.getErrorStream());
        erpinComH.run();
        errorDumper.run();
        erpincommandPlP.waitFor();
        erpinComH.join();
        BufferedReader comR = new BufferedReader(new FileReader(this.tmpCommand));
        String line = comR.readLine();
        while (line != null) {
            if (line.trim().equals("BEST ERPIN COMMAND:")) break;
            line = comR.readLine();
        }
        if (line == null) {
            res.add("D'oh!");
            return res;
        }
        line = comR.readLine();
        String[] lineFields = line.trim().split("[\\s]+");
        int i = 0;
        while (!lineFields[i].equals("-add")) {
            ++i;
        }
        while (!lineFields[i].equals("-pcw")) {
            res.add(lineFields[i]);
            ++i;
        }
        res.add("-nomask");
        while (i < lineFields.length) {
            res.add(lineFields[i]);
            ++i;
        }
        res.add(lineFields[lineFields.length - 1]);
        return res;
    }

    private List<StructureElement> gatherStructureElements() throws Exception {
        String line;
        BufferedReader tstatR;
        Process tstatP;
        ProcessBuilder tstatPB;
        Iterator resIt;
        boolean idExists;
        LinkedList<StructureElement> res = new LinkedList<StructureElement>();
        int[] idArray = this.erpinSStoIntArray();
        int currId = idArray[0];
        int lastId = idArray[0];
        int length = 0;
        double mean = 0.0;
        double min = 0.0;
        int i = 0;
        while (i < idArray.length) {
            currId = idArray[i];
            if (currId != lastId) {
                idExists = false;
                resIt = res.iterator();
                while (resIt.hasNext()) {
                    if (((StructureElement)resIt.next()).id != lastId) continue;
                    idExists = true;
                    break;
                }
                if (!idExists) {
                    tstatPB = new ProcessBuilder(String.valueOf(this.erpinPath.getAbsolutePath()) + "/bin/tstat", this.tmpEPN.getAbsolutePath(), this.getCompleteRegString(idArray), "-umask", Integer.toString(lastId));
                    tstatPB.redirectErrorStream(true);
                    tstatP = tstatPB.start();
                    tstatR = new BufferedReader(new InputStreamReader(tstatP.getInputStream()));
                    line = tstatR.readLine();
                    while (line != null) {
                        if ((line = line.trim()).split("[\\s]+")[0].equalsIgnoreCase("min:")) {
                            min = Double.parseDouble(line.split("[\\s]+")[1]);
                        } else if (line.split("[\\s]+")[0].equalsIgnoreCase("mean:")) {
                            mean = Double.parseDouble(line.split("[\\s]+")[1]);
                        }
                        line = tstatR.readLine();
                    }
                    tstatP.waitFor();
                    tstatR.close();
                    length = 0;
                    int j = 0;
                    while (j < idArray.length) {
                        if (idArray[j] == lastId) {
                            ++length;
                        }
                        ++j;
                    }
                    res.add(new StructureElement(lastId, mean / (double)length, min, length));
                }
            }
            lastId = currId;
            ++i;
        }
        idExists = false;
        resIt = res.iterator();
        while (resIt.hasNext()) {
            if (((StructureElement)resIt.next()).id != lastId) continue;
            idExists = true;
            break;
        }
        if (!idExists) {
            tstatPB = new ProcessBuilder(String.valueOf(this.erpinPath.getAbsolutePath()) + "/bin/tstat", this.tmpEPN.getAbsolutePath(), this.getCompleteRegString(idArray), "-umask", Integer.toString(lastId));
            tstatPB.redirectErrorStream(true);
            tstatP = tstatPB.start();
            tstatR = new BufferedReader(new InputStreamReader(tstatP.getInputStream()));
            line = tstatR.readLine();
            while (line != null) {
                if ((line = line.trim()).split("[\\s]+")[0].equalsIgnoreCase("min:")) {
                    min = Double.parseDouble(line.split("[\\s]+")[1]);
                } else if (line.split("[\\s]+")[0].equalsIgnoreCase("mean:")) {
                    mean = Double.parseDouble(line.split("[\\s]+")[1]);
                }
                line = tstatR.readLine();
            }
            tstatP.waitFor();
            tstatR.close();
            length = 0;
            int j = 0;
            while (j < idArray.length) {
                if (idArray[j] == lastId) {
                    ++length;
                }
                ++j;
            }
            res.add(new StructureElement(lastId, mean / (double)length, min, length));
        }
        return res;
    }

    private int[] erpinSStoIntArray() throws Exception {
        BufferedReader epnR = new BufferedReader(new FileReader(this.tmpEPN));
        String currLine = epnR.readLine();
        while (currLine.trim().charAt(0) != '>') {
            currLine = epnR.readLine();
        }
        String upperLine = epnR.readLine().trim();
        String lowerLine = epnR.readLine().trim();
        epnR.close();
        int[] res = new int[upperLine.length()];
        if (lowerLine.charAt(0) == '>') {
            int i = 0;
            while (i < res.length) {
                res[i] = Integer.parseInt(String.valueOf(upperLine.charAt(i)));
                ++i;
            }
        } else {
            int i = 0;
            while (i < res.length) {
                res[i] = Integer.parseInt(String.valueOf(String.valueOf(upperLine.charAt(i))) + String.valueOf(lowerLine.charAt(i)));
                ++i;
            }
        }
        return res;
    }

    private String getCompleteRegString(int[] ssArray) {
        int first = ssArray[0];
        int last = ssArray[ssArray.length - 1];
        int i = 0;
        while (i < ssArray.length && ssArray[i] == first) {
            ++i;
        }
        while (i < ssArray.length) {
            if (ssArray[i] == first) {
                return String.valueOf(-first) + "," + last;
            }
            ++i;
        }
        return String.valueOf(first) + "," + last;
    }

    public List<RfamHit> getHits() {
        return this.hits;
    }

    public List<RfamSeed> getUnscanableSeeds() {
        return this.unscanableSeeds;
    }

    private class StructureElement {
        int id;
        double meanScore;
        double minScore;
        int length;

        public StructureElement(int id, double meanScore, double minScore, int length) {
            this.id = id;
            this.meanScore = meanScore;
            this.minScore = minScore;
            this.length = length;
        }
    }
}

