/*
 * Decompiled with CFR 0.152.
 */
package rfam;

import efault.Main;
import genomic.MASequenceFeature;
import rfam.RfamSeed;
import seq.Sequence;

public class RfamHit
extends MASequenceFeature {
    private String source;
    private double score;
    private double eValue;
    private String AC;
    private String seedID;
    private String DE;
    private String TP;

    public RfamHit(String ID, int start, int end, char strand, RfamSeed seed, String source, double score, double eValue) {
        super(ID, start, end, strand);
        this.source = source;
        this.score = score;
        this.eValue = eValue;
        this.AC = seed.getAC();
        this.seedID = seed.getID();
        this.DE = seed.getDE();
        this.TP = seed.getTP();
    }

    public RfamHit(String ID, int start, int end, char strand, String AC, String seedID, String DE, String TP, String source, double score, double eValue) {
        super(ID, start, end, strand);
        this.source = source;
        this.score = score;
        this.eValue = eValue;
        this.AC = AC;
        this.seedID = seedID;
        this.DE = DE;
        this.TP = TP;
    }

    public String getSource() {
        return this.source;
    }

    public double getScore() {
        return this.score;
    }

    public double getEValue() {
        return this.eValue;
    }

    public String getAC() {
        return this.AC;
    }

    public String getSeedID() {
        return this.seedID;
    }

    public String getDE() {
        return this.DE;
    }

    public String getTP() {
        return this.TP;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "\t" + this.AC + "\t" + this.seedID + "\t" + this.DE + "\t" + this.TP + "\t" + this.source + "\t" + this.score + "\t" + this.eValue;
    }

    @Override
    public String toGFFString() {
        String mandatory = String.valueOf(Main.genome.getID()) + "\t" + this.source + "\t" + "rfam_motif" + "\t" + this.getStart() + "\t" + this.getEnd() + "\t" + this.score + "\t" + this.getStrand() + "\t" + ".";
        String attributes = "\tRfam_Seed=" + this.AC + "; Description=" + this.DE + "; E_value=" + this.getEValue();
        return String.valueOf(mandatory) + attributes;
    }

    @Override
    public boolean isSequenceConsitentWithFeatureType(Sequence seq) {
        return false;
    }
}

