/*
 * Decompiled with CFR 0.152.
 */
package rfam;

import java.util.Iterator;
import java.util.List;
import seq.FASTAEntry;
import seq.RNASequence;

public class RfamSeed {
    private String AC;
    private String ID;
    private String DE;
    private String TP;
    private double GA;
    private double TC;
    private List<FASTAEntry<RNASequence>> alignment;
    private String SSCons;

    public RfamSeed(String ac, String id, String de, String tp, double ga, double tc, List<FASTAEntry<RNASequence>> alignment, String cons) {
        this.AC = ac;
        this.ID = id;
        this.DE = de;
        this.TP = tp;
        this.GA = ga;
        this.TC = tc;
        this.alignment = alignment;
        this.SSCons = cons.replace('>', ')').replace('<', '(');
    }

    public void removeGappedColumns() {
        String[] stringFields;
        int i;
        int maxColGaps = this.alignment.size() / 10;
        boolean[] delColumn = new boolean[this.SSCons.length()];
        boolean[] posToSingleStrand = new boolean[this.SSCons.length()];
        int pos = 1;
        while (pos <= this.SSCons.length()) {
            int currColGaps = 0;
            Iterator<FASTAEntry<RNASequence>> alignIt = this.alignment.iterator();
            while (alignIt.hasNext()) {
                if (alignIt.next().getSequence().getSymbolAt(pos) != '-') continue;
                ++currColGaps;
            }
            if (currColGaps > maxColGaps) {
                delColumn[pos - 1] = true;
            }
            ++pos;
        }
        StringBuffer currSequence = new StringBuffer(this.SSCons.length() + 2);
        currSequence.ensureCapacity(this.SSCons.length() + 2);
        for (FASTAEntry<RNASequence> currFasta : this.alignment) {
            currSequence.setLength(0);
            currSequence.append(currFasta.getSequence().getSequenceString());
            i = 0;
            while (i < delColumn.length) {
                if (delColumn[i]) {
                    currSequence.setCharAt(i, '$');
                }
                ++i;
            }
            stringFields = currSequence.toString().split("[$]+");
            currSequence.setLength(0);
            i = 0;
            while (i < stringFields.length) {
                currSequence.append(stringFields[i]);
                ++i;
            }
            currFasta.getSequence().setSequenceString(currSequence.toString());
        }
        currSequence.setLength(0);
        currSequence.append(this.SSCons);
        i = 0;
        while (i < delColumn.length) {
            if (delColumn[i]) {
                currSequence.setCharAt(i, '$');
            } else if (posToSingleStrand[i]) {
                currSequence.setCharAt(i, '.');
            }
            ++i;
        }
        stringFields = currSequence.toString().split("[$]+");
        currSequence.setLength(0);
        i = 0;
        while (i < stringFields.length) {
            currSequence.append(stringFields[i]);
            ++i;
        }
        this.SSCons = currSequence.toString();
    }

    private int getParentPairMatchingPos(int pos) {
        int pos2;
        int pos1 = pos;
        int stackCount = 1;
        if (this.SSCons.charAt(pos) == '(') {
            pos2 = pos + 1;
            while (pos2 < this.SSCons.length()) {
                if (this.SSCons.charAt(pos2) == '(') {
                    ++stackCount;
                }
                if (this.SSCons.charAt(pos2) == ')') {
                    --stackCount;
                }
                if (stackCount != 0) {
                    ++pos2;
                    continue;
                }
                break;
            }
        } else if (this.SSCons.charAt(pos) == ')') {
            pos2 = pos - 1;
            while (pos2 >= 0) {
                if (this.SSCons.charAt(pos2) == ')') {
                    ++stackCount;
                }
                if (this.SSCons.charAt(pos2) == '(') {
                    --stackCount;
                }
                if (stackCount != 0) {
                    --pos2;
                    continue;
                }
                break;
            }
        } else {
            return pos;
        }
        return pos2;
    }

    public String getAC() {
        return this.AC;
    }

    public String getID() {
        return this.ID;
    }

    public String getDE() {
        return this.DE;
    }

    public String getTP() {
        return this.TP;
    }

    public double getGA() {
        return this.GA;
    }

    public double getTC() {
        return this.TC;
    }

    public List<FASTAEntry<RNASequence>> getAlignment() {
        return this.alignment;
    }

    public String getSSCons() {
        return this.SSCons;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("AC\t" + this.AC + "\n" + "ID\t" + this.ID + "\n" + "DE\t" + this.DE + "\n" + "TP\t" + this.TP + "\n");
        res.append(">secondary structure consensus\n" + this.SSCons + "\n");
        for (FASTAEntry<RNASequence> fa : this.alignment) {
            res.append(">" + fa.getID() + "\n");
            res.append(String.valueOf(fa.getSequence().getSequenceString()) + "\n");
        }
        return res.toString();
    }

    public String toMinimalStockholmString() {
        StringBuffer res = new StringBuffer();
        res.append("# STOCKHOLM 1.0\n");
        for (FASTAEntry<RNASequence> fa : this.alignment) {
            res.append(String.valueOf(fa.getID()) + "\t");
            res.append(String.valueOf(fa.getSequence().getSequenceString()) + "\n");
        }
        res.append("#=GC SS_cons\t" + this.SSCons + "\n");
        res.append("//");
        return res.toString();
    }
}

