/*
 * Decompiled with CFR 0.152.
 */
package sidd;

import efault.Main;
import genomic.AbstractSequenceFeature;
import seq.Sequence;

public class SIDDSite
extends AbstractSequenceFeature {
    private double minIncEnergy;
    private char geneContext = (char)88;

    public SIDDSite() {
        this.minIncEnergy = 0.0;
    }

    public SIDDSite(String ID, int start, int end, char strand, double minIncEnergy) {
        super(ID, start, end, strand);
        this.minIncEnergy = minIncEnergy;
    }

    public char getGeneContext() {
        return this.geneContext;
    }

    public void setGeneContext(char geneContext) {
        this.geneContext = geneContext;
    }

    @Override
    public boolean isSequenceConsitentWithFeatureType(Sequence seq) {
        return true;
    }

    public double getMinIncEnergy() {
        return this.minIncEnergy;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "\t" + Math.rint(this.minIncEnergy * 10.0) / 10.0 + "\t" + this.geneContext;
    }

    @Override
    public String toGFFString() {
        String mandatory = String.valueOf(Main.genome.getID()) + "\t" + "nocoRNAc" + "\t" + "sidd_site" + "\t" + this.getStart() + "\t" + this.getEnd() + "\t" + this.getMinIncEnergy() + "\t" + this.getStrand() + "\t" + ".";
        String attributes = "\tID=" + this.getID();
        return String.valueOf(mandatory) + attributes;
    }
}

