/*
 * Decompiled with CFR 0.152.
 */
package term;

import efault.Config;
import efault.ErrorStreamDumper;
import efault.Main;
import efault.ProcessStreamHandler;
import genomic.NCRNA;
import genomic.NCRNATableParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.List;
import seq.DNASequence;
import seq.FASTAEntry;
import seq.FASTAParser;
import term.Terminator;
import term.TransTermParser;

public class TransTermScanner {
    private static int CONFIDENCE_CUTOFF = 30;
    private File transtermPath = new File(Config.getString("transtermPath"));
    private File tmpOut = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/transtermtmp.tt");
    private File tmpNCOut = new File(String.valueOf(Main.dataDir.getAbsolutePath()) + "/transtermnc.crd");
    private File genomeFile;
    private File ncRNAcrdFile;
    private List<Terminator> terminators;

    public TransTermScanner(File genomeFile) {
        this.genomeFile = genomeFile;
        this.tmpOut.deleteOnExit();
        this.tmpNCOut.deleteOnExit();
    }

    public void scan() throws Exception {
        this.writePseudoAnnoTable();
        ProcessBuilder ttermPB = new ProcessBuilder(String.valueOf(this.transtermPath.getAbsolutePath()) + "/transterm", "-p", String.valueOf(this.transtermPath.getAbsolutePath()) + "/expterm.dat", "--all", "-c", Integer.toString(CONFIDENCE_CUTOFF), "-S", this.genomeFile.getAbsolutePath(), this.tmpNCOut.getAbsolutePath());
        Process ttermP = ttermPB.start();
        ProcessStreamHandler ttermSHandler = new ProcessStreamHandler(ttermP.getInputStream(), this.tmpOut);
        ErrorStreamDumper errD = new ErrorStreamDumper(ttermP.getErrorStream());
        ttermSHandler.run();
        errD.run();
        ttermP.waitFor();
        ttermSHandler.join();
        TransTermParser ttParser = new TransTermParser(this.tmpOut.getAbsolutePath());
        ttParser.parse();
        this.terminators = ttParser.getTerminators();
    }

    private void writeTransTermNCRNATable() throws Exception {
        List<NCRNA> ncrnas = NCRNATableParser.parseNCRNATable(this.ncRNAcrdFile.getAbsolutePath());
        FASTAEntry<DNASequence> genomeFasta = FASTAParser.parseDNA(new BufferedReader(new FileReader("data/NC_003888.fasta"))).get(0);
        String genomeID = genomeFasta.getID().trim().split("[\\s]+")[0];
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.tmpNCOut));
        for (NCRNA currNC : ncrnas) {
            bw.write(String.valueOf(currNC.getID()) + "\t" + currNC.getStart() + "\t" + currNC.getEnd() + "\t" + genomeID);
            bw.newLine();
        }
        bw.close();
    }

    private void writePseudoAnnoTable() throws Exception {
        String genomeID = Main.genome.getID();
        BufferedWriter bw = new BufferedWriter(new FileWriter(this.tmpNCOut));
        bw.write("pseudo1\t1\t3\t" + genomeID);
        bw.newLine();
        bw.write("pseudo2\t" + (Main.genome.getEnd() - 2) + "\t" + Main.genome.getEnd() + "\t" + genomeID);
        bw.close();
    }

    public List<Terminator> getTerminators() {
        return this.terminators;
    }
}

